/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.init;

import codechicken.lib.datagen.ItemModelProvider;
import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.translocators.init.TranslocatorsModContent;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="translocators", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherDataGenerators(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper files = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, files));
        gen.addProvider(event.includeClient(), (DataProvider)new BlockStates(output, files));
        BlockTags blockTags = new BlockTags(output, lookupProvider, files);
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTags(output, lookupProvider, blockTags.m_274426_(), files));
        gen.addProvider(event.includeServer(), (DataProvider)new Recipes(output));
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "translocators", existingFileHelper);
        }

        protected void registerModels() {
            this.generated((Supplier)TranslocatorsModContent.itemTranslocatorItem).texture(null);
            this.generated((Supplier)TranslocatorsModContent.fluidTranslocatorItem).texture(null);
            this.generated((Supplier)TranslocatorsModContent.diamondNuggetItem);
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "translocators", exFileHelper);
        }

        protected void registerStatesAndModels() {
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("dummy", "block")).texture("particle", "translocators:blocks/crafting_grid");
            this.simpleBlock((Block)TranslocatorsModContent.blockCraftingGrid.get(), (ModelFile)model);
        }
    }

    private static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper files) {
            super(output, lookupProvider, "translocators", files);
        }

        protected void m_6577_(HolderLookup.Provider pProvider) {
        }
    }

    private static class ItemTags
    extends ItemTagsProvider {
        public ItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, ExistingFileHelper files) {
            super(output, lookupProvider, blockTagProvider, "translocators", files);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(TranslocatorsModContent.diamondNuggetTag).m_255245_((Object)((Item)TranslocatorsModContent.diamondNuggetItem.get()));
            this.m_206424_(Tags.Items.NUGGETS).m_255245_((Object)((Item)TranslocatorsModContent.diamondNuggetItem.get()));
            this.m_206424_(TranslocatorsModContent.regulateItemsTag).addTags(new TagKey[]{TranslocatorsModContent.diamondNuggetTag});
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput output) {
            super(output, "translocators");
        }

        protected void registerRecipes() {
            this.shapelessRecipe((ItemLike)Items.f_42415_).addIngredient((ItemLike)TranslocatorsModContent.diamondNuggetItem.get(), 9);
            this.shapelessRecipe((ItemLike)TranslocatorsModContent.diamondNuggetItem.get(), 9).addIngredient((ItemLike)Items.f_42415_);
            this.shapedRecipe((ItemLike)TranslocatorsModContent.itemTranslocatorItem.get(), 2).patternLine("RER").patternLine("IPI").patternLine("RGR").key('R', Tags.Items.DUSTS_REDSTONE).key('E', Tags.Items.ENDER_PEARLS).key('I', Tags.Items.INGOTS_IRON).key('P', (ItemLike)Items.f_41869_).key('G', Tags.Items.INGOTS_GOLD);
            this.shapedRecipe((ItemLike)TranslocatorsModContent.fluidTranslocatorItem.get(), 2).patternLine("RER").patternLine("IPI").patternLine("RLR").key('R', Tags.Items.DUSTS_REDSTONE).key('E', Tags.Items.ENDER_PEARLS).key('I', Tags.Items.INGOTS_IRON).key('P', (ItemLike)Items.f_41869_).key('L', Tags.Items.GEMS_LAPIS);
        }
    }
}

