/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth.util;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mrbysco.neoauth.NeoAuth;
import com.mrbysco.neoauth.mixin.AbuseReportContextAccessor;
import com.mrbysco.neoauth.mixin.MinecraftClientAccessor;
import com.mrbysco.neoauth.mixin.RealmsMainScreenAccessor;
import com.mrbysco.neoauth.mixin.SplashTextResourceSupplierAccessor;
import com.mrbysco.neoauth.mixin.YggdrasilAuthenticationServiceAccessor;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;

public final class SessionUtils {
    public static final String OFFLINE_TOKEN = "invalidtoken";
    public static final long STATUS_TTL = 60000L;
    private static long lastStatusCheck;
    private static SessionStatus lastStatus;

    private SessionUtils() {
    }

    public static User getSession() {
        return Minecraft.m_91087_().m_91094_();
    }

    public static void setSession(User user) {
        Minecraft client = Minecraft.m_91087_();
        ((MinecraftClientAccessor)client).setUser(user);
        ((SplashTextResourceSupplierAccessor)client.m_91310_()).setUser(user);
        client.m_91095_().clear();
        client.m_91095_();
        UserApiService userApiService = UserApiService.OFFLINE;
        if (!OFFLINE_TOKEN.equals(user.m_92547_())) {
            try {
                userApiService = SessionUtils.getAuthService().createUserApiService(user.m_92547_());
            }
            catch (AuthenticationException e) {
                NeoAuth.LOGGER.error("Failed to verify authentication for new user API service!", (Throwable)e);
            }
        }
        ((MinecraftClientAccessor)client).setUserApiService(userApiService);
        ((MinecraftClientAccessor)client).setPlayerSocialManager(new PlayerSocialManager(client, userApiService));
        ((MinecraftClientAccessor)client).setProfileKeyPairManager(ProfileKeyPairManager.m_252915_((UserApiService)userApiService, (User)user, (Path)client.f_91069_.toPath()));
        ((MinecraftClientAccessor)client).setReportingContext(ReportingContext.m_239685_((ReportEnvironment)((AbuseReportContextAccessor)client.m_239211_()).getEnvironment(), (UserApiService)userApiService));
        RealmsClient realmsClient = RealmsClient.m_239151_((Minecraft)client);
        ((MinecraftClientAccessor)client).setRealmsDataFetcher(new RealmsDataFetcher(realmsClient));
        RealmsMainScreenAccessor.setCheckedClientCompatability(false);
        RealmsMainScreenAccessor.setRealmsGenericErrorScreen(null);
        lastStatus = SessionStatus.UNKNOWN;
        lastStatusCheck = 0L;
        NeoAuth.LOGGER.info("Minecraft user for {} (uuid={}) has been applied", (Object)user.m_92546_(), (Object)user.m_92545_());
    }

    public static User offline(String username) {
        return new User(username, UUID.nameUUIDFromBytes(("offline:" + username).getBytes()).toString(), OFFLINE_TOKEN, Optional.empty(), Optional.empty(), User.Type.LEGACY);
    }

    public static CompletableFuture<SessionStatus> getStatus() {
        if (System.currentTimeMillis() - lastStatusCheck < 60000L) {
            return CompletableFuture.completedFuture(lastStatus);
        }
        return CompletableFuture.supplyAsync(() -> {
            User session = SessionUtils.getSession();
            GameProfile profile = session.m_92548_();
            String token = session.m_92547_();
            String id = UUID.randomUUID().toString();
            YggdrasilMinecraftSessionService sessionService = SessionUtils.getSessionService();
            try {
                NeoAuth.LOGGER.info("Verifying Minecraft session...");
                sessionService.joinServer(profile, token, id);
                if (sessionService.hasJoinedServer(profile, id, null).isComplete()) {
                    NeoAuth.LOGGER.info("The Minecraft session is valid");
                    lastStatus = SessionStatus.VALID;
                } else {
                    NeoAuth.LOGGER.warn("The Minecraft session is invalid!");
                    lastStatus = SessionStatus.INVALID;
                }
            }
            catch (AuthenticationException e) {
                NeoAuth.LOGGER.error("Could not validate the Minecraft session!", (Throwable)e);
                lastStatus = SessionStatus.OFFLINE;
            }
            lastStatusCheck = System.currentTimeMillis();
            return lastStatus;
        });
    }

    public static YggdrasilMinecraftSessionService getSessionService() {
        return (YggdrasilMinecraftSessionService)Minecraft.m_91087_().m_91108_();
    }

    public static YggdrasilAuthenticationService getAuthService() {
        YggdrasilAuthenticationService authService = SessionUtils.getSessionService().getAuthenticationService();
        if (((YggdrasilAuthenticationServiceAccessor)authService).getClientToken() == null) {
            ((YggdrasilAuthenticationServiceAccessor)authService).setClientToken(UUID.randomUUID().toString());
        }
        return authService;
    }

    public static YggdrasilUserAuthentication getAuthProvider() {
        return (YggdrasilUserAuthentication)SessionUtils.getAuthService().createUserAuthentication(Agent.MINECRAFT);
    }

    static {
        lastStatus = SessionStatus.UNKNOWN;
    }

    public static enum SessionStatus {
        VALID,
        INVALID,
        OFFLINE,
        UNKNOWN;

    }
}

