/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth.impl.gui;

import com.mrbysco.neoauth.NeoAuth;
import com.mrbysco.neoauth.api.gui.AuthScreen;
import com.mrbysco.neoauth.util.MicrosoftUtils;
import com.mrbysco.neoauth.util.SessionUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.http.conn.ConnectTimeoutException;

public class MicrosoftAuthScreen
extends AuthScreen {
    private ExecutorService executor = null;
    private CompletableFuture<Void> task = null;
    private Component status = null;
    private final boolean selectAccount;

    public MicrosoftAuthScreen(Screen parentScreen, Screen successScreen, boolean selectAccount) {
        super((Component)Component.m_237115_((String)"gui.neo_auth.microsoft.title"), parentScreen, successScreen);
        this.selectAccount = selectAccount;
        this.closeOnSuccess = true;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ == null) {
            return;
        }
        Button cancelBtn = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ / 2 + 22, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancelBtn);
        if (this.task != null) {
            return;
        }
        this.status = Component.m_237115_((String)"gui.neo_auth.microsoft.status.checkBrowser");
        this.executor = Executors.newSingleThreadExecutor();
        this.task = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)MicrosoftUtils.acquireMSAuthCode(success -> Component.m_237115_((String)"gui.neo_auth.microsoft.browser").getString(), this.executor, this.selectAccount ? MicrosoftUtils.MicrosoftPrompt.SELECT_ACCOUNT : null).thenComposeAsync(msAuthCode -> {
            this.status = Component.m_237115_((String)"gui.neo_auth.microsoft.status.msAccessToken");
            return MicrosoftUtils.acquireMSAccessToken(msAuthCode, this.executor);
        })).thenComposeAsync(msAccessToken -> {
            this.status = Component.m_237115_((String)"gui.neo_auth.microsoft.status.xboxAccessToken");
            return MicrosoftUtils.acquireXboxAccessToken(msAccessToken, this.executor);
        })).thenComposeAsync(xboxAccessToken -> {
            this.status = Component.m_237115_((String)"gui.neo_auth.microsoft.status.xboxXstsToken");
            return MicrosoftUtils.acquireXboxXstsToken(xboxAccessToken, this.executor);
        })).thenComposeAsync(xboxXstsData -> {
            this.status = Component.m_237115_((String)"gui.neo_auth.microsoft.status.mcAccessToken");
            return MicrosoftUtils.acquireMCAccessToken((String)xboxXstsData.get("Token"), (String)xboxXstsData.get("uhs"), this.executor);
        })).thenComposeAsync(mcToken -> {
            this.status = Component.m_237115_((String)"gui.neo_auth.microsoft.status.mcProfile");
            return MicrosoftUtils.login(mcToken, this.executor);
        })).thenAccept(session -> {
            SessionUtils.setSession(session);
            SystemToast.m_94855_((ToastComponent)this.f_96541_.m_91300_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237110_((String)"gui.neo_auth.toast.greeting", (Object[])new Object[]{Component.m_237113_((String)session.m_92546_())}), null);
            NeoAuth.LOGGER.info("Successfully logged in via Microsoft!");
            this.success = true;
        })).exceptionally(error -> {
            this.status = Component.m_237115_((String)(error.getCause() instanceof ConnectTimeoutException ? "gui.neo_auth.error.timeout" : "gui.neo_auth.error.generic")).m_130940_(ChatFormatting.RED);
            cancelBtn.m_93666_((Component)Component.m_237115_((String)"gui.back"));
            return null;
        });
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.f_96541_ == null) {
            return;
        }
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.f_96544_ / 2 - 32, 0xFFFFFF);
        if (this.status != null) {
            graphics.m_280653_(this.f_96547_, this.status, this.f_96543_ / 2, this.f_96544_ / 2 - 6, 0xDDDDDD);
        }
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    @Override
    public void m_7379_() {
        if (this.task != null && !this.task.isDone()) {
            this.task.cancel(true);
            this.executor.shutdownNow();
        }
        super.m_7379_();
    }
}

