/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Rounder;
import java.util.function.Function;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum ChopCountingAlgorithm implements StringRepresentable
{
    LINEAR(numBlocks -> {
        double x = numBlocks.intValue();
        double m = (Double)ConfigHandler.COMMON.linearM.get();
        double b = (Double)ConfigHandler.COMMON.linearB.get();
        return m * x + b;
    }),
    LOGARITHMIC(numBlocks -> {
        double x = numBlocks.intValue();
        double a = (Double)ConfigHandler.COMMON.logarithmicA.get();
        return 1.0 + a * Math.log(1.0 + (x - 1.0) / a);
    });

    private final Function<Integer, Double> preciseCalculation;

    private ChopCountingAlgorithm(Function<Integer, Double> preciseCalculation) {
        this.preciseCalculation = preciseCalculation;
    }

    public int calculate(int numBlocks, Rounder rounder, boolean canRequireMoreChopsThanBlocks) {
        int count = Math.max(1, rounder.round(this.preciseCalculation.apply(numBlocks)));
        return canRequireMoreChopsThanBlocks ? count : Math.min(numBlocks, count);
    }

    @NotNull
    public String m_7912_() {
        return this.name();
    }
}

