/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.api;

import ht.treechop.api.BlockMatcher;
import ht.treechop.api.ITreeBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.chop.LazyTreeData;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.BlockNeighbors;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class TreeDetectorBuilder {
    private BlockMatcher logMatcher = ChopUtil::isBlockALog;
    private BlockMatcher leavesMatcher = ChopUtil::isBlockLeaves;
    private BiFunction<Level, BlockPos, Stream<BlockPos>> treeScanner = (level, pos) -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((BlockPos)pos);
    private BiFunction<Level, BlockPos, Stream<BlockPos>> leavesScanner = (level, pos) -> BlockNeighbors.ADJACENTS.asStream((BlockPos)pos);
    private int maxLogs;
    private int maxLeavesDistance;
    private LeavesStrategy leavesStrategy = LeavesStrategy.SMART;

    public TreeDetectorBuilder() {
        this.maxLogs = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
        this.maxLeavesDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
    }

    public TreeDetectorBuilder logs(BlockMatcher logMatcher) {
        this.logMatcher = logMatcher;
        return this;
    }

    public TreeDetectorBuilder leaves(BlockMatcher leavesMatcher) {
        this.leavesMatcher = leavesMatcher;
        return this;
    }

    public TreeDetectorBuilder treeScanner(BiFunction<Level, BlockPos, Stream<BlockPos>> scanner) {
        this.treeScanner = scanner;
        return this;
    }

    public TreeDetectorBuilder leavesScanner(BiFunction<Level, BlockPos, Stream<BlockPos>> scanner) {
        this.leavesScanner = scanner;
        return this;
    }

    public TreeDetectorBuilder maxLogCount(int maxLogs) {
        this.maxLogs = maxLogs;
        return this;
    }

    public TreeDetectorBuilder maxLeavesDistance(int maxLeavesDistance) {
        this.maxLeavesDistance = maxLeavesDistance;
        return this;
    }

    public TreeDetectorBuilder leavesStrategy(LeavesStrategy strategy) {
        this.leavesStrategy = strategy;
        return this;
    }

    public ITreeBlock build() {
        return (level, origin) -> new LazyTreeData(level, origin, pos -> this.treeScanner.apply(level, (BlockPos)pos), pos -> this.leavesScanner.apply(level, (BlockPos)pos), pos -> this.logMatcher.matches(level, (BlockPos)pos, ChopUtil.getLogState(level, pos)), pos -> this.leavesMatcher.matches(level, (BlockPos)pos, level.m_8055_(pos)), this.maxLogs, this.maxLeavesDistance, this.leavesStrategy == LeavesStrategy.SMART);
    }

    public static enum LeavesStrategy {
        SMART,
        SHORTEST_PATH;

    }
}

