/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.data.worldgen.Structures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.feature.Feature;
import pie.ilikepiefoo.compat.jade.JadeEvents;
import pie.ilikepiefoo.compat.jei.JEIEvents;
import pie.ilikepiefoo.compat.jei.events.JEIEventJS;
import pie.ilikepiefoo.events.AdditionalEvents;
import pie.ilikepiefoo.events.custom.ArchEventRegisterEventJS;

public class AdditionsPlugin
extends KubeJSPlugin {
    public void initStartup() {
        AdditionalEvents.ARCH_EVENT_REGISTER.post((EventJS)new ArchEventRegisterEventJS());
    }

    public void registerEvents() {
        AdditionalEvents.register();
        JEIEvents.register();
        JadeEvents.register();
    }

    public void registerBindings(BindingsEvent event) {
        event.add("Structures", Structures.class);
        event.add("Feature", Feature.class);
    }

    public void registerTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.registerSimple(ChunkPos.class, o -> {
            if (o instanceof ChunkPos) {
                ChunkPos chunkPos = (ChunkPos)o;
                return chunkPos;
            }
            if (o instanceof BlockPos) {
                BlockPos blockPos = (BlockPos)o;
                return new ChunkPos(blockPos);
            }
            if (o instanceof Long) {
                Long pos = (Long)o;
                return new ChunkPos(pos.longValue());
            }
            if (o instanceof BlockContainerJS) {
                BlockContainerJS containerJS = (BlockContainerJS)o;
                return new ChunkPos(containerJS.getPos());
            }
            if (o instanceof Entity) {
                Entity entity = (Entity)o;
                return entity.m_146902_();
            }
            return ChunkPos.f_186419_;
        });
        if (Platform.isModLoaded((String)"jei")) {
            typeWrappers.registerSimple(RecipeType.class, object -> {
                if (object instanceof RecipeType) {
                    RecipeType recipeType = (RecipeType)object;
                    return recipeType;
                }
                if (object instanceof IRecipeCategory) {
                    IRecipeCategory category = (IRecipeCategory)object;
                    return category.getRecipeType();
                }
                if (JEIEventJS.JEI_HELPERS == null) {
                    return null;
                }
                if (object instanceof String) {
                    String recipeType = (String)object;
                    return JEIEventJS.JEI_HELPERS.getRecipeType(new ResourceLocation(recipeType)).orElse(null);
                }
                if (object instanceof ResourceLocation) {
                    ResourceLocation recipeType = (ResourceLocation)object;
                    return JEIEventJS.JEI_HELPERS.getRecipeType(recipeType).orElse(null);
                }
                return null;
            });
        }
    }

    public static interface EmptyHandler {
        public void handle();
    }
}

