/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.client.GingyModel;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.mehvahdjukaar.snowyspirit.reg.ClientRegistry;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;

public class GingyEntityRenderer
extends HumanoidMobRenderer<GingyEntity, GingyModel> {
    private static final Map<DyeColor, ResourceLocation> GINGY_TEXTURES = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), d -> SnowySpirit.res("textures/entity/gingerbread_golem/" + d.m_41065_() + ".png")));
    private final float scale;

    public GingyEntityRenderer(EntityRendererProvider.Context context, float scale) {
        super(context, (HumanoidModel)new GingyModel(context.m_174023_(ClientRegistry.GINGY_MODEL), scale), 0.25f * scale);
        this.scale = scale;
    }

    protected void scale(GingyEntity livingEntity, PoseStack matrixStack, float partialTickTime) {
        matrixStack.m_85841_(this.scale, this.scale, this.scale);
    }

    protected float getFlipDegrees(GingyEntity livingEntity) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(GingyEntity entity) {
        return GINGY_TEXTURES.get(entity.getColor());
    }

    protected void setupRotations(GingyEntity entity, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)entity, matrixStack, ageInTicks, rotationYaw, partialTicks);
        if (entity.f_20919_ > 0) {
            float f = ((float)entity.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            int deg = entity.isForwardDeathAnim() ? -90 : 90;
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(f * (float)deg));
        }
        float period = 7.853982f * this.scale;
        float limbSwingAmount = 0.0f;
        float walkAnim = 0.0f;
        boolean orderedToSit = entity.isOrderedToSit();
        if (orderedToSit) {
            matrixStack.m_85837_(0.0, -0.25, 0.0);
        }
        if (!orderedToSit && entity.m_6084_()) {
            float maxLimbSwing;
            limbSwingAmount = entity.f_267362_.m_267711_(partialTicks);
            walkAnim = entity.f_267362_.m_267590_(partialTicks);
            if (entity.m_6162_()) {
                walkAnim *= 3.0f;
            }
            if (limbSwingAmount > (maxLimbSwing = 1.0f)) {
                limbSwingAmount = maxLimbSwing;
            }
        }
        if ((double)limbSwingAmount > 0.001) {
            float angle = walkAnim * ((float)Math.PI * 2 / period);
            float sideSwayPower = 20.0f / this.scale;
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14089_((float)angle) * sideSwayPower * limbSwingAmount));
        }
    }
}

