/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.menu;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.container.BaseMenu;
import xyz.apex.forge.fantasyfurniture.core.FurnitureStation;

public final class FurnitureStationMenu
extends BaseMenu {
    private final Container inputInventory;
    private final ResultContainer resultInventory;
    private final Slot claySlot;
    private final Slot woodSlot;
    private final Slot stoneSlot;
    private final Slot resultSlot;
    private final DataSlot selectedResult = DataSlot.m_39401_();
    private final List<ItemStack> results = Lists.newArrayList();
    private long lastSoundTime = 0L;

    public FurnitureStationMenu(@Nullable MenuType<? extends FurnitureStationMenu> menuType, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(menuType, windowId, playerInventory, buffer);
        this.inputInventory = new SimpleContainer(4){

            public void m_6596_() {
                super.m_6596_();
                FurnitureStationMenu.this.m_6199_((Container)this);
            }
        };
        this.resultInventory = new ResultContainer();
        this.claySlot = this.m_38897_(new InputSlot(0, 16, 21, FurnitureStation::isValidClay));
        this.woodSlot = this.m_38897_(new InputSlot(1, 34, 21, FurnitureStation::isValidWood));
        this.stoneSlot = this.m_38897_(new InputSlot(2, 52, 21, FurnitureStation::isValidStone));
        this.resultSlot = this.m_38897_(new ResultSlot());
        this.m_38895_(this.selectedResult);
        FurnitureStationMenu.bindPlayerInventory((BaseMenu)this, (int)8, (int)140);
    }

    public Slot getClaySlot() {
        return this.claySlot;
    }

    public Slot getWoodSlot() {
        return this.woodSlot;
    }

    public Slot getStoneSlot() {
        return this.stoneSlot;
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }

    public void setSelectedResult(int selectedResult) {
        this.setupResultSlot(selectedResult);
    }

    public List<ItemStack> getResults() {
        return this.results;
    }

    public void m_6199_(Container inventory) {
        super.m_6199_(inventory);
        this.results.clear();
        if (this.claySlot.m_6657_() && this.woodSlot.m_6657_() && this.stoneSlot.m_6657_()) {
            this.results.addAll(FurnitureStation.buildResultsList());
        }
        this.setupResultSlot(this.selectedResult.m_6501_());
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultInventory && super.m_5882_(stack, slot);
    }

    public boolean m_6366_(Player player, int button) {
        this.setupResultSlot(button);
        return super.m_6366_(player, button);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultInventory.m_8016_(1);
        this.m_150411_(player, this.inputInventory);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack stack1 = slot.m_7993_();
            stack = stack1.m_41777_();
            int inputStart = Math.min(0, Math.min(1, 2));
            int inputEnd = Math.max(0, Math.max(1, 2));
            int resultSlot = 3;
            int playerStart = 4;
            int playerEnd = 31;
            int hotStart = 32;
            int hotEnd = 40;
            if (slotIndex >= inputStart && slotIndex <= inputEnd) {
                if (!this.m_38903_(stack1, playerStart, hotEnd, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (slotIndex == resultSlot) {
                stack1.m_41678_(player.m_9236_(), player, stack1.m_41613_());
                if (!this.m_38903_(stack1, playerStart, hotEnd, false)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack1, stack);
            } else if (slotIndex >= playerStart && slotIndex <= playerEnd) {
                if (!this.m_38903_(stack1, inputStart, resultSlot, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(stack1, hotStart, hotEnd, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (slotIndex >= hotStart && slotIndex <= hotEnd && !this.m_38903_(stack1, inputStart, playerEnd, false)) {
                return ItemStack.f_41583_;
            }
            if (stack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (stack1.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack1);
            this.m_38946_();
        }
        return stack;
    }

    private void setupResultSlot(int button) {
        int size = this.results.size();
        if (size == 0 || button < 0 || button > size - 1) {
            this.selectedResult.m_6422_(-1);
            this.resultSlot.m_5852_(ItemStack.f_41583_);
            this.m_38946_();
            return;
        }
        this.selectedResult.m_6422_(button);
        ItemStack stack = this.results.get(button).m_41777_();
        stack.m_41764_(1);
        this.resultSlot.m_5852_(stack);
        this.m_38946_();
    }

    private void decrementInput() {
        this.claySlot.m_6201_(1);
        this.woodSlot.m_6201_(1);
        this.stoneSlot.m_6201_(1);
    }

    public final class InputSlot
    extends Slot {
        private final Predicate<ItemStack> predicate;

        private InputSlot(int index, int x, int y, Predicate<ItemStack> predicate) {
            super(FurnitureStationMenu.this.inputInventory, index, x, y);
            this.predicate = predicate;
        }

        public boolean m_5857_(ItemStack stack) {
            return this.predicate.test(stack);
        }
    }

    public final class ResultSlot
    extends Slot {
        private ResultSlot() {
            super((Container)FurnitureStationMenu.this.resultInventory, 3, 148, 72);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            stack.m_41720_().m_7836_(stack, player.m_9236_(), player);
            FurnitureStationMenu.this.resultInventory.m_58395_(player, List.of(FurnitureStationMenu.this.resultSlot.m_7993_()));
            FurnitureStationMenu.this.decrementInput();
            FurnitureStationMenu.this.setupResultSlot(FurnitureStationMenu.this.selectedResult.m_6501_());
            long gameTime = player.m_9236_().m_46467_();
            if (FurnitureStationMenu.this.lastSoundTime != gameTime) {
                player.m_9236_().m_5594_(null, FurnitureStationMenu.this.pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                FurnitureStationMenu.this.lastSoundTime = gameTime;
            }
        }
    }
}

