/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.SeatBlock;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.core.HitBoxes;

public class SofaBlock
extends SeatBlock {
    public static final EnumProperty<Connection> CONNECTION = EnumProperty.m_61587_((String)"connection", Connection.class);

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(CONNECTION, (Comparable)((Object)Connection.SINGLE)));
    }

    public double getSeatYOffset(BlockState blockState) {
        return 0.1;
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
        consumer.accept((Property<?>)CONNECTION);
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos pos, Entity entity, float distance) {
        super.m_142072_(level, blockState, pos, entity, distance * 0.5f);
    }

    public void m_5548_(BlockGetter level, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(level, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    protected void bounceUp(Entity entity) {
        Vec3 deltaMovement = entity.m_20184_();
        if (deltaMovement.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(deltaMovement.f_82479_, -deltaMovement.f_82480_ * (double)0.66f * d0, deltaMovement.f_82481_);
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (AllBlocks.NORDIC_SOFA.isIn(blockState)) {
            return HitBoxes.NORDIC.sofa(this, blockState);
        }
        if (AllBlocks.DUNMER_SOFA.isIn(blockState)) {
            return HitBoxes.DUNMER.sofa(this, blockState);
        }
        if (AllBlocks.VENTHYR_SOFA.isIn(blockState)) {
            return HitBoxes.VENTHYR.sofa(this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_SOFA.isIn(blockState) || AllBlocks.BONE_WITHER_SOFA.isIn(blockState)) {
            return HitBoxes.BONE.sofa(this, blockState);
        }
        if (AllBlocks.ROYAL_SOFA.isIn(blockState)) {
            return HitBoxes.ROYAL.sofa(this, blockState);
        }
        if (AllBlocks.NECROLORD_SOFA.isIn(blockState)) {
            return HitBoxes.NECROLORD.sofa(this, blockState);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingBlockState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        blockState = super.m_7417_(blockState, facing, facingBlockState, level, pos, facingPos);
        return SofaBlock.getBlockState(level, pos, blockState, this);
    }

    @Nullable
    protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
        if ((placementBlockState = super.modifyPlacementState(placementBlockState, ctx)) != null) {
            placementBlockState = SofaBlock.getBlockState((LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), placementBlockState, this);
        }
        return placementBlockState;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(blockState, level, pos, block, fromPos, isMoving);
        SofaBlock.updateConnectionBlockState((LevelAccessor)level, pos, blockState, this);
    }

    public static void updateConnectionBlockState(LevelAccessor level, BlockPos pos, BlockState blockState, SofaBlock sofa) {
        BlockState newBlockState = SofaBlock.getBlockState(level, pos, blockState, sofa);
        if (newBlockState != blockState) {
            level.m_7731_(pos, newBlockState, 3);
        }
    }

    public static BlockState getBlockState(LevelAccessor level, BlockPos pos, BlockState blockState, SofaBlock sofa) {
        if (blockState.m_61138_(CONNECTION)) {
            Connection connection = SofaBlock.getConnection(level, pos, blockState, sofa);
            return (BlockState)blockState.m_61124_(CONNECTION, (Comparable)((Object)connection));
        }
        return blockState;
    }

    public static Connection getConnection(LevelAccessor level, BlockPos pos, BlockState blockState, SofaBlock sofa) {
        BlockState frontBlockState;
        BlockState rightBlockState;
        Direction facing = SofaBlock.getFacing((BlockState)blockState);
        Connection connection = blockState.m_61145_(CONNECTION).orElse(Connection.SINGLE);
        BlockPos leftPos = pos.m_121945_(facing.m_122428_());
        BlockPos rightPos = pos.m_121945_(facing.m_122427_());
        BlockPos frontPos = pos.m_121945_(facing);
        BlockState leftBlockState = level.m_8055_(leftPos);
        if (SofaBlock.isCornerConnection(leftBlockState, rightBlockState = level.m_8055_(rightPos), frontBlockState = level.m_8055_(frontPos), facing, sofa)) {
            return Connection.CORNER;
        }
        boolean isLeft = SofaBlock.isSideConnection(leftBlockState, facing, connection, sofa);
        boolean isRight = SofaBlock.isSideConnection(rightBlockState, facing, connection, sofa);
        if (isLeft && isRight) {
            return Connection.CENTER;
        }
        if (isLeft) {
            return Connection.LEFT;
        }
        if (isRight) {
            return Connection.RIGHT;
        }
        return Connection.SINGLE;
    }

    public static boolean isCornerConnection(BlockState left, BlockState right, BlockState front, Direction facing, SofaBlock sofa) {
        if (!front.m_60713_((Block)sofa)) {
            return false;
        }
        Direction frontFacing = SofaBlock.getFacing((BlockState)front);
        if (left.m_60713_((Block)sofa)) {
            Direction leftFacing = SofaBlock.getFacing((BlockState)left);
            return SofaBlock.isCornerFacing(facing, leftFacing, frontFacing);
        }
        if (right.m_60713_((Block)sofa)) {
            Direction rightFacing = SofaBlock.getFacing((BlockState)right);
            return SofaBlock.isCornerFacing(facing, rightFacing, frontFacing);
        }
        return false;
    }

    public static boolean isCornerFacing(Direction facing, Direction sideFacing, Direction frontFacing) {
        if (facing == sideFacing) {
            return sideFacing.m_122428_() == frontFacing || sideFacing == frontFacing.m_122427_();
        }
        return sideFacing.m_122424_() == frontFacing || sideFacing == frontFacing.m_122424_();
    }

    public static boolean isSideConnection(BlockState side, Direction facing, Connection connection, SofaBlock sofa) {
        if (!side.m_60713_((Block)sofa)) {
            return false;
        }
        if (SofaBlock.getFacing((BlockState)side) == facing) {
            return true;
        }
        Connection sideConnection = side.m_61145_(CONNECTION).orElse(Connection.SINGLE);
        return sideConnection == Connection.CORNER || sideConnection == Connection.CENTER;
    }

    public static enum Connection implements StringRepresentable
    {
        LEFT("left"),
        RIGHT("right"),
        CENTER("center"),
        CORNER("corner"),
        SINGLE("single");

        public final String serializedName;

        private Connection(String serializedName) {
            this.serializedName = serializedName;
        }

        public String m_7912_() {
            return this.serializedName;
        }
    }

    public static class Dyeable
    extends SofaBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MapColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MapColor defaultColor) {
            MapColor color = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, color);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Override
        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }
}

