/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionReference;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.EntityHasScoreCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.ValueCheckCondition;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import org.jetbrains.annotations.NotNull;

public class ConditionTooltipUtils {
    private static final DecimalFormat FLOAT_FORMAT = new DecimalFormat("0.####");

    @NotNull
    public static ITooltipNode getAllOfTooltip(IServerUtils utils, AllOfCondition cond) {
        return GenericTooltipUtils.getSubConditionsTooltip(utils, Arrays.asList(cond.f_285609_)).build("ali.type.condition.all_of");
    }

    @NotNull
    public static ITooltipNode getAnyOfTooltip(IServerUtils utils, AnyOfCondition cond) {
        return GenericTooltipUtils.getSubConditionsTooltip(utils, Arrays.asList(cond.f_285609_)).build("ali.type.condition.any_of");
    }

    @NotNull
    public static ITooltipNode getBlockStatePropertyTooltip(IServerUtils utils, LootItemBlockStatePropertyCondition cond) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, cond.f_81759_).build("ali.property.value.block")).add(utils.getValueTooltip(utils, cond.f_81760_).build("ali.property.branch.properties")).build("ali.type.condition.block_state_property");
    }

    @NotNull
    public static ITooltipNode getDamageSourcePropertiesTooltip(IServerUtils utils, DamageSourceCondition cond) {
        return utils.getValueTooltip(utils, cond.f_81582_).build("ali.type.condition.damage_source_properties");
    }

    @NotNull
    public static ITooltipNode getEntityPropertiesTooltip(IServerUtils utils, LootItemEntityPropertyCondition cond) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, cond.f_81847_).build("ali.property.value.target")).add(utils.getValueTooltip(utils, cond.f_81846_).build("ali.property.branch.predicate")).build("ali.type.condition.entity_properties");
    }

    @NotNull
    public static ITooltipNode getEntityScoresTooltip(IServerUtils utils, EntityHasScoreCondition cond) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, cond.f_81616_).build("ali.property.value.target")).add(GenericTooltipUtils.getMapTooltip(utils, cond.f_81615_, GenericTooltipUtils::getIntRangeEntryTooltip).build("ali.property.branch.scores")).build("ali.type.condition.entity_scores");
    }

    @NotNull
    public static ITooltipNode getInvertedTooltip(IServerUtils utils, InvertedLootItemCondition cond) {
        return BranchTooltipNode.branch().add(utils.getConditionTooltip(utils, cond.f_81681_)).build("ali.type.condition.inverted");
    }

    @NotNull
    public static ITooltipNode getKilledByPlayerTooltip(IServerUtils ignoredUtils, LootItemKilledByPlayerCondition ignoredCond) {
        return LiteralTooltipNode.translatable("ali.type.condition.killed_by_player");
    }

    @NotNull
    public static ITooltipNode getLocationCheckTooltip(IServerUtils utils, LocationCheck cond) {
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        tooltip.add(utils.getValueTooltip(utils, cond.f_81716_).build("ali.property.branch.location"));
        if (!cond.f_81717_.equals((Object)BlockPos.f_121853_)) {
            tooltip.add(utils.getValueTooltip(utils, cond.f_81717_).build("ali.property.multi.offset"));
        }
        return tooltip.build("ali.type.condition.location_check");
    }

    @NotNull
    public static ITooltipNode getMatchToolTooltip(IServerUtils utils, MatchTool cond) {
        return utils.getValueTooltip(utils, cond.f_81993_).build("ali.type.condition.match_tool");
    }

    @NotNull
    public static ITooltipNode getRandomChanceTooltip(IServerUtils utils, LootItemRandomChanceCondition cond) {
        return BranchTooltipNode.branch(true).add(utils.getValueTooltip(utils, Float.valueOf(cond.f_81921_)).build("ali.property.value.probability")).build("ali.type.condition.random_chance");
    }

    @NotNull
    public static ITooltipNode getRandomChanceWithLootingTooltip(IServerUtils utils, LootItemRandomChanceWithLootingCondition cond) {
        return BranchTooltipNode.branch(true).add(utils.getValueTooltip(utils, Float.valueOf(cond.f_81953_)).build("ali.property.value.percent")).add(utils.getValueTooltip(utils, Float.valueOf(cond.f_81954_)).build("ali.property.value.multiplier")).build("ali.type.condition.random_chance_with_looting");
    }

    @NotNull
    public static ITooltipNode getReferenceTooltip(IServerUtils utils, ConditionReference cond) {
        return utils.getValueTooltip(utils, cond.f_81550_).build("ali.type.condition.reference");
    }

    @NotNull
    public static ITooltipNode getSurvivesExplosionTooltip(IServerUtils ignoredUtils, ExplosionCondition ignoredCond) {
        return LiteralTooltipNode.translatable("ali.type.condition.survives_explosion");
    }

    @NotNull
    public static ITooltipNode getTableBonusTooltip(IServerUtils utils, BonusLevelTableCondition cond) {
        List<String> list = IntStream.range(0, cond.f_81508_.length).mapToDouble(i -> cond.f_81508_[i]).mapToObj(FLOAT_FORMAT::format).toList();
        return BranchTooltipNode.branch(true).add(utils.getValueTooltip(utils, cond.f_81507_).build("ali.property.value.enchantment")).add(utils.getValueTooltip(utils, list.toString()).build("ali.property.value.values")).build("ali.type.condition.table_bonus");
    }

    @NotNull
    public static ITooltipNode getTimeCheckTooltip(IServerUtils utils, TimeCheck cond) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, cond.f_82023_).build("ali.property.value.period")).add(utils.getValueTooltip(utils, cond.f_82024_).build("ali.property.value.value")).build("ali.type.condition.time_check");
    }

    @NotNull
    public static ITooltipNode getValueCheckTooltip(IServerUtils utils, ValueCheckCondition cond) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, cond.f_165520_).build("ali.property.value.provider")).add(utils.getValueTooltip(utils, cond.f_165521_).build("ali.property.value.range")).build("ali.type.condition.value_check");
    }

    @NotNull
    public static ITooltipNode getWeatherCheckTooltip(IServerUtils utils, WeatherCheck cond) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, cond.f_82056_).build("ali.property.value.is_raining")).add(utils.getValueTooltip(utils, cond.f_82057_).build("ali.property.value.is_thundering")).build("ali.type.condition.weather_check");
    }
}

