/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs.node;

import com.almostreliable.lootjs.core.LootEntry;
import com.almostreliable.lootjs.loot.action.WeightedAddLootAction;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.mixin.MixinWeightedAddLootAction;
import com.yanny.ali.mixin.MixinWeightedRandomList;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.lootjs.Utils;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class WeightedAddLootNode
extends ListNode {
    public static final ResourceLocation ID = new ResourceLocation("lootjs", "weighted_add_loot");
    private final ITooltipNode tooltip;

    public WeightedAddLootNode(IServerUtils utils, WeightedAddLootAction lootAction, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        MixinWeightedAddLootAction action = (MixinWeightedAddLootAction)lootAction;
        MixinWeightedRandomList weightedList = (MixinWeightedRandomList)action.getWeightedRandomList();
        int sumWeight = weightedList.getTotalWeight();
        this.tooltip = WeightedAddLootNode.getTooltip(utils, action);
        for (WeightedEntry.Wrapper wrapper : weightedList.getItems()) {
            this.addChildren(Utils.getEntry(utils, (LootEntry)wrapper.m_146310_(), sumWeight, functions, conditions, false));
        }
    }

    public WeightedAddLootNode(IClientUtils utils, FriendlyByteBuf buf) {
        super(utils, buf);
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
    }

    @Override
    public void encodeNode(IServerUtils utils, FriendlyByteBuf buf) {
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public static ITooltipNode getTooltip(IServerUtils utils, MixinWeightedAddLootAction action) {
        return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.random")).add(EntryTooltipUtils.getRolls(utils.convertNumber(utils, action.getNumberProvider()), new RangeValue(0.0f))).add(ValueTooltipNode.value(action.getAllowDuplicateLoot()).build("ali.property.value.allow_duplicate_loot")).build();
    }
}

