/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.tooltip;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ListTooltipNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BranchTooltipNode
extends ListTooltipNode
implements ITooltipNode {
    public static final ResourceLocation ID = new ResourceLocation("ali", "branch");
    private static final LoadingCache<CacheKey, BranchTooltipNode> CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(data -> data != null ? new BranchTooltipNode((CacheKey)data) : null));
    private final String key;
    private final boolean translateKey;
    private final boolean advancedTooltip;

    private BranchTooltipNode(CacheKey cacheKey) {
        super(cacheKey.children);
        this.key = cacheKey.key;
        this.advancedTooltip = cacheKey.advancedTooltip;
        this.translateKey = cacheKey.translateKey;
    }

    @Override
    void encodeNode(FriendlyByteBuf buf) {
        buf.m_130070_(this.key);
        buf.writeBoolean(this.advancedTooltip);
        buf.writeBoolean(this.translateKey);
    }

    @Override
    public List<Component> getComponents(int pad, boolean showAdvancedTooltip) {
        if (this.advancedTooltip && !showAdvancedTooltip) {
            return Collections.emptyList();
        }
        List<Component> children = super.getComponents(pad + 1, showAdvancedTooltip);
        ArrayList<Component> components = new ArrayList<Component>(children.size() + 1);
        components.add(ITooltipNode.pad(pad, Component.m_237115_((String)this.key).m_130940_(TEXT_STYLE)));
        components.addAll(children);
        return components;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BranchTooltipNode that = (BranchTooltipNode)o;
        return this.advancedTooltip == that.advancedTooltip && this.translateKey == that.translateKey && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.advancedTooltip, this.translateKey);
    }

    public String toString() {
        return "BranchTooltipNode{key='" + this.key + "', advancedTooltip=" + this.advancedTooltip + ", translateKey=" + this.translateKey + ", children=" + String.valueOf(this.getChildren()) + "}";
    }

    @NotNull
    public static Builder branch() {
        return new Builder(false);
    }

    @NotNull
    public static Builder branch(boolean isAdvancedTooltip) {
        return new Builder(isAdvancedTooltip);
    }

    @NotNull
    public static BranchTooltipNode decode(IClientUtils utils, FriendlyByteBuf buf) {
        List<ITooltipNode> children = ListTooltipNode.decodeChildren(utils, buf);
        String key = buf.m_130277_();
        boolean advancedTooltip = buf.readBoolean();
        boolean translateKey = buf.readBoolean();
        CacheKey cacheKey = new CacheKey(children, key, advancedTooltip, translateKey);
        try {
            return (BranchTooltipNode)CACHE.get((Object)cacheKey);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private record CacheKey(List<ITooltipNode> children, String key, boolean advancedTooltip, boolean translateKey) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.advancedTooltip == cacheKey.advancedTooltip && this.translateKey == cacheKey.translateKey && Objects.equals(this.key, cacheKey.key) && Objects.equals(this.children, cacheKey.children);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.children, this.key, this.advancedTooltip, this.translateKey);
        }
    }

    public static class Builder
    extends ListTooltipNode.Builder {
        private final boolean advancedTooltip;

        public Builder(boolean advancedTooltip) {
            this.advancedTooltip = advancedTooltip;
        }

        @Override
        public BranchTooltipNode build(String key) {
            return this.build(key, true);
        }

        public BranchTooltipNode build(String key, boolean translateKey) {
            String internKey = key.intern();
            CacheKey cacheKey = new CacheKey((List<ITooltipNode>)ImmutableList.copyOf((Collection)this.children), internKey, this.advancedTooltip, translateKey);
            try {
                return (BranchTooltipNode)CACHE.get((Object)cacheKey);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

