/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.util;

import dev.latvian.mods.kubejs.stages.Stages;
import io.github.chakyl.societytrading.SocietyTrading;
import io.github.chakyl.societytrading.data.Shop;
import io.github.chakyl.societytrading.trading.RandomSetShopOffers;
import io.github.chakyl.societytrading.trading.RandomStyle;
import io.github.chakyl.societytrading.trading.ShopOffer;
import io.github.chakyl.societytrading.trading.ShopOffers;
import io.github.chakyl.societytrading.util.ShopComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import sereneseasons.api.season.SeasonHelper;

public class ShopData {
    public static Collection<Shop> getFilteredShops(Collection<Shop> shops, Player player) {
        ArrayList<Shop> newShops = new ArrayList<Shop>();
        for (Shop shop : shops) {
            boolean flag;
            boolean bl = flag = shop.hiddenFromSelector() == false;
            if (SocietyTrading.SERENE_SEASONS_INSTALLED && !shop.seasonsRequired().isEmpty() && !shop.seasonsRequired().contains(SeasonHelper.getSeasonState((Level)player.m_9236_()).getSubSeason().m_7912_())) {
                flag = false;
            }
            if (SocietyTrading.KUBEJS_INSTALLED) {
                if (!shop.stageRequired().isEmpty() && !Stages.get((Player)player).has(shop.stageRequired())) {
                    flag = false;
                }
                if (!shop.stageOverride().isEmpty() && Stages.get((Player)player).has(shop.stageRequired())) {
                    flag = true;
                }
            }
            if (!flag) continue;
            newShops.add(shop);
        }
        ShopComparator comparator = new ShopComparator();
        comparator.setSortingBy(ShopComparator.Order.ID);
        Collections.sort(newShops, comparator);
        return newShops;
    }

    public static Shop getShopFromEntity(Collection<Shop> shops, LivingEntity entity) {
        for (Shop shop : shops) {
            if (shop.entity() != entity.m_6095_()) continue;
            if (!shop.entityData().isEmpty()) {
                if (!entity.m_20240_(new CompoundTag()).toString().contains(shop.entityData())) continue;
                return shop;
            }
            return shop;
        }
        return null;
    }

    public static Shop getShopFromBlockState(Collection<Shop> shops, BlockState blockState) {
        for (Shop shop : shops) {
            if (shop.blockTag() == null || !blockState.m_204336_(shop.blockTag())) continue;
            return shop;
        }
        return null;
    }

    public static Shop getShopFromVillagerProfession(Collection<Shop> shops, String profession) {
        for (Shop shop : shops) {
            if (!shop.villagerProfession().equals(profession)) continue;
            return shop;
        }
        return null;
    }

    public static RandomSource getPerDayTrades(Player player) {
        int day = Mth.m_14143_((float)((float)player.m_9236_().m_8044_() / 24000.0f)) + 1;
        return RandomSource.m_216335_((long)day);
    }

    public static RandomSource getPerEntityTrades(UUID uuid) {
        return RandomSource.m_216335_((long)(uuid.getMostSignificantBits() ^ uuid.getLeastSignificantBits()));
    }

    public static ShopOffers getRandomSetOffers(List<RandomSetShopOffers> randomSetShopOffersList, Player player, UUID targetUUID) {
        ShopOffers randomizedOffers = new ShopOffers();
        for (RandomSetShopOffers randomSet : randomSetShopOffersList) {
            if (!randomSet.playerCanSee(player)) continue;
            RandomSource random = switch (randomSet.getRandomStyle()) {
                case RandomStyle.PER_DAY -> ShopData.getPerDayTrades(player);
                case RandomStyle.PER_PLAYER -> ShopData.getPerEntityTrades(player.m_20148_());
                case RandomStyle.PER_ENTITY -> ShopData.getPerEntityTrades(targetUUID == null ? player.m_20148_() : targetUUID);
                default -> player.m_9236_().f_46441_;
            };
            RandomSetShopOffers rsClone = (RandomSetShopOffers)randomSet.clone();
            for (int i = 0; i < randomSet.getRolledCount(); ++i) {
                if (rsClone.size() > 1) {
                    int roll = random.m_188503_(rsClone.size());
                    randomizedOffers.add((ShopOffer)rsClone.get(roll));
                    rsClone.remove(roll);
                    continue;
                }
                randomizedOffers.add((ShopOffer)rsClone.get(0));
                SocietyTrading.LOGGER.warn("random_set for the shop has a higher rolled_count (" + randomSet.getRolledCount() + ") than there are trades (" + randomSet.size() + ")!");
            }
        }
        return randomizedOffers;
    }

    public static ShopOffers getFilteredTrades(ShopOffers trades, List<RandomSetShopOffers> randomSetShopOffers, Player player, UUID targetUUID) {
        ShopOffers newTrades = new ShopOffers();
        newTrades.addAll(ShopData.getRandomSetOffers(randomSetShopOffers, player, targetUUID));
        for (ShopOffer trade : trades) {
            if (!trade.playerCanSee(player)) continue;
            newTrades.add(trade);
        }
        return newTrades;
    }

    public static ShopOffers getSearchedTrades(ShopOffers trades, String searchQuery) {
        ShopOffers newTrades = new ShopOffers();
        for (ShopOffer trade : trades) {
            if (!trade.getResult().m_41611_().getString().toLowerCase().contains(searchQuery.toLowerCase())) continue;
            newTrades.add(trade);
        }
        return newTrades;
    }

    public static String formatPrice(String number) {
        return ShopData.formatPrice(number, true);
    }

    public static String formatPrice(String number, boolean truncateMillionsBillions) {
        if (truncateMillionsBillions) {
            if (number.length() < 4) {
                return number;
            }
            if (number.length() > 9) {
                return number.charAt(0) + "." + number.charAt(1) + "B";
            }
            if (number.length() > 6) {
                StringBuilder out = new StringBuilder(3);
                for (int i = 0; i < number.length() - 6; ++i) {
                    out.append(number.charAt(i));
                }
                if (number.length() == 7) {
                    out.append('.');
                    out.append(number.charAt(1));
                }
                out.append("M");
                return out.toString();
            }
        }
        int start = number.length() % 3;
        StringBuilder out = new StringBuilder(number.length() + number.length() / 3);
        out.append(number, 0, start);
        for (int i = 0; i < number.length() / 3; ++i) {
            if (i != 0 || start != 0) {
                out.append(",");
            }
            out.append(number, i * 3 + start, i * 3 + start + 3);
        }
        return out.toString();
    }
}

