/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import io.github.chakyl.societytrading.trading.RandomSetShopOffers;
import io.github.chakyl.societytrading.trading.RandomStyle;
import io.github.chakyl.societytrading.trading.ShopOffer;
import io.github.chakyl.societytrading.trading.ShopOffers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public record Shop(String shopID, MutableComponent name, String texture, String villagerProfession, EntityType<? extends LivingEntity> entity, String entityData, TagKey<Block> blockTag, Boolean hiddenFromSelector, int selectorWeight, ItemStack jeiCatalyst, String stageRequired, String stageOverride, List<String> seasonsRequired, ShopOffers trades, List<RandomSetShopOffers> randomSets) implements CodecProvider<Shop>
{
    public static final Codec<Shop> CODEC = new ShopCodec();
    public static final List<String> POSSIBLE_SEASONS = Arrays.asList("early_spring", "mid_spring", "late_spring", "early_summer", "mid_summer", "late_summer", "early_autumn", "mid_autumn", "late_autumn", "early_winter", "mid_winter", "late_winter");
    public static final List<String> POSSIBLE_RANDOM_STYLES = Arrays.asList("per_day", "per_player", "per_entity", "default");

    public Shop(Shop other) {
        this(other.shopID, other.name, other.texture, other.villagerProfession, other.entity, other.entityData, other.blockTag, other.hiddenFromSelector, other.selectorWeight, other.jeiCatalyst, other.stageRequired, other.stageOverride, other.seasonsRequired, other.trades, other.randomSets);
    }

    public int getColor() {
        return this.name.m_7383_().m_131135_().m_131265_();
    }

    public Shop validate(ResourceLocation key) {
        Preconditions.checkNotNull((Object)this.shopID, (Object)"Invalid shop ID!");
        Preconditions.checkNotNull((Object)this.name, (Object)"Invalid shop name!");
        Preconditions.checkNotNull((Object)this.texture, (Object)"Missing texture!");
        if (this.seasonsRequired != null) {
            this.seasonsRequired.forEach(season -> {
                if (!POSSIBLE_SEASONS.contains(season.replace("\"", ""))) {
                    throw new NullPointerException("Season " + season + " that doesn't exist! Possible values: " + String.valueOf(POSSIBLE_SEASONS));
                }
            });
        }
        if (this.randomSets != null) {
            this.randomSets.forEach(rSet -> {
                String randomStyle = rSet.getRandomStyle().toString().toLowerCase().replace("\"", "");
                if (!POSSIBLE_RANDOM_STYLES.contains(randomStyle)) {
                    throw new NullPointerException("RandomSet given random style " + randomStyle + " that doesn't exist! Possible values: " + String.valueOf(POSSIBLE_RANDOM_STYLES));
                }
            });
        }
        return this;
    }

    public Codec<? extends Shop> getCodec() {
        return CODEC;
    }

    private static JsonArray encodeTradesArray(ShopOffers shopOffersTrades, String shopID) {
        ResourceLocation key = new ResourceLocation("society_trading", shopID);
        JsonArray trades = new JsonArray();
        for (ShopOffer trade : shopOffersTrades) {
            JsonObject tradeObj = new JsonObject();
            JsonElement request = ItemAdapter.ITEM_READER.toJsonTree((Object)trade.getCostA());
            JsonObject requestJson = request.getAsJsonObject();
            ResourceLocation requestItemName = new ResourceLocation(requestJson.get("item").getAsString());
            JsonElement secondRequest = ItemAdapter.ITEM_READER.toJsonTree((Object)trade.getCostB());
            JsonObject secondRequestJson = secondRequest.getAsJsonObject();
            ResourceLocation secondRequestItemName = new ResourceLocation(secondRequestJson.get("item").getAsString());
            JsonElement offer = ItemAdapter.ITEM_READER.toJsonTree((Object)trade.getResult());
            JsonObject offerJson = offer.getAsJsonObject();
            ResourceLocation offerItemName = new ResourceLocation(offerJson.get("item").getAsString());
            if (!"minecraft".equals(offerItemName.m_135827_()) && !key.m_135827_().equals(offerItemName.m_135827_())) {
                offerJson.addProperty("optional", Boolean.valueOf(true));
            }
            if (!"minecraft".equals(requestItemName.m_135827_()) && !key.m_135827_().equals(requestItemName.m_135827_())) {
                requestJson.addProperty("optional", Boolean.valueOf(true));
            }
            if (!"minecraft".equals(secondRequestItemName.m_135827_()) && !key.m_135827_().equals(secondRequestItemName.m_135827_())) {
                secondRequestJson.addProperty("optional", Boolean.valueOf(true));
            }
            JsonArray tradeSeasonsRequired = new JsonArray();
            for (String season : trade.getSeasonsRequired()) {
                tradeSeasonsRequired.add(season.replace("\"", ""));
            }
            tradeObj.add("request", (JsonElement)requestJson);
            tradeObj.add("second_request", (JsonElement)secondRequestJson);
            tradeObj.add("offer", (JsonElement)offerJson);
            if (!Objects.equals(trade.getUnlockDescription(), Component.m_237119_())) {
                tradeObj.addProperty("unlock_description", ((TranslatableContents)trade.getUnlockDescription().m_214077_()).m_237508_());
            }
            tradeObj.addProperty("stage_required", trade.getStageRequired());
            tradeObj.addProperty("stage_override", trade.getStageOverride());
            tradeObj.add("seasons_required", (JsonElement)tradeSeasonsRequired);
            tradeObj.addProperty("numismatics_cost", (Number)trade.getNumismaticsCost());
            trades.add((JsonElement)tradeObj);
        }
        return trades;
    }

    private static ShopOffers decodeTradesArray(JsonObject obj) {
        ShopOffers trades = new ShopOffers();
        if (obj.has("trades")) {
            for (JsonElement json : GsonHelper.m_13933_((JsonObject)obj, (String)"trades")) {
                if (!json.getAsJsonObject().has("offer") || !json.getAsJsonObject().has("request")) continue;
                ItemStack request = (ItemStack)ItemAdapter.ITEM_READER.fromJson((JsonElement)json.getAsJsonObject().getAsJsonObject("request"), ItemStack.class);
                ItemStack offer = (ItemStack)ItemAdapter.ITEM_READER.fromJson((JsonElement)json.getAsJsonObject().getAsJsonObject("offer"), ItemStack.class);
                String tradeStage = "";
                String tradeStageOverride = "";
                int numismaticsCost = 0;
                ArrayList<String> tradeSeasonsRequired = new ArrayList<String>();
                if (json.getAsJsonObject().has("seasons_required")) {
                    for (JsonElement arrayJson : GsonHelper.m_13933_((JsonObject)json.getAsJsonObject(), (String)"seasons_required")) {
                        tradeSeasonsRequired.add(String.valueOf(arrayJson).replace("\"", ""));
                    }
                }
                MutableComponent tradeUnlockDescription = Component.m_237119_();
                if (json.getAsJsonObject().has("unlock_description")) {
                    tradeUnlockDescription = Component.m_237115_((String)GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"unlock_description"));
                }
                if (json.getAsJsonObject().has("stage_required")) {
                    tradeStage = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"stage_required");
                }
                if (json.getAsJsonObject().has("stage_override")) {
                    tradeStageOverride = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"stage_override");
                }
                if (json.getAsJsonObject().has("numismatics_cost")) {
                    numismaticsCost = GsonHelper.m_13927_((JsonObject)json.getAsJsonObject(), (String)"numismatics_cost");
                }
                if (json.getAsJsonObject().has("second_request")) {
                    ItemStack secondRequest = (ItemStack)ItemAdapter.ITEM_READER.fromJson((JsonElement)json.getAsJsonObject().getAsJsonObject("second_request"), ItemStack.class);
                    trades.add(new ShopOffer(request, secondRequest, offer, tradeUnlockDescription, tradeStage, tradeStageOverride, tradeSeasonsRequired, numismaticsCost));
                    continue;
                }
                trades.add(new ShopOffer(request, offer, tradeUnlockDescription, tradeStage, tradeStageOverride, tradeSeasonsRequired, numismaticsCost));
            }
        }
        return trades;
    }

    public static class ShopCodec
    implements Codec<Shop> {
        public <T> DataResult<T> encode(Shop input, DynamicOps<T> ops, T prefix) {
            JsonObject obj = new JsonObject();
            obj.addProperty("shop_id", input.shopID);
            obj.addProperty("name", ((TranslatableContents)input.name.m_214077_()).m_237508_());
            obj.addProperty("texture", input.texture);
            obj.addProperty("villager_profession", input.villagerProfession);
            obj.addProperty("entity", EntityType.m_20613_(input.entity).toString());
            obj.addProperty("entity_data", input.entityData);
            if (input.blockTag != null) {
                obj.addProperty("block_tag", input.blockTag.f_203868_().toString());
            }
            obj.addProperty("hidden_from_selector", input.hiddenFromSelector);
            obj.addProperty("selector_weight", (Number)input.selectorWeight);
            obj.add("jei_catalyst", ItemAdapter.ITEM_READER.toJsonTree((Object)input.jeiCatalyst));
            obj.addProperty("stage_required", input.stageRequired);
            obj.addProperty("stage_override", input.stageOverride);
            JsonArray seasonsRequired = new JsonArray();
            obj.add("seasons_required", (JsonElement)seasonsRequired);
            for (String season : input.seasonsRequired) {
                seasonsRequired.add(season.replace("\"", ""));
            }
            obj.add("trades", (JsonElement)Shop.encodeTradesArray(input.trades, input.shopID));
            JsonArray randomizedTrades = new JsonArray();
            for (RandomSetShopOffers randomSetShopOffers : input.randomSets) {
                JsonObject rsObject = new JsonObject();
                rsObject.addProperty("stage_required", randomSetShopOffers.getStageRequired());
                rsObject.addProperty("stage_override", randomSetShopOffers.getStageOverride());
                JsonArray rsSeasonsRequired = new JsonArray();
                for (String season : randomSetShopOffers.getSeasonsRequired()) {
                    rsSeasonsRequired.add(season.replace("\"", ""));
                }
                rsObject.add("seasons_required", (JsonElement)rsSeasonsRequired);
                rsObject.addProperty("random_style", switch (randomSetShopOffers.getRandomStyle()) {
                    case RandomStyle.PER_DAY -> "per_day";
                    case RandomStyle.PER_PLAYER -> "per_player";
                    case RandomStyle.PER_ENTITY -> "per_entity";
                    default -> "default";
                });
                rsObject.addProperty("rolled_count", (Number)randomSetShopOffers.getRolledCount());
                rsObject.add("trades", (JsonElement)Shop.encodeTradesArray(randomSetShopOffers, input.shopID));
                randomizedTrades.add((JsonElement)rsObject);
            }
            obj.add("random_sets", (JsonElement)randomizedTrades);
            return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, (JsonElement)obj));
        }

        public <T> DataResult<Pair<Shop, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el;
            String entityStr;
            JsonObject obj = ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject();
            String shopId = GsonHelper.m_13906_((JsonObject)obj, (String)"shop_id");
            MutableComponent name = Component.m_237115_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"name"));
            String texture = GsonHelper.m_13906_((JsonObject)obj, (String)"texture");
            String villagerProfession = "";
            if (obj.has("villager_profession")) {
                villagerProfession = GsonHelper.m_13906_((JsonObject)obj, (String)"villager_profession");
            }
            EntityType entity = null;
            if (obj.has("entity") && (entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityStr = GsonHelper.m_13906_((JsonObject)obj, (String)"entity")))) == EntityType.f_20510_ && !"minecraft:pig".equals(entityStr)) {
                throw new JsonParseException("Shop has entity type " + entityStr);
            }
            String entityData = "";
            if (obj.has("entity_data")) {
                entityData = GsonHelper.m_13906_((JsonObject)obj, (String)"entity_data");
            }
            TagKey blockTag = null;
            if (obj.has("block_tag")) {
                blockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(obj.get("block_tag").getAsString()));
            }
            boolean hiddenFromSelector = false;
            if (obj.has("hidden_from_selector") && (el = obj.get("hidden_from_selector")) != null && !el.isJsonNull() && el.isJsonPrimitive()) {
                JsonPrimitive p = el.getAsJsonPrimitive();
                if (p.isBoolean()) {
                    hiddenFromSelector = p.getAsBoolean();
                } else if (p.isNumber()) {
                    hiddenFromSelector = p.getAsInt() != 0;
                }
            }
            int selectorWeight = 1;
            if (obj.has("selector_weight")) {
                selectorWeight = GsonHelper.m_13927_((JsonObject)obj, (String)"selector_weight");
            }
            ItemStack jeiCatalyst = Items.f_42601_.m_7968_();
            if (obj.has("jei_catalyst")) {
                jeiCatalyst = (ItemStack)ItemAdapter.ITEM_READER.fromJson((JsonElement)obj.getAsJsonObject("jei_catalyst"), ItemStack.class);
            }
            String stageRequired = "";
            if (obj.has("stage_required")) {
                stageRequired = GsonHelper.m_13906_((JsonObject)obj, (String)"stage_required");
            }
            String stageOverride = "";
            if (obj.has("stage_override")) {
                stageOverride = GsonHelper.m_13906_((JsonObject)obj, (String)"stage_override");
            }
            ArrayList<String> seasonsRequired = new ArrayList<String>();
            if (obj.has("seasons_required")) {
                for (JsonElement json : GsonHelper.m_13933_((JsonObject)obj, (String)"seasons_required")) {
                    seasonsRequired.add(String.valueOf(json).replace("\"", ""));
                }
            }
            ShopOffers trades = Shop.decodeTradesArray(obj);
            ArrayList<RandomSetShopOffers> randomSets = new ArrayList<RandomSetShopOffers>();
            if (obj.has("random_sets")) {
                for (JsonElement json : GsonHelper.m_13933_((JsonObject)obj, (String)"random_sets")) {
                    JsonObject objJson = json.getAsJsonObject();
                    RandomSetShopOffers rsTrades = Shop.decodeTradesArray(objJson).toRandomShopOffers();
                    if (objJson.has("stage_required")) {
                        rsTrades.setStageRequired(GsonHelper.m_13906_((JsonObject)objJson, (String)"stage_required"));
                    }
                    if (objJson.has("stage_override")) {
                        rsTrades.setStageOverride(GsonHelper.m_13906_((JsonObject)objJson, (String)"stage_override"));
                    }
                    ArrayList<String> rsSeasonsRequired = new ArrayList<String>();
                    if (objJson.has("seasons_required")) {
                        for (JsonElement sjson : GsonHelper.m_13933_((JsonObject)objJson, (String)"seasons_required")) {
                            rsSeasonsRequired.add(String.valueOf(sjson).replace("\"", ""));
                        }
                    }
                    if (objJson.has("rolled_count")) {
                        rsTrades.setRolledCount(GsonHelper.m_13927_((JsonObject)objJson, (String)"rolled_count"));
                    }
                    if (objJson.has("random_style")) {
                        RandomStyle foundStyle = switch (GsonHelper.m_13906_((JsonObject)objJson, (String)"random_style")) {
                            case "per_day" -> RandomStyle.PER_DAY;
                            case "per_player" -> RandomStyle.PER_PLAYER;
                            case "per_entity" -> RandomStyle.PER_ENTITY;
                            default -> RandomStyle.DEFAULT;
                        };
                        rsTrades.setRandomStyle(foundStyle);
                    }
                    rsTrades.setSeasonsRequired(rsSeasonsRequired);
                    randomSets.add(rsTrades);
                }
            }
            return DataResult.success((Object)Pair.of((Object)new Shop(shopId, name, texture, villagerProfession, (EntityType<? extends LivingEntity>)entity, entityData, (TagKey<Block>)blockTag, hiddenFromSelector, selectorWeight, jeiCatalyst, stageRequired, stageOverride, seasonsRequired, trades, randomSets), input));
        }
    }
}

