/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.JEI;

import io.github.chakyl.societytrading.JEI.ShopCategory;
import io.github.chakyl.societytrading.JEI.ShopRecipe;
import io.github.chakyl.societytrading.JEI.TradeRecipe;
import io.github.chakyl.societytrading.JEI.TradesCategory;
import io.github.chakyl.societytrading.data.Shop;
import io.github.chakyl.societytrading.data.ShopRegistry;
import io.github.chakyl.societytrading.trading.ShopOffer;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;

@JeiPlugin
public class SocietyTradingJei
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("society_trading", "plugin");

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new TradesCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new ShopCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<ShopRecipe> shopRecipeList = new ArrayList<ShopRecipe>();
        ArrayList<TradeRecipe> tradeRecipeList = new ArrayList<TradeRecipe>();
        for (Shop shop : ShopRegistry.INSTANCE.getValues()) {
            shopRecipeList.add(new ShopRecipe(shop));
            for (ShopOffer offer : shop.trades()) {
                tradeRecipeList.add(new TradeRecipe(offer, shop.jeiCatalyst(), shop.name()));
            }
        }
        registration.addRecipes(ShopCategory.TYPE, shopRecipeList);
        registration.addRecipes(TradesCategory.TYPE, tradeRecipeList);
    }

    public ResourceLocation getPluginUid() {
        return UID;
    }
}

