/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.common.debug;

import com.unascribed.ears.common.EarsVersion;
import com.unascribed.ears.common.debug.EarsLogImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EarsLog {
    public static final boolean DEBUG = EarsLogImpl.checkDebug();
    private static final Set<String> ONLY_DEBUG = EarsLogImpl.checkOnlyDebug();
    private static final Pattern BRACES_PATTERN = Pattern.compile("{}", 16);
    private static final long START = System.nanoTime();
    private static final long NANOS_TO_SECONDS = 1000000000L;
    private static final long NANOS_TO_MILLIS = 1000000L;

    public static boolean shouldLog(Tag tag) {
        return DEBUG && (tag == Tag.COMMON_ALWAYS || ONLY_DEBUG == null || ONLY_DEBUG.contains(tag.toString()));
    }

    public static void debugva(Tag tag, String fmt, Object ... arg) {
        if (EarsLog.shouldLog(tag)) {
            StringBuffer buf = new StringBuffer();
            Matcher m = BRACES_PATTERN.matcher(fmt);
            int i = 0;
            while (m.find()) {
                m.appendReplacement(buf, arg != null && i < arg.length ? String.valueOf(arg[i]).replace("\\", "\\\\").replace("$", "\\$") : "{}");
                ++i;
            }
            m.appendTail(buf);
            long diff = System.nanoTime() - START;
            int secs = (int)(diff / 1000000000L);
            int millis = (int)(diff / 1000000L % 1000L);
            if (arg != null && arg.length > 0 && arg[arg.length - 1] instanceof Throwable) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ((Throwable)arg[arg.length - 1]).printStackTrace(pw);
                pw.flush();
                EarsLogImpl.log(sw.toString().trim());
            }
            EarsLogImpl.log(EarsLogImpl.buildMsg(secs, millis, tag.toString(), buf.toString()));
        }
    }

    public static void debug(Tag tag, String fmt) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, new Object[0]);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1);
        }
    }

    public static void debug(Tag tag, String fmt, float arg1) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, Float.valueOf(arg1));
        }
    }

    public static void debug(Tag tag, String fmt, double arg1) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1);
        }
    }

    public static void debug(Tag tag, String fmt, boolean arg1) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1);
        }
    }

    public static void debug(Tag tag, String fmt, int arg1) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1);
        }
    }

    public static void debug(Tag tag, String fmt, int arg1, int arg2) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2);
        }
    }

    public static void debug(Tag tag, String fmt, int arg1, Object arg2) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, Object arg2) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, float arg2) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2));
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, Object arg2, float arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, Float.valueOf(arg3));
        }
    }

    public static void debug(Tag tag, String fmt, int arg1, Object arg2, boolean arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, Object arg2, Object arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3);
        }
    }

    public static void debug(Tag tag, String fmt, int arg1, Object arg2, Object arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, float arg2, float arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2), Float.valueOf(arg3));
        }
    }

    public static void debug(Tag tag, String fmt, float arg1, float arg2, float arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, Float.valueOf(arg1), Float.valueOf(arg2), Float.valueOf(arg3));
        }
    }

    public static void debug(Tag tag, String fmt, int arg1, int arg2, Object arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3);
        }
    }

    public static void debug(Tag tag, String fmt, float arg1, float arg2, float arg3, float arg4) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, Float.valueOf(arg1), Float.valueOf(arg2), Float.valueOf(arg3), Float.valueOf(arg4));
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, float arg2, float arg3, float arg4) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2), Float.valueOf(arg3), Float.valueOf(arg4));
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, float arg2, float arg3, float arg4, float arg5) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2), Float.valueOf(arg3), Float.valueOf(arg4), Float.valueOf(arg5));
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, int arg2, int arg3, int arg4, int arg5) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public static void debug(Tag tag, String fmt, int arg1, int arg2, int arg3, int arg4, boolean arg5) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, int arg2, int arg3, int arg4, int arg5, boolean arg6) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, Object arg2, int arg3, int arg4, int arg5, int arg6) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    public static void debug(Tag tag, String fmt, int arg1, int arg2, int arg3, int arg4, Object arg5, Object arg6) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    public static void debug(Tag tag, String fmt, int arg1, int arg2, int arg3, int arg4, Object arg5, Object arg6, Object arg7) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, float arg2, float arg3, float arg4, float arg5, float arg6, float arg7, float arg8) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2), Float.valueOf(arg3), Float.valueOf(arg4), Float.valueOf(arg5), Float.valueOf(arg6), Float.valueOf(arg7), Float.valueOf(arg8));
        }
    }

    public static void debug(Tag tag, String fmt, Object arg1, Object arg2, int arg3, Object arg4, float arg5, float arg6, float arg7, float arg8, float arg9, float arg10) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, Float.valueOf(arg5), Float.valueOf(arg6), Float.valueOf(arg7), Float.valueOf(arg8), Float.valueOf(arg9), Float.valueOf(arg10));
        }
    }

    static {
        if (DEBUG) {
            if (EarsVersion.PLATFORM != null) {
                EarsLog.debug(Tag.COMMON_ALWAYS, "Hello, World! Ears Common v{}, {} Platform v{}", (Object)"1.4.7", (Object)EarsVersion.PLATFORM_KIND, (Object)EarsVersion.PLATFORM);
            } else {
                EarsLog.debug(Tag.COMMON_ALWAYS, "Hello, World! Ears Common v{}", "1.4.7");
            }
            if (ONLY_DEBUG != null) {
                EarsLog.debug(Tag.COMMON_ALWAYS, "Debugging is enabled with allowed tags {}", ONLY_DEBUG);
                for (String s : ONLY_DEBUG) {
                    if (Tag.ALL.contains(s)) continue;
                    EarsLog.debug(Tag.COMMON_ALWAYS, "Tag {} does not exist", s);
                }
            } else {
                EarsLog.debug(Tag.COMMON_ALWAYS, "Debugging is enabled with all tags");
            }
        }
    }

    public static class Tag {
        private static final Set<String> ALL = new HashSet<String>();
        public static final Tag COMMON_ALWAYS = new Tag("Common");
        public static final Tag COMMON = new Tag("Common");
        public static final Tag COMMON_AGENT = new Tag("Common:Agent");
        public static final Tag COMMON_API = new Tag("Common:Api");
        public static final Tag COMMON_FEATURES = new Tag("Common:Features");
        public static final Tag COMMON_MIXIN = new Tag("Common:Mixin");
        public static final Tag COMMON_RENDERER = new Tag("Common:Renderer");
        public static final Tag COMMON_RENDERER_DOTS = new Tag("Common:Renderer:Dots");
        public static final Tag PLATFORM = new Tag("Platform");
        public static final Tag PLATFORM_LOAD = new Tag("Platform:Load");
        public static final Tag PLATFORM_RENDERER = new Tag("Platform:Renderer");
        public static final Tag PLATFORM_RENDERER_DELEGATE = new Tag("Platform:Renderer:Delegate");
        public static final Tag PLATFORM_INJECT = new Tag("Platform:Inject");
        public static final Tag PLATFORM_INJECT_RENDERER = new Tag("Platform:Inject:Renderer");
        private final String tag;

        private Tag(String tag) {
            this.tag = tag;
            ALL.add(tag);
        }

        public String toString() {
            return this.tag;
        }
    }
}

