/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.api.features;

import com.unascribed.ears.EarsFeaturesLookup;
import com.unascribed.ears.api.Slice;
import com.unascribed.ears.api.features.AlfalfaData;
import java.util.UUID;
import org.teavm.jso.JSBody;

public class EarsFeatures {
    private static final EarsFeaturesLookup lookup;
    public static final EarsFeatures DISABLED;
    public final boolean enabled;
    public final EarMode earMode;
    public final EarAnchor earAnchor;
    public final boolean claws;
    public final boolean horn;
    public final TailMode tailMode;
    public final int tailSegments;
    public final float tailBend0;
    public final float tailBend1;
    public final float tailBend2;
    public final float tailBend3;
    public final int snoutOffset;
    public final int snoutWidth;
    public final int snoutHeight;
    public final int snoutDepth;
    public final float chestSize;
    public final WingMode wingMode;
    public final boolean animateWings;
    public final boolean capeEnabled;
    public final boolean emissive;
    public final Slice emissiveSkin;
    public final Slice emissiveWing;
    public final AlfalfaData alfalfa;

    @JSBody(script="return true")
    private static boolean isJs() {
        return false;
    }

    private static Object getLookupImpl() throws Throwable {
        return Class.forName("com.unascribed.ears.common.EarsFeaturesStorage").getField("INSTANCE").get(null);
    }

    public static EarsFeatures getById(UUID id) {
        return lookup.getById(id);
    }

    public static EarsFeatures getByUsername(String username) {
        return lookup.getByUsername(username);
    }

    private EarsFeatures(Builder builder) {
        this.enabled = true;
        this.earMode = builder.earMode;
        this.earAnchor = builder.earAnchor;
        this.claws = builder.claws;
        this.horn = builder.horn;
        this.tailMode = builder.tailMode;
        this.tailSegments = builder.tailSegments;
        this.tailBend0 = builder.tailBend0;
        this.tailBend1 = builder.tailBend1;
        this.tailBend2 = builder.tailBend2;
        this.tailBend3 = builder.tailBend3;
        this.snoutOffset = builder.snoutOffset;
        this.snoutWidth = builder.snoutWidth;
        this.snoutHeight = builder.snoutHeight;
        this.snoutDepth = builder.snoutDepth;
        this.chestSize = builder.chestSize;
        this.wingMode = builder.wingMode;
        this.animateWings = builder.animateWings;
        this.capeEnabled = builder.capeEnabled;
        this.emissive = builder.emissive;
        this.emissiveSkin = builder.emissiveSkin;
        this.emissiveWing = builder.emissiveWing;
        this.alfalfa = builder.alfalfa;
    }

    private EarsFeatures() {
        this.enabled = false;
        this.earMode = EarMode.NONE;
        this.earAnchor = EarAnchor.CENTER;
        this.claws = false;
        this.horn = false;
        this.tailMode = TailMode.NONE;
        this.tailSegments = 0;
        this.tailBend0 = 0.0f;
        this.tailBend1 = 0.0f;
        this.tailBend2 = 0.0f;
        this.tailBend3 = 0.0f;
        this.snoutOffset = 0;
        this.snoutWidth = 0;
        this.snoutHeight = 0;
        this.snoutDepth = 0;
        this.chestSize = 0.0f;
        this.wingMode = WingMode.NONE;
        this.animateWings = true;
        this.capeEnabled = false;
        this.emissive = false;
        this.emissiveSkin = Slice.EMPTY;
        this.emissiveWing = Slice.EMPTY;
        this.alfalfa = AlfalfaData.NONE;
    }

    public String toString() {
        return "EarsFeatures[earMode=" + (Object)((Object)this.earMode) + ", earAnchor=" + (Object)((Object)this.earAnchor) + ", claws=" + this.claws + ", horn=" + this.horn + "tailMode=" + (Object)((Object)this.tailMode) + "tailSegments=" + this.tailSegments + "tailBends=[" + this.tailBend0 + ", " + this.tailBend1 + ", " + this.tailBend2 + ", " + this.tailBend3 + "], snoutOffset=" + this.snoutOffset + ", snoutWidth=" + this.snoutWidth + ", snoutHeight=" + this.snoutHeight + ", snoutDepth=" + this.snoutDepth + ", " + (this.chestSize > 0.0f ? "chestSize=" + this.chestSize + ", " : "") + "wingMode=" + (Object)((Object)this.wingMode) + ", animateWings=" + this.animateWings + ", " + (this.capeEnabled ? "capeEnabled=" + this.capeEnabled + ", " : "") + "emissive=" + this.emissive + ", emissiveSkin=" + this.emissiveSkin + ", emissiveWing=" + this.emissiveWing + ", alfalfa=" + this.alfalfa + "]";
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    static {
        EarsFeaturesLookup lookupTmp = null;
        if (!EarsFeatures.isJs()) {
            try {
                lookupTmp = (EarsFeaturesLookup)EarsFeatures.getLookupImpl();
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.err.println("[Ears] Failed to load static feature lookup binder");
                lookupTmp = null;
            }
        }
        if (lookupTmp == null) {
            lookupTmp = new EarsFeaturesLookup(){

                @Override
                public EarsFeatures getByUsername(String username) {
                    throw new AbstractMethodError();
                }

                @Override
                public EarsFeatures getById(UUID id) {
                    throw new AbstractMethodError();
                }
            };
        }
        lookup = lookupTmp;
        DISABLED = new EarsFeatures();
    }

    public static final class Builder {
        private EarMode earMode;
        private EarAnchor earAnchor;
        private boolean claws;
        private boolean horn;
        private TailMode tailMode;
        private int tailSegments;
        private float tailBend0;
        private float tailBend1;
        private float tailBend2;
        private float tailBend3;
        private int snoutOffset;
        private int snoutWidth;
        private int snoutHeight;
        private int snoutDepth;
        private float chestSize;
        private WingMode wingMode;
        private boolean animateWings;
        private boolean capeEnabled;
        private boolean emissive;
        private Slice emissiveSkin;
        private Slice emissiveWing;
        private AlfalfaData alfalfa;

        public Builder tailBends(float tailBend0, float tailBend1, float tailBend2, float tailBend3) {
            return this.tailBend0(tailBend0).tailBend1(tailBend1).tailBend2(tailBend2).tailBend3(tailBend3);
        }

        private Builder() {
        }

        public Builder earMode(EarMode earMode) {
            this.earMode = earMode;
            return this;
        }

        public Builder earAnchor(EarAnchor earAnchor) {
            this.earAnchor = earAnchor;
            return this;
        }

        public Builder claws(boolean claws) {
            this.claws = claws;
            return this;
        }

        public Builder horn(boolean horn) {
            this.horn = horn;
            return this;
        }

        public Builder tailMode(TailMode tailMode) {
            this.tailMode = tailMode;
            return this;
        }

        public Builder tailSegments(int tailSegments) {
            this.tailSegments = tailSegments;
            return this;
        }

        public Builder tailBend0(float tailBend0) {
            this.tailBend0 = tailBend0;
            return this;
        }

        public Builder tailBend1(float tailBend1) {
            this.tailBend1 = tailBend1;
            return this;
        }

        public Builder tailBend2(float tailBend2) {
            this.tailBend2 = tailBend2;
            return this;
        }

        public Builder tailBend3(float tailBend3) {
            this.tailBend3 = tailBend3;
            return this;
        }

        public Builder snoutOffset(int snoutOffset) {
            this.snoutOffset = snoutOffset;
            return this;
        }

        public Builder snoutWidth(int snoutWidth) {
            this.snoutWidth = snoutWidth;
            return this;
        }

        public Builder snoutHeight(int snoutHeight) {
            this.snoutHeight = snoutHeight;
            return this;
        }

        public Builder snoutDepth(int snoutDepth) {
            this.snoutDepth = snoutDepth;
            return this;
        }

        public Builder chestSize(float chestSize) {
            this.chestSize = chestSize;
            return this;
        }

        public Builder wingMode(WingMode wingMode) {
            this.wingMode = wingMode;
            return this;
        }

        public Builder animateWings(boolean animateWings) {
            this.animateWings = animateWings;
            return this;
        }

        public Builder capeEnabled(boolean capeEnabled) {
            this.capeEnabled = capeEnabled;
            return this;
        }

        public Builder emissive(boolean emissive) {
            this.emissive = emissive;
            return this;
        }

        public Builder emissiveSkin(Slice emissiveSkin) {
            this.emissiveSkin = emissiveSkin;
            return this;
        }

        public Builder emissiveWing(Slice emissiveWing) {
            this.emissiveWing = emissiveWing;
            return this;
        }

        public Builder alfalfa(AlfalfaData alfalfa) {
            this.alfalfa = alfalfa;
            return this;
        }

        public EarMode getEarMode() {
            return this.earMode;
        }

        public EarAnchor getEarAnchor() {
            return this.earAnchor;
        }

        public boolean isClaws() {
            return this.claws;
        }

        public boolean isHorn() {
            return this.horn;
        }

        public TailMode getTailMode() {
            return this.tailMode;
        }

        public int getTailSegments() {
            return this.tailSegments;
        }

        public float getTailBend0() {
            return this.tailBend0;
        }

        public float getTailBend1() {
            return this.tailBend1;
        }

        public float getTailBend2() {
            return this.tailBend2;
        }

        public float getTailBend3() {
            return this.tailBend3;
        }

        public int getSnoutOffset() {
            return this.snoutOffset;
        }

        public int getSnoutWidth() {
            return this.snoutWidth;
        }

        public int getSnoutHeight() {
            return this.snoutHeight;
        }

        public int getSnoutDepth() {
            return this.snoutDepth;
        }

        public float getChestSize() {
            return this.chestSize;
        }

        public WingMode getWingMode() {
            return this.wingMode;
        }

        public boolean isAnimateWings() {
            return this.animateWings;
        }

        public boolean isCapeEnabled() {
            return this.capeEnabled;
        }

        public boolean isEmissive() {
            return this.emissive;
        }

        public Slice getEmissiveSkin() {
            return this.emissiveSkin;
        }

        public Slice getEmissiveWing() {
            return this.emissiveWing;
        }

        public AlfalfaData getAlfalfa() {
            return this.alfalfa;
        }

        public EarsFeatures build() {
            return new EarsFeatures(this);
        }
    }

    public static enum WingMode {
        NONE,
        SYMMETRIC_DUAL,
        SYMMETRIC_SINGLE,
        ASYMMETRIC_L,
        ASYMMETRIC_R,
        ASYMMETRIC_DUAL,
        FLAT;

    }

    public static enum TailMode {
        NONE,
        DOWN,
        BACK,
        UP,
        VERTICAL,
        CROSS,
        CROSS_OVERLAP,
        STAR,
        STAR_OVERLAP;

    }

    public static enum EarAnchor {
        CENTER,
        FRONT,
        BACK;

    }

    public static enum EarMode {
        NONE,
        ABOVE,
        SIDES,
        BEHIND,
        AROUND,
        FLOPPY,
        CROSS,
        OUT,
        TALL,
        TALL_CROSS;

    }
}

