/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.experience.ExperienceConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionsConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;
import net.puffish.skillsmod.util.DisposeContext;

public record CategoryConfig(ResourceLocation id, GeneralConfig general, SkillDefinitionsConfig definitions, SkillsConfig skills, SkillConnectionsConfig connections, Optional<ExperienceConfig> experience) {
    public static Result<CategoryConfig, Problem> parse(ResourceLocation id, JsonElement generalElement, JsonElement definitionsElement, JsonElement skillsElement, JsonElement connectionsElement, Optional<JsonElement> optExperienceElement, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<GeneralConfig> optGeneral = GeneralConfig.parse(generalElement, context).ifFailure(problems::add).getSuccess();
        Optional<ExperienceConfig> optExperience = optExperienceElement.flatMap(experience -> ExperienceConfig.parse(experience, context).ifFailure(problems::add).getSuccess().flatMap(Function.identity()));
        Optional<SkillDefinitionsConfig> optDefinitions = SkillDefinitionsConfig.parse(definitionsElement, context).ifFailure(problems::add).getSuccess();
        Optional optSkills = optDefinitions.flatMap(definitions -> SkillsConfig.parse(skillsElement, definitions, context).ifFailure(problems::add).getSuccess());
        Optional optConnections = optSkills.flatMap(skills -> SkillConnectionsConfig.parse(connectionsElement, skills, context).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new CategoryConfig(id, optGeneral.orElseThrow(), optDefinitions.orElseThrow(), (SkillsConfig)optSkills.orElseThrow(), (SkillConnectionsConfig)optConnections.orElseThrow(), optExperience));
        }
        return Result.failure(Problem.combine(problems));
    }

    public void dispose(DisposeContext context) {
        this.definitions.dispose(context);
        this.experience.ifPresent(experience -> experience.dispose(context));
    }
}

