/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.registry;

import com.berksire.furniture.block.BenchBlock;
import com.berksire.furniture.block.BinBlock;
import com.berksire.furniture.block.BlueprintsBlock;
import com.berksire.furniture.block.BoatInAJarBlock;
import com.berksire.furniture.block.CabinetBlock;
import com.berksire.furniture.block.CashRegisterBlock;
import com.berksire.furniture.block.ChimneyBlock;
import com.berksire.furniture.block.ClockBlock;
import com.berksire.furniture.block.CofferBlock;
import com.berksire.furniture.block.CopperChimneyBlock;
import com.berksire.furniture.block.CurtainBlock;
import com.berksire.furniture.block.DeskBlock;
import com.berksire.furniture.block.DeskChairBlock;
import com.berksire.furniture.block.DisplayBlock;
import com.berksire.furniture.block.DresserBlock;
import com.berksire.furniture.block.ExplorersBoxBlock;
import com.berksire.furniture.block.FishTankBlock;
import com.berksire.furniture.block.GramophoneBlock;
import com.berksire.furniture.block.GrandfatherClockBlock;
import com.berksire.furniture.block.LampBlock;
import com.berksire.furniture.block.LampWallBlock;
import com.berksire.furniture.block.MirrorBlock;
import com.berksire.furniture.block.PlanterBlock;
import com.berksire.furniture.block.PouffeBlock;
import com.berksire.furniture.block.SewingKitBlock;
import com.berksire.furniture.block.ShutterBlock;
import com.berksire.furniture.block.SofaBlock;
import com.berksire.furniture.block.SteamVentBlock;
import com.berksire.furniture.block.StreetLanternBlock;
import com.berksire.furniture.block.StreetLanternWallBlock;
import com.berksire.furniture.block.TelescopeBlock;
import com.berksire.furniture.block.TerrariumBlock;
import com.berksire.furniture.block.ToolBoxBlock;
import com.berksire.furniture.item.CanvasItem;
import com.berksire.furniture.item.PellsSpawnItem;
import com.berksire.furniture.item.TrashBagItem;
import com.berksire.furniture.registry.CanvasRegistry;
import com.berksire.furniture.registry.SoundRegistry;
import com.berksire.furniture.registry.TagRegistry;
import com.berksire.furniture.util.FurnitureIdentifier;
import com.berksire.furniture.util.FurnitureUtil;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"furniture", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"furniture", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final Map<String, RegistrySupplier<Block>> SOFAS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> POUFFE = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> LAMPS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> WALL_LAMPS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Item>> LAMP_ITEMS = new HashMap<String, RegistrySupplier<Item>>();
    public static final Map<String, RegistrySupplier<Block>> CURTAINS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> CABINETS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> DESK_CHAIRS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> DESKS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> DRESSER = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> GRANDFATHER_CLOCKS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> CLOCKS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> BENCHES = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> MIRRORS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> SHUTTERS = new HashMap<String, RegistrySupplier<Block>>();
    public static final RegistrySupplier<Block> GRAMOPHONE = ObjectRegistry.registerWithItem("gramophone", () -> new GramophoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50131_)));
    public static final RegistrySupplier<Block> TELESCOPE = ObjectRegistry.registerWithItem("telescope", () -> new TelescopeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> COFFER = ObjectRegistry.registerWithItem("coffer", () -> new CofferBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_).m_278166_(PushReaction.DESTROY)));
    public static final RegistrySupplier<Block> EXPLORERS_BOX = ObjectRegistry.registerWithItem("explorers_box", () -> new ExplorersBoxBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50621_)));
    public static final RegistrySupplier<Block> CASH_REGISTER = ObjectRegistry.registerWithItem("cash_register", () -> new CashRegisterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_)));
    public static final RegistrySupplier<Block> TOOL_BOX = ObjectRegistry.registerWithItem("tool_box", () -> new ToolBoxBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50625_).m_278166_(PushReaction.DESTROY)));
    public static final RegistrySupplier<Block> BLUEPRINTS = ObjectRegistry.registerWithItem("blueprints", () -> new BlueprintsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_).m_60966_()));
    public static final RegistrySupplier<Block> SEWING_KIT = ObjectRegistry.registerWithItem("sewing_kit", () -> new SewingKitBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50617_)));
    public static final RegistrySupplier<Item> CANVAS = ObjectRegistry.registerItem("canvas", () -> new CanvasItem(new Item.Properties(), (Supplier<PaintingVariant>)CanvasRegistry.LONELY_DAISY, TagRegistry.PAINTINGS));
    public static final RegistrySupplier<Block> BIN = ObjectRegistry.registerWithItem("bin", () -> new BinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistrySupplier<Item> TRASH_BAG = ObjectRegistry.registerItem("trash_bag", () -> new TrashBagItem(new Item.Properties()));
    public static final RegistrySupplier<Block> STEAM_VENT = ObjectRegistry.registerWithItem("steam_vent", () -> new SteamVentBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistrySupplier<Block> COPPER_FISH_TANK = ObjectRegistry.registerWithItem("copper_fish_tank", () -> new FishTankBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_)));
    public static final RegistrySupplier<Block> IRON_FISH_TANK = ObjectRegistry.registerWithItem("iron_fish_tank", () -> new FishTankBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistrySupplier<Block> BRICK_CHIMNEY = ObjectRegistry.registerWithItem("brick_chimney", () -> new ChimneyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistrySupplier<Block> STONE_BRICKS_CHIMNEY = ObjectRegistry.registerWithItem("stone_bricks_chimney", () -> new ChimneyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistrySupplier<Block> COPPER_CHIMNEY = ObjectRegistry.registerWithItem("copper_chimney", () -> new CopperChimneyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_)));
    public static final RegistrySupplier<Block> BOAT_IN_A_JAR = ObjectRegistry.registerWithItem("boat_in_a_jar", () -> new BoatInAJarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)));
    public static final RegistrySupplier<Block> STREET_LANTERN = ObjectRegistry.registerWithoutItem("street_lantern", () -> new StreetLanternBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_271197_).m_60953_(StreetLanternBlock::vanillaLightLevel)));
    public static final RegistrySupplier<Block> STREET_WALL_LANTERN = ObjectRegistry.registerWithoutItem("street_lantern_wall", () -> new StreetLanternWallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_271197_).m_60953_(StreetLanternBlock::vanillaLightLevel)));
    public static final RegistrySupplier<Item> STREET_LANTERN_ITEM = ObjectRegistry.registerItem("street_lantern_item", () -> new StandingAndWallBlockItem((Block)STREET_LANTERN.get(), (Block)STREET_WALL_LANTERN.get(), new Item.Properties(), Direction.DOWN));
    public static final RegistrySupplier<Block> PLATED_STREET_LANTERN = ObjectRegistry.registerWithoutItem("plated_street_lantern", () -> new StreetLanternBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_271197_).m_60953_(StreetLanternBlock::vanillaLightLevel)));
    public static final RegistrySupplier<Block> PLATED_STREET_WALL_LANTERN = ObjectRegistry.registerWithoutItem("plated_street_lantern_wall", () -> new StreetLanternWallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_271197_).m_60953_(StreetLanternBlock::vanillaLightLevel)));
    public static final RegistrySupplier<Item> PLATED_STREET_LANTERN_ITEM = ObjectRegistry.registerItem("plated_street_lantern_item", () -> new StandingAndWallBlockItem((Block)PLATED_STREET_LANTERN.get(), (Block)PLATED_STREET_WALL_LANTERN.get(), new Item.Properties(), Direction.DOWN));
    public static final RegistrySupplier<Item> PELLS = ObjectRegistry.registerItem("pells", () -> new PellsSpawnItem(new Item.Properties()));
    public static final RegistrySupplier<Item> CPHS_PRIDE = ObjectRegistry.registerItem("cphs_pride", () -> new RecordItem(1, (SoundEvent)SoundRegistry.CPHS_PRIDE.get(), ObjectRegistry.getSettings().m_41487_(1), 191));
    public static final RegistrySupplier<Item> LETSDO_THEME = ObjectRegistry.registerItem("letsdo_theme", () -> new RecordItem(1, (SoundEvent)SoundRegistry.LETSDO_THEME.get(), ObjectRegistry.getSettings().m_41487_(1), 124));
    public static final RegistrySupplier<Block> DISPLAY = ObjectRegistry.registerWithItem("display", () -> new DisplayBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)));
    public static final RegistrySupplier<Block> TERRARIUM = ObjectRegistry.registerWithItem("terrarium", () -> new TerrariumBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)));
    public static final RegistrySupplier<Block> WOODEN_PLANTER = ObjectRegistry.registerWithItem("wooden_planter", () -> new PlanterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
    public static final RegistrySupplier<Block> STONE_BRICK_PLANTER = ObjectRegistry.registerWithItem("stone_brick_planter", () -> new PlanterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_)));
    public static final String[] colors = new String[]{"white", "light_gray", "gray", "black", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink", "brown"};
    public static final String[] woodTypes;

    private static Block getCorrespondingPlank(String woodType) {
        return switch (woodType) {
            case "spruce" -> Blocks.f_50741_;
            case "birch" -> Blocks.f_50742_;
            case "jungle" -> Blocks.f_50743_;
            case "acacia" -> Blocks.f_50744_;
            case "dark_oak" -> Blocks.f_50745_;
            case "mangrove" -> Blocks.f_220865_;
            case "cherry" -> Blocks.f_271304_;
            default -> Blocks.f_50705_;
        };
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return FurnitureUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, new FurnitureIdentifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return FurnitureUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, new FurnitureIdentifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return FurnitureUtil.registerItem(ITEMS, ITEM_REGISTRAR, new FurnitureIdentifier(path), itemSupplier);
    }

    static {
        for (String woodType : woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry"}) {
            BENCHES.put(woodType, ObjectRegistry.registerWithItem(woodType + "_bench", () -> new BenchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).m_278166_(PushReaction.IGNORE))));
            CABINETS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (Supplier<SoundEvent>)SoundRegistry.CABINET_OPEN, (Supplier<SoundEvent>)SoundRegistry.CABINET_CLOSE)));
            CLOCKS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_clock", () -> new ClockBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).m_278166_(PushReaction.IGNORE), ClockBlock.WoodType.valueOf(woodType.toUpperCase()))));
            GRANDFATHER_CLOCKS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_grandfather_clock", () -> new GrandfatherClockBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).m_278166_(PushReaction.IGNORE), GrandfatherClockBlock.WoodType.valueOf(woodType.toUpperCase()))));
            MIRRORS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_mirror", () -> new MirrorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).m_278166_(PushReaction.IGNORE))));
            SHUTTERS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_shutter", () -> new ShutterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).m_278166_(PushReaction.IGNORE))));
            DESKS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_desk", () -> new DeskBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).m_278166_(PushReaction.IGNORE))));
            DRESSER.put(woodType, ObjectRegistry.registerWithItem(woodType + "_dresser", () -> new DresserBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (Supplier<SoundEvent>)SoundRegistry.CABINET_OPEN, (Supplier<SoundEvent>)SoundRegistry.CABINET_CLOSE)));
            DESK_CHAIRS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_desk_chair", () -> new DeskChairBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)))));
        }
        for (String color : colors) {
            DyeColor dyeColor = DyeColor.valueOf((String)color.toUpperCase(Locale.ENGLISH));
            SOFAS.put(color, ObjectRegistry.registerWithItem("sofa_" + color, () -> new SofaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_278166_(PushReaction.DESTROY), dyeColor)));
            POUFFE.put(color, ObjectRegistry.registerWithItem("pouffe_" + color, () -> new PouffeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_).m_278166_(PushReaction.NORMAL), dyeColor)));
            CURTAINS.put(color, ObjectRegistry.registerWithItem("curtain_" + color, () -> new CurtainBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_).m_278166_(PushReaction.DESTROY), dyeColor)));
            String lampName = "lamp_" + color;
            String wallLampName = "lamp_wall_" + color;
            RegistrySupplier<Block> lamp = ObjectRegistry.registerWithoutItem(lampName, () -> new LampBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60953_(state -> (Boolean)state.m_61143_((Property)LampBlock.LIT) != false ? 15 : 0).m_278166_(PushReaction.DESTROY), dyeColor));
            LAMPS.put(color, lamp);
            RegistrySupplier<Block> wallLamp = ObjectRegistry.registerWithoutItem(wallLampName, () -> new LampWallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60953_(state -> (Boolean)state.m_61143_((Property)LampBlock.LIT) != false ? 15 : 0).m_278166_(PushReaction.DESTROY), dyeColor));
            WALL_LAMPS.put(color, wallLamp);
            LAMP_ITEMS.put(color, ObjectRegistry.registerItem(lampName, () -> new StandingAndWallBlockItem((Block)lamp.get(), (Block)wallLamp.get(), new Item.Properties(), Direction.DOWN)));
        }
        BLOCKS.register();
        ITEMS.register();
    }
}

