/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.item;

import com.berksire.furniture.registry.TagRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrashBagItem
extends Item {
    private static final int COOLDOWN_TICKS = 1200;
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public TrashBagItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (world.f_46443_ || user.m_6047_()) {
            return super.m_7203_(world, user, hand);
        }
        UUID userUUID = user.m_20148_();
        long currentTime = world.m_46467_();
        if (!user.m_7500_() && cooldowns.containsKey(userUUID) && currentTime - cooldowns.get(userUUID) < 1200L) {
            user.m_5661_((Component)Component.m_237115_((String)"tooltip.furniture.trash_bag.cooldown").m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        ItemStack itemStack = user.m_21120_(hand);
        Random random = new Random();
        List<Item> items = BuiltInRegistries.f_257033_.m_123024_().filter(item -> {
            String itemName = BuiltInRegistries.f_257033_.m_7981_(item).m_135815_();
            return !item.m_204114_().m_203656_(TagRegistry.TRASH_BAG_BLACKLIST) && !itemName.contains("book") && !itemName.contains("command_block") && !itemName.contains("creative") && !itemName.contains("debug") && !itemName.contains("diamond") && !itemName.contains("egg") && !itemName.contains("ender") && !itemName.contains("map") && !itemName.contains("netherite") && !itemName.contains("netherstar") && !itemName.contains("ore") && !itemName.contains("shulker") && !itemName.contains("spawn_egg") && !itemName.contains("spawn_keg") && !itemName.contains("worldshaper") && !itemName.contains("_head") && !itemName.contains("dragon") && !itemName.contains("light");
        }).toList();
        Item randomItem = items.get(random.nextInt(items.size()));
        ItemStack spawnedItem = new ItemStack((ItemLike)randomItem);
        world.m_7967_((Entity)new ItemEntity(world, user.m_20185_(), user.m_20186_(), user.m_20189_(), spawnedItem));
        if (!user.m_7500_()) {
            itemStack.m_41774_(1);
            cooldowns.put(userUUID, currentTime);
        }
        world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_184215_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.furniture.trash_bag").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
    }
}

