/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block.entity;

import com.berksire.furniture.registry.EntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class GramophoneBlockEntity
extends BlockEntity
implements Clearable {
    private ItemStack recordItem = ItemStack.f_41583_;
    private long tickCount;
    private long recordStartedTick;
    private boolean isPlaying;
    private boolean repeat;

    public GramophoneBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EntityTypeRegistry.GRAMOPHONE_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("RecordItem")) {
            this.recordItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("RecordItem"));
        }
        this.isPlaying = tag.m_128471_("IsPlaying");
        this.recordStartedTick = tag.m_128454_("RecordStartTick");
        this.tickCount = tag.m_128454_("TickCount");
        this.repeat = tag.m_128471_("Repeat");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.recordItem.m_41619_()) {
            tag.m_128365_("RecordItem", (Tag)this.recordItem.m_41739_(new CompoundTag()));
        }
        tag.m_128379_("IsPlaying", this.isPlaying);
        tag.m_128356_("RecordStartTick", this.recordStartedTick);
        tag.m_128356_("TickCount", this.tickCount);
        tag.m_128379_("Repeat", this.repeat);
    }

    public boolean isRecordPlaying() {
        return !this.recordItem.m_41619_() && this.isPlaying && (Boolean)this.m_58900_().m_61143_((Property)JukeboxBlock.f_54254_) != false;
    }

    private void startPlaying() {
        this.recordStartedTick = this.tickCount;
        this.isPlaying = true;
        assert (this.f_58857_ != null);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.f_58857_.m_5898_(null, 1010, this.f_58858_, Item.m_41393_((Item)this.recordItem.m_41720_()));
        this.m_6596_();
    }

    public static void playRecordTick(Level level, BlockPos pos, BlockState state, GramophoneBlockEntity blockEntity) {
        if (level.m_7702_(pos) instanceof GramophoneBlockEntity && blockEntity.isRecordPlaying()) {
            blockEntity.tick(level, pos, state);
        } else {
            blockEntity.stopPlaying();
        }
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        ItemStack item;
        Item item2;
        if (this.isRecordPlaying() && (item2 = (item = this.recordItem).m_41720_()) instanceof RecordItem) {
            RecordItem recordItem = (RecordItem)item2;
            if (this.tickCount >= this.recordStartedTick + (long)recordItem.m_43036_() + 20L) {
                if (this.repeat) {
                    this.startPlaying();
                } else {
                    this.stopPlaying();
                }
            } else if (this.tickCount % 20L == 0L) {
                level.m_220407_(GameEvent.f_238690_, pos, GameEvent.Context.m_223722_((BlockState)state));
                this.spawnMusicParticles(level, pos);
            }
        }
        ++this.tickCount;
    }

    private void spawnMusicParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = Vec3.m_82539_((Vec3i)pos).m_82520_(-0.25, 2.0, -0.25);
            float f = (float)level.m_213780_().m_188503_(4) / 24.0f;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0, (double)f, 0.0, 0.0, 1.0);
        }
    }

    public void popOutRecord() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.stopPlaying();
            BlockPos blockPos = this.m_58899_();
            ItemStack itemStack = this.recordItem;
            if (!itemStack.m_41619_()) {
                this.recordItem = ItemStack.f_41583_;
                ItemStack singleDisk = itemStack.m_41777_();
                singleDisk.m_41764_(1);
                Vec3 vec3 = Vec3.m_272021_((Vec3i)blockPos, (double)0.5, (double)1.01, (double)0.5).m_272010_(this.f_58857_.f_46441_, 0.7f);
                ItemEntity itemEntity = new ItemEntity(this.f_58857_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), singleDisk);
                itemEntity.m_32060_();
                this.f_58857_.m_7967_((Entity)itemEntity);
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                if (this.f_58857_.m_8055_(this.f_58858_).m_60713_(Blocks.f_50016_)) {
                    return;
                }
                BlockState state = this.f_58857_.m_8055_(this.f_58858_);
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(false)), 3);
                this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
            }
        }
    }

    public void m_7651_() {
        this.stopPlayingOnRemove();
        super.m_7651_();
    }

    public void setRecord(ItemStack record) {
        if (!record.m_41619_()) {
            this.recordItem = record.m_41777_();
            this.recordItem.m_41764_(1);
            this.setHasRecordBlockState(true);
            this.startPlaying();
            this.m_6596_();
        }
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
        this.m_6596_();
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    private void setHasRecordBlockState(boolean hasRecord) {
        if (this.f_58857_ != null && !this.f_58857_.m_8055_(this.f_58858_).m_60713_(Blocks.f_50016_)) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(hasRecord)), 3);
            this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
        }
    }

    public void stopPlaying() {
        if (this.isPlaying) {
            this.isPlaying = false;
            assert (this.f_58857_ != null);
            this.f_58857_.m_220407_(GameEvent.f_238649_, this.f_58858_, GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
            this.f_58857_.m_46796_(1011, this.f_58858_, 0);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.m_6596_();
        }
    }

    public void stopPlayingOnRemove() {
        if (this.isPlaying) {
            this.stopPlaying();
        }
    }

    public void m_6211_() {
        this.recordItem = ItemStack.f_41583_;
        this.setHasRecordBlockState(false);
        this.stopPlaying();
    }

    public ItemStack getFirstItem() {
        return this.recordItem;
    }
}

