/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TelescopeBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public TelescopeBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? this.getTopShape() : this.getBottomShape();
    }

    private VoxelShape getTopShape() {
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    }

    private VoxelShape getBottomShape() {
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos newPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (!(direction.m_122434_() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == Direction.UP) || newState.m_60713_((Block)this) && newState.m_61143_(HALF) != half)) {
            return Blocks.f_50016_.m_49966_();
        }
        return half == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, newState, world, pos, newPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Direction direction = context.m_8125_().m_122424_();
        return pos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(pos.m_7494_()).m_60629_(context) ? (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)FACING, (Comparable)direction) : null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos abovePos = pos.m_7494_();
        world.m_7731_(abovePos, (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (state.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(state, world, pos);
        }
        BlockState belowState = world.m_8055_(pos.m_7495_());
        return belowState.m_60713_((Block)this) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_) {
            if (player.m_7500_()) {
                TelescopeBlock.preventCreativeDropFromBottomPart(world, pos, state, player);
            } else {
                TelescopeBlock.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.m_6240_(world, player, pos, Blocks.f_50016_.m_49966_(), blockEntity, stack);
    }

    protected static void preventCreativeDropFromBottomPart(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos belowPos;
        BlockState belowState;
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (half == DoubleBlockHalf.UPPER && (belowState = world.m_8055_(belowPos = pos.m_7495_())).m_60713_(state.m_60734_()) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState newState = belowState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            world.m_7731_(belowPos, newState, 35);
            world.m_5898_(player, 2001, belowPos, Block.m_49956_((BlockState)belowState));
        }
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }
}

