/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.gui;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

@Environment(value=EnvType.CLIENT)
public class AdvancedTooltip
extends Tooltip {
    @Nullable
    protected Supplier<Component> supplier;
    protected int maxWidth = 170;
    protected boolean renderWithoutGap = false;

    public AdvancedTooltip(Component message, @Nullable Component narration) {
        super(message, narration);
    }

    public AdvancedTooltip(Component message) {
        this(message, message);
    }

    public AdvancedTooltip(Supplier<Component> message) {
        this(message.get());
        this.supplier = message;
    }

    public AdvancedTooltip setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public AdvancedTooltip setRenderWithoutGap(boolean render) {
        this.renderWithoutGap = render;
        return this;
    }

    public Component getMessage() {
        return this.supplier != null ? this.supplier.get() : this.f_256850_;
    }

    public List<FormattedCharSequence> m_257408_(Minecraft minecraft) {
        if (this.supplier == null) {
            if (this.f_256766_ == null) {
                this.f_256766_ = AdvancedTooltip.splitTooltip(minecraft, this.getMessage(), this.maxWidth);
            }
            return this.f_256766_;
        }
        return AdvancedTooltip.splitTooltip(minecraft, this.getMessage(), this.maxWidth);
    }

    public boolean hasCustomRender() {
        return this.renderWithoutGap;
    }

    public static List<FormattedCharSequence> splitTooltip(Minecraft minecraft, Component component, int maxWidth) {
        return minecraft.f_91062_.m_92923_((FormattedText)component, maxWidth);
    }

    public void doCustomRender(Screen screen, GuiGraphics graphics, int x, int y, ClientTooltipPositioner positioner) {
        if (!this.renderWithoutGap) {
            throw new UnsupportedOperationException("This tooltip doesn't support custom render!");
        }
        this.renderTooltipNoGap(screen, graphics, AdvancedTooltip.splitTooltip(screen.f_96541_, this.getMessage(), this.maxWidth), x, y, positioner);
    }

    protected void renderTooltipNoGap(Screen screen, GuiGraphics poseStack, List<? extends FormattedCharSequence> list, int x, int y, ClientTooltipPositioner positioner) {
        this.renderTooltipInternalNoGap(screen, poseStack, list.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), x, y, positioner);
    }

    protected void renderTooltipInternalNoGap(Screen screen, GuiGraphics graphics, List<ClientTooltipComponent> list, int i, int j, ClientTooltipPositioner clientTooltipPositioner) {
        ClientTooltipComponent clientTooltipComponent2;
        int t;
        if (list.isEmpty()) {
            return;
        }
        int k = 0;
        int l = list.size() == 1 ? -2 : -2;
        for (ClientTooltipComponent clientTooltipComponent : list) {
            int m = clientTooltipComponent.m_142069_(screen.f_96547_);
            if (m > k) {
                k = m;
            }
            l += clientTooltipComponent.m_142103_();
        }
        int n = k;
        int o = l;
        Vector2ic vector2ic = clientTooltipPositioner.m_262814_(graphics.m_280182_(), graphics.m_280206_(), i, j, n, o);
        int p = vector2ic.x();
        int q = vector2ic.y();
        graphics.m_280168_().m_85836_();
        int r = 400;
        graphics.m_286007_(() -> TooltipRenderUtil.m_280205_((GuiGraphics)graphics, (int)p, (int)q, (int)n, (int)o, (int)400));
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        int s = q;
        for (t = 0; t < list.size(); ++t) {
            clientTooltipComponent2 = list.get(t);
            clientTooltipComponent2.m_142440_(screen.f_96547_, p, s, graphics.m_280168_().m_85850_().m_252922_(), graphics.m_280091_());
            s += clientTooltipComponent2.m_142103_() + 0;
        }
        s = q;
        for (t = 0; t < list.size(); ++t) {
            clientTooltipComponent2 = list.get(t);
            clientTooltipComponent2.m_183452_(screen.f_96547_, p, s, graphics);
            s += clientTooltipComponent2.m_142103_() + 0;
        }
        graphics.m_280168_().m_85849_();
    }
}

