/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.registration.forge;

import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import lilypuree.decorative_blocks.registration.EntityDataSerializerHelper;
import lilypuree.decorative_blocks.registration.RegistrationProvider;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@ApiStatus.Internal
@AutoService(value={EntityDataSerializerHelper.class})
public class ForgeEntityDataSerializerHelper
implements EntityDataSerializerHelper {
    private final Map<String, RegistrationProvider<EntityDataSerializer<?>>> byModId = new ConcurrentHashMap();

    @Override
    public <T> EntityDataSerializer<T> register(ResourceLocation key, EntityDataSerializer<T> serializer) {
        this.getProvider(key.m_135827_()).register(key.m_135815_(), () -> serializer);
        return serializer;
    }

    private RegistrationProvider<EntityDataSerializer<?>> getProvider(String modId) {
        return this.byModId.computeIfAbsent(modId, theId -> RegistrationProvider.get(ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, theId));
    }
}

