/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import java.util.function.Consumer;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.core.DBBlocks;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class DBRecipes
extends RecipeProvider {
    public DBRecipes(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        for (VanillaWoodTypes wood : VanillaWoodTypes.values()) {
            DBRecipes.makeWoodenBlockRecipes(wood, consumer);
        }
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, DBBlocks.BAR_PANEL, 2).m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42025_), "has_ingot", new ItemLike[]{Items.f_42416_});
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, DBBlocks.LATTICE, 1).m_126130_(" # ").m_126130_("# #").m_126130_(" # ").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_), "has_stick", new ItemLike[]{Items.f_42398_});
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, DBBlocks.ROCKY_DIRT, 1).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42329_), "has_dirt", new ItemLike[]{Items.f_42329_});
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.DECORATIONS, DBBlocks.BRAZIER, 1).m_126145_("decorative_braziers").m_126130_("010").m_126130_(" 0 ").m_126127_(Character.valueOf('0'), (ItemLike)Items.f_42025_).m_206416_(Character.valueOf('1'), ItemTags.f_13160_), "has_bar", new ItemLike[]{Items.f_42025_});
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.DECORATIONS, DBBlocks.SOUL_BRAZIER, 1).m_126145_("decorative_braziers").m_126130_(" 1 ").m_126130_("020").m_126130_(" 0 ").m_126127_(Character.valueOf('0'), (ItemLike)Items.f_42025_).m_206416_(Character.valueOf('1'), ItemTags.f_13160_).m_206416_(Character.valueOf('2'), ItemTags.f_13154_), "has_bar", new ItemLike[]{Items.f_42025_});
        SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50069_}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)DBBlocks.STONE_PILLAR.get())).m_126132_("has_stone", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_41905_})).m_176498_(consumer);
        DBRecipes.makeChandelierRecipeOf((ItemLike)DBBlocks.CHANDELIER.get(), Items.f_42000_, consumer);
        DBRecipes.makeChandelierRecipeOf((ItemLike)DBBlocks.SOUL_CHANDELIER.get(), Items.f_42053_, consumer);
    }

    public static ShapedRecipeBuilder shapedRecipe(RecipeCategory category, ItemLike result, int count) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)result, (int)count);
    }

    public static ShapelessRecipeBuilder shapelessRecipe(RecipeCategory category, ItemLike result, int count) {
        return ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)result, (int)count);
    }

    public static void addRecipe(Consumer<FinishedRecipe> consumer, RecipeBuilder builder, String criterion, ItemLike ... triggers) {
        DBRecipes.addRecipe(consumer, RecipeBuilder.m_176493_((ItemLike)builder.m_142372_()), builder, criterion, triggers);
    }

    public static void addRecipe(Consumer<FinishedRecipe> consumer, ResourceLocation name, RecipeBuilder builder, String criterion, ItemLike ... triggers) {
        builder.m_126132_(criterion, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])triggers)).m_126140_(consumer, name);
    }

    public static void makeWoodenBlockRecipes(IWoodType woodType, Consumer<FinishedRecipe> consumer) {
        if (woodType != VanillaWoodTypes.BAMBOO) {
            DBRecipes.makeBeamRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.BEAM), consumer);
        }
        DBRecipes.makePalisadeRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.PALISADE), consumer);
        DBRecipes.makeSeatRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.SEAT), consumer);
        DBRecipes.makeSupportRecipeOf(DBRecipes.getBlock(woodType, WoodDecorativeBlockTypes.SUPPORT), consumer);
    }

    public static IWoodenBlock getBlock(IWoodType woodType, WoodDecorativeBlockTypes type) {
        return BuiltInRegistries.f_256975_.m_123024_().filter(block -> {
            IWoodenBlock woodenBlock;
            if (block instanceof IWoodenBlock && (woodenBlock = (IWoodenBlock)block).getWoodType() == woodType) {
                switch (type) {
                    case BEAM: {
                        return block instanceof BeamBlock;
                    }
                    case PALISADE: {
                        return block instanceof PalisadeBlock;
                    }
                    case SEAT: {
                        return block instanceof SeatBlock;
                    }
                    case SUPPORT: {
                        return block instanceof SupportBlock;
                    }
                }
            }
            return false;
        }).findFirst().orElse(null);
    }

    public static void makeChandelierRecipeOf(ItemLike chandelier, Item torch, Consumer<FinishedRecipe> consumer) {
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.DECORATIONS, chandelier, 1).m_126145_("decorative_chandeliers").m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)torch), "has_torch", new ItemLike[]{torch});
        String chandelierId = ForgeRegistries.ITEMS.getKey((Object)chandelier.m_5456_()).m_135815_();
        String torchId = ForgeRegistries.ITEMS.getKey((Object)torch).m_135815_();
        DBRecipes.addRecipe(consumer, new ResourceLocation("decorative_blocks", torchId + "_from_" + chandelierId), (RecipeBuilder)DBRecipes.shapelessRecipe(RecipeCategory.DECORATIONS, (ItemLike)torch, 4).m_126145_("torches_from_chandeliers").m_126209_(chandelier), "has_torch", new ItemLike[]{torch});
    }

    public static void makeBeamRecipeOf(IWoodenBlock block, Consumer<FinishedRecipe> consumer) {
        IWoodType wood = block.getWoodType();
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)block), 2).m_126145_("decorative_beams").m_126130_(" x ").m_126130_(" x ").m_126127_(Character.valueOf('x'), (ItemLike)wood.getStrippedLog()), "has_stripped_log", new ItemLike[]{wood.getStrippedLog()});
    }

    public static void makePalisadeRecipeOf(IWoodenBlock block, Consumer<FinishedRecipe> consumer) {
        IWoodType wood = block.getWoodType();
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)block), 6).m_126145_("decorative_palisades").m_126130_("xx ").m_126127_(Character.valueOf('x'), (ItemLike)wood.getLog()), "has_log", new ItemLike[]{wood.getLog()});
    }

    public static void makeSeatRecipeOf(IWoodenBlock block, Consumer<FinishedRecipe> consumer) {
        IWoodType wood = block.getWoodType();
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)block), 6).m_126145_("decorative_seats").m_126130_("x  ").m_126130_("y  ").m_126127_(Character.valueOf('x'), (ItemLike)wood.getSlab()).m_126127_(Character.valueOf('y'), (ItemLike)wood.getFence()), "has_plank", new ItemLike[]{wood.getPlanks()});
    }

    public static void makeSupportRecipeOf(IWoodenBlock block, Consumer<FinishedRecipe> consumer) {
        IWoodType wood = block.getWoodType();
        DBRecipes.addRecipe(consumer, (RecipeBuilder)DBRecipes.shapedRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)block), 6).m_126145_("decorative_supports").m_126130_("xx ").m_126130_("x  ").m_126127_(Character.valueOf('x'), (ItemLike)wood.getPlanks()), "has_plank", new ItemLike[]{wood.getPlanks()});
    }
}

