/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.farmlife.common.entities;

import codyhuh.farmlife.common.entities.ai.AvoidPredatorGoal;
import codyhuh.farmlife.common.entities.ai.GalliraptorTargetGoal;
import codyhuh.farmlife.registry.FLEntities;
import codyhuh.farmlife.registry.FLItems;
import codyhuh.farmlife.registry.FLSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Galliraptor
extends Animal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Galliraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PECKING = SynchedEntityData.m_135353_(Galliraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42028_, Items.f_42578_});
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int timeUntilNextEgg = this.f_19796_.m_188503_(8000) + 8000;

    public Galliraptor(EntityType<? extends Galliraptor> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(2, new AvoidPredatorGoal<Fox>((PathfinderMob)this, Fox.class, 20.0f, 1.25, 1.4));
        this.f_21345_.m_25352_(2, new AvoidPredatorGoal<Ocelot>((PathfinderMob)this, Ocelot.class, 20.0f, 1.25, 1.4));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, new GalliraptorTargetGoal<Fox>((Mob)this, Fox.class, false));
        this.f_21346_.m_25352_(0, new GalliraptorTargetGoal<Ocelot>((Mob)this, Ocelot.class, false));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? sizeIn.f_20378_ * 0.85f : 0.72f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && --this.timeUntilNextEgg <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)FLItems.GALLIRAPTOR_EGG.get());
            this.timeUntilNextEgg = this.f_19796_.m_188503_(8000) + 8000;
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)FLSounds.GALLIRAPTOR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)FLSounds.GALLIRAPTOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FLSounds.GALLIRAPTOR_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public Galliraptor getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        Galliraptor entity = (Galliraptor)((EntityType)FLEntities.GALLIRAPTOR.get()).m_20615_(this.m_9236_());
        if (entity != null) {
            int i = this.getVariant();
            if (this.f_19796_.m_188503_(5) != 0 && ageable instanceof Galliraptor && this.f_19796_.m_188499_()) {
                i = ((Galliraptor)ageable).getVariant();
            }
            entity.setVariant(i);
        }
        return entity;
    }

    public boolean m_6898_(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("EggLayTime")) {
            this.timeUntilNextEgg = compound.m_128451_("EggLayTime");
        }
        this.setVariant(compound.m_128451_("Variant"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("EggLayTime", this.timeUntilNextEgg);
        compound.m_128405_("Variant", this.getVariant());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setVariant(this.f_19796_.m_188503_(5));
        return spawnDataIn;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> e) {
        if (e.isMoving() && this.m_6162_()) {
            e.setAndContinue(RawAnimation.begin().thenLoop("animation.galliraptor_chick.walk"));
            e.getController().setAnimationSpeed(2.5);
        } else if (!e.isMoving() && this.m_6162_()) {
            e.setAndContinue(RawAnimation.begin().thenLoop("animation.galliraptor_chick.idle"));
        } else if (e.isMoving() && !this.m_6162_() && !this.m_5912_()) {
            e.setAndContinue(RawAnimation.begin().thenLoop("animation.galliraptor.walk"));
            e.getController().setAnimationSpeed(2.85);
        } else if (this.m_5912_() && !this.m_6162_()) {
            e.getController().setAnimationSpeed(1.0);
            if (e.isMoving()) {
                e.setAndContinue(RawAnimation.begin().thenLoop("animation.galliraptor.aggro_walk"));
            } else if (!e.isMoving()) {
                e.setAndContinue(RawAnimation.begin().thenLoop("animation.galliraptor.aggro_idle"));
            }
        } else if (!this.m_6162_() && this.f_19796_.m_188503_(250) == 0 && !this.m_5912_()) {
            if (e.isMoving()) {
                e.setAndContinue(RawAnimation.begin().then("animation.galliraptor.pecking_walk", Animation.LoopType.PLAY_ONCE));
            } else if (!e.isMoving()) {
                e.setAndContinue(RawAnimation.begin().then("animation.galliraptor.pecking_idle", Animation.LoopType.PLAY_ONCE));
            }
        } else {
            e.setAndContinue(RawAnimation.begin().thenLoop("animation.galliraptor.idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }
}

