/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.bakery.Bakery;
import net.satisfy.bakery.block.entity.SmallCookingPotBlockEntity;
import net.satisfy.bakery.entity.WanderingBakerEntity;
import net.satisfy.bakery.registry.ObjectRegistry;
import net.satisfy.bakery.util.BakeryIdentifier;

public final class EntityTypeRegistry
extends Enum<EntityTypeRegistry> {
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES;
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES;
    public static final RegistrySupplier<BlockEntityType<SmallCookingPotBlockEntity>> SMALL_COOKING_POT_BLOCK_ENTITY;
    public static final RegistrySupplier<EntityType<WanderingBakerEntity>> WANDERING_BAKER;
    private static final /* synthetic */ EntityTypeRegistry[] $VALUES;

    public static EntityTypeRegistry[] values() {
        return (EntityTypeRegistry[])$VALUES.clone();
    }

    public static EntityTypeRegistry valueOf(String name) {
        return Enum.valueOf(EntityTypeRegistry.class, name);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new BakeryIdentifier("small_cooking_pot"), type);
    }

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntityType(Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new BakeryIdentifier("wandering_baker"), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        EntityAttributeRegistry.register(WANDERING_BAKER, WanderingBakerEntity::createMobAttributes);
        Bakery.LOGGER.debug("Registering Mod Entities and Block Entities for bakery");
    }

    private static /* synthetic */ EntityTypeRegistry[] $values() {
        return new EntityTypeRegistry[0];
    }

    static {
        $VALUES = EntityTypeRegistry.$values();
        BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.f_256922_).getRegistrar();
        ENTITY_TYPES = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.f_256939_);
        SMALL_COOKING_POT_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity(() -> BlockEntityType.Builder.m_155273_(SmallCookingPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SMALL_COOKING_POT.get()}).m_58966_(null));
        WANDERING_BAKER = EntityTypeRegistry.registerEntityType(() -> EntityType.Builder.m_20704_(WanderingBakerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f).m_20702_(10).m_20712_(new BakeryIdentifier("wandering_baker").toString()));
    }
}

