/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.google.common.collect.Lists;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.table.InventoryProvider;
import dev.gigaherz.sewingkit.table.SewingTableInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class SewingTableMenu
extends RecipeBookMenu<Container> {
    private static final int NUM_INPUTS = 6;
    private static final int NUM_OUTPUTS = 1;
    private static final int NUM_INVENTORY = 27;
    private static final int NUM_HOTBAR = 9;
    private static final int OUTPUTS_START = 6;
    private static final int PLAYER_START = 7;
    private static final int HOTBAR_START = 34;
    private static final int PLAYER_END = 43;
    private final Level world;
    private final ContainerLevelAccess openedFrom;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private final ItemStack[] inputStacksCache = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
    private final InventoryProvider inventoryProvider;
    private List<SewingRecipe> recipes = Lists.newArrayList();
    private long lastTimeSoundPlayed;
    private Runnable inventoryUpdateListener = () -> {};
    public final IItemHandlerModifiable inputInventory;
    private final ResultContainer inventory = new ResultContainer();

    public SewingTableMenu(int windowIdIn, Inventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, ContainerLevelAccess.f_39287_);
    }

    public SewingTableMenu(int windowIdIn, Inventory playerInventoryIn, ContainerLevelAccess worldPosCallableIn) {
        this(windowIdIn, playerInventoryIn, worldPosCallableIn, new SewingTableInventory());
    }

    public SewingTableMenu(int windowIdIn, Inventory playerInventoryIn, final ContainerLevelAccess worldPosCallableIn, InventoryProvider inventoryProvider) {
        super((MenuType)SewingKitMod.SEWING_STATION_MENU.get(), windowIdIn);
        this.openedFrom = worldPosCallableIn;
        this.world = playerInventoryIn.f_35978_.m_9236_();
        this.inputInventory = inventoryProvider.getInventory();
        this.inventoryProvider = inventoryProvider;
        inventoryProvider.addWeakListener(this);
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 0, 8, 15){
            {
                this.setBackground(InventoryMenu.f_39692_, SewingKitMod.location("gui/needle_slot_background"));
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 1, 30, 15){
            {
                this.setBackground(InventoryMenu.f_39692_, SewingKitMod.location("gui/pattern_slot_background"));
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 2, 10, 35));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 3, 28, 35));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 4, 10, 53));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 5, 28, 53));
        this.m_38897_(new Slot((Container)this.inventory, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player thePlayer, ItemStack stack) {
                if (!thePlayer.m_9236_().f_46443_) {
                    stack.m_41678_(thePlayer.m_9236_(), thePlayer, stack.m_41613_());
                    ArrayList<ItemStack> consumed = new ArrayList<ItemStack>();
                    SewingRecipe recipe = SewingTableMenu.this.recipes.get(SewingTableMenu.this.getSelectedRecipe());
                    Map<Ingredient, Integer> remaining = recipe.getMaterials().stream().collect(Collectors.toMap(i -> i.ingredient, i -> i.count));
                    if (SewingTableMenu.this.consumeCraftingMaterials(thePlayer, remaining, consumed)) {
                        SewingTableMenu.this.updateRecipeResultSlot();
                    }
                    SewingTableMenu.this.inventory.m_58395_(thePlayer, consumed);
                    worldPosCallableIn.m_39292_((world, pos) -> {
                        long l = world.m_46467_();
                        if (SewingTableMenu.this.lastTimeSoundPlayed != l) {
                            world.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            SewingTableMenu.this.lastTimeSoundPlayed = l;
                        }
                    });
                    SewingTableMenu.this.onInventoryChanged();
                }
                super.m_142406_(thePlayer, stack);
            }
        });
        this.bindPlayerInventory(playerInventoryIn);
        this.m_38895_(this.selectedRecipe);
        this.onInventoryChanged();
    }

    private boolean consumeCraftingMaterials(Player thePlayer, Map<Ingredient, Integer> remaining, List<ItemStack> consumed) {
        boolean needsUpdate = false;
        for (int i = 0; i < 6; ++i) {
            ItemStack itemstack;
            Slot slot = (Slot)this.f_38839_.get(i);
            if (i == 0) {
                slot.m_7993_().m_41622_(1, (LivingEntity)thePlayer, player -> slot.m_6201_(1));
                itemstack = slot.m_7993_();
            } else if (i == 1) {
                itemstack = ItemStack.f_41583_;
            } else {
                int subtract = 0;
                for (Map.Entry<Ingredient, Integer> mat : remaining.entrySet()) {
                    Ingredient ing = mat.getKey();
                    int value = mat.getValue();
                    ItemStack stack1 = slot.m_7993_();
                    if (!ing.test(stack1)) continue;
                    consumed.add(stack1.m_41777_());
                    int remaining1 = Math.max(0, value - (stack1.m_41613_() + subtract));
                    subtract += value - remaining1;
                    mat.setValue(remaining1);
                }
                itemstack = slot.m_6201_(subtract);
            }
            if (itemstack.m_41619_()) continue;
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private void bindPlayerInventory(Inventory playerInventoryIn) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventoryIn, k, 8 + k * 18, 142));
        }
    }

    public void onInventoryChanged() {
        this.m_6199_((Container)new RecipeWrapper(this.inputInventory));
        this.inventoryUpdateListener.run();
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public List<SewingRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsinInputSlots() {
        return this.f_38839_.stream().skip(2L).limit(4L).anyMatch(Slot::m_6657_);
    }

    public boolean isAbleToCraft() {
        return this.hasItemsinInputSlots() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player playerIn) {
        return SewingTableMenu.isWithinUsableDistance(this.openedFrom, playerIn, (Block)SewingKitMod.SEWING_STATION_BLOCK.get(), (Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get());
    }

    protected static boolean isWithinUsableDistance(ContainerLevelAccess worldPos, Player playerIn, Block ... targetBlocks) {
        return (Boolean)worldPos.m_39299_((world, pos) -> {
            BlockState blockState = world.m_8055_(pos);
            if (Arrays.stream(targetBlocks).noneMatch(arg_0 -> ((BlockState)blockState).m_60713_(arg_0))) {
                return false;
            }
            return playerIn.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
        }, (Object)true);
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipe.m_6422_(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int p_241818_1_) {
        return p_241818_1_ >= 0 && p_241818_1_ < this.recipes.size();
    }

    public void m_6199_(Container inventoryIn) {
        super.m_6199_(inventoryIn);
        boolean anyChanged = false;
        for (int i = 0; i < 6; ++i) {
            ItemStack itemstack = ((Slot)this.f_38839_.get(i)).m_7993_();
            if (ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)this.inputStacksCache[i])) continue;
            this.inputStacksCache[i] = itemstack.m_41777_();
            anyChanged = true;
        }
        if (anyChanged) {
            this.updateAvailableRecipes(inventoryIn);
        }
    }

    private void updateAvailableRecipes(Container inventoryIn) {
        int index;
        SewingRecipe recipe = this.getSelectedRecipe() >= 0 && this.recipes.size() > 0 ? this.recipes.get(this.getSelectedRecipe()) : null;
        this.recipes.clear();
        this.selectedRecipe.m_6422_(-1);
        ((Slot)this.f_38839_.get(6)).m_5852_(ItemStack.f_41583_);
        if (this.hasItemsinInputSlots()) {
            this.recipes = this.world.m_7465_().m_44056_((RecipeType)SewingKitMod.SEWING.get(), inventoryIn, this.world);
        }
        if (this.recipes.size() > 0 && recipe != null && (index = this.recipes.indexOf(recipe)) >= 0) {
            this.selectedRecipe.m_6422_(index);
            this.updateRecipeResultSlot();
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipe.m_6501_())) {
            SewingRecipe stonecuttingrecipe = this.recipes.get(this.selectedRecipe.m_6501_());
            this.inventory.m_6029_((Recipe)stonecuttingrecipe);
            ((Slot)this.f_38839_.get(6)).m_5852_(stonecuttingrecipe.m_5874_((Container)new RecipeWrapper(this.inputInventory), this.world.m_9598_()));
        } else {
            ((Slot)this.f_38839_.get(6)).m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.inventory && super.m_5882_(stack, slotIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        Item item = stackInSlot.m_41720_();
        ItemStack stackCopy = stackInSlot.m_41777_();
        int startIndex = 7;
        int endIndex = 43;
        boolean reverse = false;
        boolean notify = false;
        if (index == 6) {
            reverse = true;
            notify = true;
        } else if (index >= 6) {
            if (stackInSlot.m_41741_() == 1 && ((Slot)this.f_38839_.get(0)).m_7993_().m_41613_() == 0) {
                startIndex = 0;
                endIndex = 1;
            } else {
                startIndex = 2;
                endIndex = 6;
            }
        }
        if (endIndex > startIndex) {
            if (notify) {
                item.m_7836_(stackInSlot, playerIn.m_9236_(), playerIn);
            }
            if (!this.m_38903_(stackInSlot, startIndex, endIndex, reverse)) {
                return ItemStack.f_41583_;
            }
            if (notify) {
                slot.m_40234_(stackInSlot, stackCopy);
            }
        }
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        slot.m_6654_();
        if (stackInSlot.m_41613_() == stackCopy.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(playerIn, stackInSlot);
        this.m_38946_();
        return stackCopy;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_8016_(0);
        if (this.inventoryProvider.isDummy()) {
            this.openedFrom.m_39292_((world, pos) -> this.m_150411_(playerIn, (Container)new RecipeWrapper(this.inputInventory)));
        }
    }

    public void m_5816_(StackedContents p_40117_) {
    }

    public void m_6650_() {
    }

    public boolean m_6032_(Recipe<? super Container> p_40118_) {
        return false;
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return 0;
    }

    public int m_6656_() {
        return 0;
    }

    public int m_6653_() {
        return 0;
    }

    public RecipeBookType m_5867_() {
        return null;
    }

    public boolean m_142157_(int p_150635_) {
        return false;
    }
}

