/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.google.common.collect.Lists;
import dev.gigaherz.sewingkit.table.SewingTableMenu;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;

public class ListenableHolder {
    private final List<Reference<? extends SewingTableMenu>> listeners = Lists.newArrayList();
    private final ReferenceQueue<SewingTableMenu> pendingRemovals = new ReferenceQueue();

    public void addWeakListener(SewingTableMenu e) {
        this.listeners.add(new WeakReference<SewingTableMenu>(e, this.pendingRemovals));
    }

    public void doCallbacks() {
        Reference<SewingTableMenu> ref = this.pendingRemovals.poll();
        while (ref != null) {
            this.listeners.remove(ref);
            ref = this.pendingRemovals.poll();
        }
        Iterator<Reference<? extends SewingTableMenu>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Reference<? extends SewingTableMenu> reference = iterator.next();
            SewingTableMenu listener = reference.get();
            if (listener == null) {
                iterator.remove();
                continue;
            }
            listener.onInventoryChanged();
        }
    }
}

