/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.integration;

import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SewingCategory
implements IRecipeCategory<SewingRecipe> {
    private static final ResourceLocation GUI_TEXTURE_LOCATION = SewingKitMod.location("textures/gui/sewing_station.png");
    public static final ResourceLocation UID = SewingKitMod.location("drying");
    public static final RecipeType<SewingRecipe> SEWING = new RecipeType(UID, SewingRecipe.class);
    public static SewingCategory INSTANCE;
    private final IDrawable background;
    private final IDrawable icon;
    private static final int[] slotX;
    private static final int[] slotY;

    public SewingCategory(IGuiHelper guiHelper) {
        INSTANCE = this;
        this.background = guiHelper.createDrawable(GUI_TEXTURE_LOCATION, 6, 12, 159, 61);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)SewingKitMod.SEWING_STATION_BLOCK.get()));
    }

    public RecipeType<SewingRecipe> getRecipeType() {
        return SEWING;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.category.sewingkit.sewing");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SewingRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> tool = Arrays.stream(recipe.getTool().m_43908_()).toList();
        List<ItemStack> pattern = Arrays.stream(recipe.getPattern().m_43908_()).toList();
        NonNullList<SewingRecipe.Material> inputs = recipe.getMaterials();
        ArrayList inputLists = new ArrayList();
        for (SewingRecipe.Material material : inputs) {
            ItemStack[] stacks = material.ingredient.m_43908_();
            List expandedInput = Arrays.stream(stacks).map(stack -> {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(material.count);
                return copy;
            }).collect(Collectors.toList());
            inputLists.add(expandedInput);
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, slotX[0], slotY[0]).addItemStacks(tool)).setSlotName("tool");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, slotX[1], slotY[1]).addItemStacks(pattern)).setSlotName("pattern");
        for (int i = 0; i < 4; ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, slotX[2 + i], slotY[2 + i]).addItemStacks(i < inputLists.size() ? (List)inputLists.get(i) : List.of());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, slotX[6], slotY[6]).addItemStack(recipe.getResultItem());
    }

    static {
        slotX = new int[]{2, 24, 4, 22, 4, 22, 137};
        slotY = new int[]{3, 3, 23, 23, 41, 41, 21};
    }
}

