/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.api.ToolActionIngredient;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.ForgeRegistries;

public class SewingRecipeBuilder {
    private final RecipeCategory category;
    private String group;
    private Ingredient tool;
    private Ingredient pattern;
    private final List<SewingRecipe.Material> materials = Lists.newArrayList();
    private final Item result;
    private final int count;
    private CompoundTag tag;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();

    public static SewingRecipeBuilder begin(RecipeCategory cat, Item result) {
        return SewingRecipeBuilder.begin(cat, result, 1, null);
    }

    public static SewingRecipeBuilder begin(RecipeCategory cat, Item result, int count) {
        return SewingRecipeBuilder.begin(cat, result, count, null);
    }

    public static SewingRecipeBuilder begin(RecipeCategory cat, Item result, CompoundTag tag) {
        return SewingRecipeBuilder.begin(cat, result, 1, tag);
    }

    public static SewingRecipeBuilder begin(RecipeCategory cat, Item result, int count, @Nullable CompoundTag tag) {
        return new SewingRecipeBuilder(cat, result, count, tag);
    }

    protected SewingRecipeBuilder(RecipeCategory cat, Item result, int count, @Nullable CompoundTag tag) {
        this.category = cat;
        this.result = result;
        this.count = count;
        this.tag = tag;
    }

    public SewingRecipeBuilder withTool(ItemLike ... tool) {
        return this.withTool(Ingredient.m_43929_((ItemLike[])tool));
    }

    public SewingRecipeBuilder withTool(TagKey<Item> tool) {
        return this.withTool(Ingredient.m_204132_(tool));
    }

    public SewingRecipeBuilder withTool(ToolAction tool, Tier level) {
        return this.withTool(ToolActionIngredient.fromTool(tool, level));
    }

    public SewingRecipeBuilder withTool(ToolAction tool) {
        return this.withTool(ToolActionIngredient.fromTool(tool, null));
    }

    public SewingRecipeBuilder withTool(Ingredient tool) {
        this.tool = tool;
        return this;
    }

    public SewingRecipeBuilder withPattern(Ingredient pattern) {
        this.pattern = pattern;
        return this;
    }

    public SewingRecipeBuilder addMaterial(int count, ItemLike ... x) {
        return this.addMaterial(Ingredient.m_43929_((ItemLike[])x), count);
    }

    public SewingRecipeBuilder addMaterial(ItemLike x, int count) {
        return this.addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{x}), count);
    }

    public SewingRecipeBuilder addMaterial(TagKey<Item> x, int count) {
        return this.addMaterial(Ingredient.m_204132_(x), 1);
    }

    public SewingRecipeBuilder addMaterial(ItemLike ... x) {
        return this.addMaterial(Ingredient.m_43929_((ItemLike[])x), 1);
    }

    public SewingRecipeBuilder addMaterial(TagKey<Item> x) {
        return this.addMaterial(Ingredient.m_204132_(x), 1);
    }

    public SewingRecipeBuilder addMaterial(Ingredient x) {
        return this.addMaterial(x, 1);
    }

    public SewingRecipeBuilder addMaterial(Ingredient x, int count) {
        if (this.materials.size() >= 4) {
            throw new IllegalArgumentException("There can only be up to 4 materials!");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be a positive integer!");
        }
        this.materials.add(SewingRecipe.Material.of(x, count));
        return this;
    }

    public SewingRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterionIn) {
        this.advancementBuilder.m_138386_(name, criterionIn);
        return this;
    }

    public SewingRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        ResourceLocation advancementId = new ResourceLocation(id.m_135827_(), "recipes/" + this.category.m_247710_() + "/" + id.m_135815_());
        consumerIn.accept(this.createFinishedRecipe(id, this.group == null ? "" : this.group, this.result, this.count, this.tag, this.tool, this.pattern, this.materials, this.advancementBuilder, advancementId));
    }

    protected FinishedRecipe createFinishedRecipe(ResourceLocation id, String group, Item result, int count, CompoundTag tag, Ingredient tool, Ingredient pattern, List<SewingRecipe.Material> materials, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
        return new Result(id, group, result, count, tag, tool, pattern, materials, advancementBuilder, advancementId);
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining sewing recipe " + id);
        }
        if (this.materials.isEmpty()) {
            throw new IllegalStateException("No ingredients for sewing recipe " + id);
        }
    }

    protected static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        @Nullable
        private final CompoundTag tag;
        private final String group;
        @Nullable
        private final Ingredient tool;
        @Nullable
        private final Ingredient pattern;
        private final List<SewingRecipe.Material> materials;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, Item result, int count, @Nullable CompoundTag tag, @Nullable Ingredient tool, @Nullable Ingredient pattern, List<SewingRecipe.Material> materials, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.tag = tag;
            this.group = group;
            this.tool = tool;
            this.pattern = pattern;
            this.materials = materials;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject recipeJson) {
            if (!this.group.isEmpty()) {
                recipeJson.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (SewingRecipe.Material material : this.materials) {
                jsonarray.add((JsonElement)material.serialize());
            }
            recipeJson.add("materials", (JsonElement)jsonarray);
            if (this.tool != null) {
                recipeJson.add("tool", this.tool.m_43942_());
            }
            if (this.pattern != null) {
                recipeJson.add("tool", this.pattern.m_43942_());
            }
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.count > 1) {
                resultJson.addProperty("count", (Number)this.count);
            }
            if (this.tag != null) {
                CompoundTag.f_128325_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.tag).result().ifPresent(result -> resultJson.add("nbt", result));
            }
            recipeJson.add("result", (JsonElement)resultJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)SewingKitMod.SEWING_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

