/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit;

import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipeBuilder;
import dev.gigaherz.sewingkit.loot.RandomDye;
import dev.gigaherz.sewingkit.needle.NeedleItem;
import dev.gigaherz.sewingkit.needle.Needles;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SewingKitDataGen {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(event.includeClient(), (DataProvider)new Lang(gen));
        ItemModels itemModels = new ItemModels(gen, event.getExistingFileHelper());
        gen.addProvider(event.includeClient(), (DataProvider)itemModels);
        gen.addProvider(event.includeClient(), (DataProvider)new BlockStates(gen, itemModels.existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new BlockTags(gen.getPackOutput(), event.getExistingFileHelper()));
        gen.addProvider(event.includeServer(), (DataProvider)new Recipes(gen.getPackOutput()));
        gen.addProvider(event.includeServer(), (DataProvider)Loot.create(gen.getPackOutput()));
    }

    public static class Lang
    extends LanguageProvider {
        public Lang(DataGenerator gen) {
            super(gen.getPackOutput(), "sewingkit", "en_us");
        }

        protected void addTranslations() {
            this.add("tab.sewing_kit", "Sewing Kit");
            this.add("container.sewingkit.sewing_station", "Sewing Station");
            this.add("container.sewingkit.storing_sewing_station", "Sewing Station with Drawers");
            this.add("jei.category.sewingkit.sewing", "Sewing");
            this.add((Item)SewingKitMod.LEATHER_STRIP.get(), "Leather Strip");
            this.add((Item)SewingKitMod.LEATHER_SHEET.get(), "Leather Sheet");
            this.add((Block)SewingKitMod.SEWING_STATION_BLOCK.get(), "Sewing Table");
            this.add((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get(), "Sewing Table with Drawers");
            Arrays.stream(Needles.values()).forEach(needle -> {
                String type = needle.getType();
                String name = type.substring(0, 1).toUpperCase() + type.substring(1);
                this.add(needle.getNeedle(), name + " Sewing Needle");
            });
            this.add("text.sewingkit.needle.lore_text", "\"Ouch!\"");
            this.add((Item)SewingKitMod.WOOL_HAT.get(), "Wool Hat");
            this.add((Item)SewingKitMod.WOOL_SHIRT.get(), "Wool Shirt");
            this.add((Item)SewingKitMod.WOOL_PANTS.get(), "Wool Pants");
            this.add((Item)SewingKitMod.WOOL_SHOES.get(), "Wool Shoes");
            this.add((Item)SewingKitMod.WOOL_ROLL.get(), "Wool Roll");
            this.add((Item)SewingKitMod.WOOL_TRIM.get(), "Wool Trim");
            this.add((Item)SewingKitMod.COMMON_PATTERN.get(), "Common Pattern");
            this.add((Item)SewingKitMod.UNCOMMON_PATTERN.get(), "Uncommon Pattern");
            this.add((Item)SewingKitMod.RARE_PATTERN.get(), "Rare Pattern");
            this.add((Item)SewingKitMod.LEGENDARY_PATTERN.get(), "Legendary Pattern");
            this.add((Item)SewingKitMod.FILE.get(), "Raspy File");
            this.add("entity.minecraft.villager.sewingkit.tailor", "Tailor");
            this.add("text.sewingkit.recipe", "Required materials:");
        }
    }

    public static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper existingFileHelper) {
            super(gen.getPackOutput(), "sewingkit", existingFileHelper);
        }

        protected void registerModels() {
            this.basicIcon(SewingKitMod.LEATHER_STRIP.getId());
            this.basicIcon(SewingKitMod.LEATHER_SHEET.getId());
            Arrays.stream(Needles.values()).forEach(needle -> this.basicIcon(needle.getId()));
            this.basicIcon(SewingKitMod.WOOL_HAT.getId());
            this.basicIcon(SewingKitMod.WOOL_SHIRT.getId());
            this.basicIcon(SewingKitMod.WOOL_PANTS.getId());
            this.basicIcon(SewingKitMod.WOOL_SHOES.getId());
            this.basicIcon(SewingKitMod.WOOL_ROLL.getId());
            this.basicIcon(SewingKitMod.WOOL_TRIM.getId());
            this.basicIcon(SewingKitMod.COMMON_PATTERN.getId());
            this.basicIcon(SewingKitMod.UNCOMMON_PATTERN.getId());
            this.basicIcon(SewingKitMod.RARE_PATTERN.getId());
            this.basicIcon(SewingKitMod.LEGENDARY_PATTERN.getId());
            this.basicIcon(SewingKitMod.FILE.getId()).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(62.0f, 147.0f, 40.0f).translation(-2.25f, 1.5f, -0.25f).scale(0.48f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(45.0f, -33.0f, -55.0f).translation(-2.25f, 1.5f, -0.25f).scale(0.48f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-54.0f, 99.0f, 136.0f).translation(1.13f, 5.0f, 1.13f).scale(0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(136.0f, -99.0f, 54.0f).translation(1.13f, 5.0f, 1.13f).scale(0.68f).end().transform(ItemDisplayContext.GROUND).translation(0.0f, 2.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.HEAD).rotation(-4.0f, 44.0f, 4.0f).translation(-7.25f, 6.75f, 0.75f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).end().end();
            ((ItemModelBuilder)this.getBuilder(SewingKitMod.SEWING_STATION_ITEM.getId().m_135815_())).parent((ModelFile)this.getExistingFile(ModelLocationUtils.m_125576_((Block)((Block)SewingKitMod.SEWING_STATION_BLOCK.get()))));
            ((ItemModelBuilder)this.getBuilder(SewingKitMod.STORING_SEWING_STATION_ITEM.getId().m_135815_())).parent((ModelFile)this.getExistingFile(ModelLocationUtils.m_125576_((Block)((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get()))));
        }

        private ItemModelBuilder basicIcon(ResourceLocation item) {
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", SewingKitMod.location("item/" + item.m_135815_()));
        }
    }

    public static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen.getPackOutput(), "sewingkit", exFileHelper);
        }

        protected void registerStatesAndModels() {
            Block block = (Block)SewingKitMod.SEWING_STATION_BLOCK.get();
            this.horizontalBlock(block, (ModelFile)this.models().getExistingFile(ModelLocationUtils.m_125576_((Block)block)));
            block = (Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get();
            this.horizontalBlock(block, (ModelFile)this.models().getExistingFile(ModelLocationUtils.m_125576_((Block)block)));
        }
    }

    private static class BlockTags
    extends IntrinsicHolderTagsProvider<Block> {
        public BlockTags(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
            super(packOutput, Registries.f_256747_, CompletableFuture.supplyAsync(VanillaRegistries::m_255371_, Util.m_183991_()), p_255627_ -> p_255627_.m_204297_().m_205785_(), "sewingkit", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider p_255662_) {
            this.m_206424_(net.minecraft.tags.BlockTags.f_144280_).m_255245_((Object)((Block)SewingKitMod.SEWING_STATION_BLOCK.get())).m_255245_((Object)((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get()));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput gen) {
            super(gen);
        }

        protected void m_245200_(Consumer<FinishedRecipe> consumer) {
            Arrays.stream(Needles.values()).forEach(needle -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)needle.getNeedle()).m_126209_((ItemLike)SewingKitMod.FILE.get()).m_126184_(needle.getTier().m_6282_()).m_126132_("has_material", (CriterionTriggerInstance)Recipes.m_206406_(needle.getMaterial())).m_176498_(consumer));
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SewingKitMod.SEWING_STATION_ITEM.get())).m_126130_("xxx").m_126130_("P P").m_126130_("S S").m_206416_(Character.valueOf('x'), ItemTags.f_13175_).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126132_("has_wood", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_13168_)).m_176498_(consumer);
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SewingKitMod.STORING_SEWING_STATION_ITEM.get())).m_126209_((ItemLike)SewingKitMod.SEWING_STATION_ITEM.get()).m_206419_(Tags.Items.CHESTS_WOODEN).m_126132_("has_station", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)SewingKitMod.SEWING_STATION_ITEM.get()))).m_176498_(consumer);
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.LEATHER_SHEET.get(), 4).withTool((TagKey<Item>)Tags.Items.SHEARS).addMaterial((TagKey<Item>)Tags.Items.LEATHER).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.LEATHER)).save(consumer, SewingKitMod.location("leather_sheet_from_leather"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.LEATHER_SHEET.get(), 1).withTool((TagKey<Item>)Tags.Items.SHEARS).addMaterial(new ItemLike[]{Items.f_42649_}).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42649_)).save(consumer, SewingKitMod.location("leather_sheet_from_rabbit_hide"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.LEATHER_STRIP.get(), 3).withTool((TagKey<Item>)Tags.Items.SHEARS).addMaterial((TagKey<Item>)Tags.Items.LEATHER).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.LEATHER)).save(consumer, SewingKitMod.location("leather_strip_from_leather"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, Items.f_42463_).withTool(NeedleItem.SEW).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 2).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get()).addMaterial((TagKey<Item>)Tags.Items.STRING).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.LEATHER)).save(consumer, SewingKitMod.location("leather_boots_via_sewing"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, Items.f_42462_).withTool(NeedleItem.SEW).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 4).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get(), 3).addMaterial((TagKey<Item>)Tags.Items.STRING).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.LEATHER)).save(consumer, SewingKitMod.location("leather_leggings_via_sewing"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, Items.f_42408_).withTool(NeedleItem.SEW).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 8).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get(), 2).addMaterial((TagKey<Item>)Tags.Items.STRING).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.LEATHER)).save(consumer, SewingKitMod.location("leather_chestplate_via_sewing"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, Items.f_42407_).withTool(NeedleItem.SEW).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 2).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get()).addMaterial((TagKey<Item>)Tags.Items.STRING).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.LEATHER)).save(consumer, SewingKitMod.location("leather_helmet_via_sewing"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, Items.f_42654_).withTool(NeedleItem.SEW, (Tier)Tiers.NETHERITE).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 12).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get(), 6).addMaterial((TagKey<Item>)Tags.Items.STRING, 8).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.LEATHER)).save(consumer, SewingKitMod.location("leather_horse_armor_via_sewing"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.WOOL_ROLL.get(), 4).withTool((TagKey<Item>)Tags.Items.SHEARS).addMaterial((TagKey<Item>)ItemTags.f_13167_).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_13167_)).save(consumer, SewingKitMod.location("wool_roll_from_wool"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.WOOL_ROLL.get(), 1).withTool((TagKey<Item>)Tags.Items.SHEARS).addMaterial((TagKey<Item>)ItemTags.f_215867_).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_215867_)).save(consumer, SewingKitMod.location("wool_roll_from_carpet"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.WOOL_TRIM.get(), 8).withTool((TagKey<Item>)Tags.Items.SHEARS).addMaterial((TagKey<Item>)ItemTags.f_13167_).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_13167_)).save(consumer, SewingKitMod.location("wool_trim_from_wool"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.WOOL_TRIM.get(), 3).withTool((TagKey<Item>)Tags.Items.SHEARS).addMaterial((TagKey<Item>)ItemTags.f_215867_).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_215867_)).save(consumer, SewingKitMod.location("wool_trim_from_carpet"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.WOOL_SHOES.get()).withTool(NeedleItem.SEW).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 1).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 2).addMaterial((TagKey<Item>)Tags.Items.STRING).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_13167_)).save(consumer, SewingKitMod.location("wool_shoes_via_sewing"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.WOOL_PANTS.get()).withTool(NeedleItem.SEW).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 2).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 4).addMaterial((TagKey<Item>)Tags.Items.STRING).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_13167_)).save(consumer, SewingKitMod.location("wool_pants_via_sewing"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.WOOL_SHIRT.get()).withTool(NeedleItem.SEW).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 3).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 3).addMaterial((TagKey<Item>)Tags.Items.STRING).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_13167_)).save(consumer, SewingKitMod.location("wool_shirt_via_sewing"));
            SewingRecipeBuilder.begin(RecipeCategory.MISC, (Item)SewingKitMod.WOOL_HAT.get()).withTool(NeedleItem.SEW).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 1).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 1).addMaterial((TagKey<Item>)Tags.Items.STRING).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_13167_)).save(consumer, SewingKitMod.location("wool_hat_via_sewing"));
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SewingKitMod.FILE.get())).m_126130_("  I").m_126130_(" I ").m_126130_("P  ").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126132_("has_iron", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_176498_(consumer);
        }
    }

    private static class Loot {
        private Loot() {
        }

        public static LootTableProvider create(PackOutput gen) {
            return new LootTableProvider(gen, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockTables::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(ChestTables::new, LootContextParamSets.f_81411_)));
        }

        public static class ChestTables
        implements LootTableSubProvider {
            public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
                consumer.accept(SewingKitMod.location("chest/tailor_shop_upper_floor"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.WOOL_HAT.get())).m_79707_(1).m_79078_(RandomDye.builder())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.WOOL_SHIRT.get())).m_79707_(1).m_79078_(RandomDye.builder())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.WOOL_PANTS.get())).m_79707_(1).m_79078_(RandomDye.builder())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.WOOL_SHOES.get())).m_79707_(1).m_79078_(RandomDye.builder())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42407_).m_79707_(1).m_79078_(RandomDye.builder())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42408_).m_79707_(1).m_79078_(RandomDye.builder())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42462_).m_79707_(1).m_79078_(RandomDye.builder())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42463_).m_79707_(1).m_79078_(RandomDye.builder()))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.WOOD_SEWING_NEEDLE.get())).m_79707_(100)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.BONE_SEWING_NEEDLE.get())).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.IRON_SEWING_NEEDLE.get())).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.DIAMOND_SEWING_NEEDLE.get())).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.NETHERITE_SEWING_NEEDLE.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.GOLD_SEWING_NEEDLE.get())).m_79707_(1))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.WOOL_ROLL.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.WOOL_TRIM.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.LEATHER_SHEET.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SewingKitMod.LEATHER_STRIP.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42401_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)16.0f))))));
            }
        }

        public static class BlockTables
        extends BlockLootSubProvider {
            protected BlockTables() {
                super(Set.of(), FeatureFlags.f_244280_.m_247355_());
            }

            protected void m_245660_() {
                this.m_245724_((Block)SewingKitMod.SEWING_STATION_BLOCK.get());
                this.m_245724_((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return ForgeRegistries.BLOCKS.getEntries().stream().filter(e -> ((ResourceKey)e.getKey()).m_135782_().m_135827_().equals("sewingkit")).map(Map.Entry::getValue).collect(Collectors.toList());
            }
        }
    }
}

