/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby.mixin;

import de.johni0702.minecraft.bobby.ext.ChunkLightProviderExt;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.LightEngine;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LightEngine.class}, targets={"ca.spottedleaf.starlight.common.light.StarLightInterface$1", "ca.spottedleaf.starlight.common.light.StarLightInterface$2"})
public abstract class ChunkLightProviderMixin
implements ChunkLightProviderExt {
    private final Long2ObjectMap<DataLayer> bobbySectionData = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final Long2ObjectMap<DataLayer> bobbyOriginalSectionData = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());

    @Override
    public void bobby_addSectionData(long pos, DataLayer data) {
        this.bobbySectionData.put(pos, (Object)data);
        this.bobbyOriginalSectionData.remove(pos);
    }

    @Override
    public void bobby_removeSectionData(long pos) {
        this.bobbySectionData.remove(pos);
        this.bobbyOriginalSectionData.remove(pos);
    }

    @Override
    public void bobby_setTainted(long pos, int delta) {
        if (delta != 0) {
            DataLayer original = (DataLayer)this.bobbyOriginalSectionData.get(pos);
            if (original == null) {
                original = (DataLayer)this.bobbySectionData.get(pos);
                if (original == null) {
                    return;
                }
                this.bobbyOriginalSectionData.put(pos, (Object)original);
            }
            DataLayer updated = new DataLayer();
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        updated.m_62564_(x, y, z, Math.min(Math.max(original.m_62560_(x, y, z) + delta, 0), 15));
                    }
                }
            }
            this.bobbySectionData.put(pos, (Object)updated);
        } else {
            DataLayer original = (DataLayer)this.bobbyOriginalSectionData.remove(pos);
            if (original == null) {
                return;
            }
            this.bobbySectionData.put(pos, (Object)original);
        }
    }

    @Inject(method={"getLightSection(Lnet/minecraft/util/math/ChunkSectionPos;)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, at={@At(value="HEAD")}, cancellable=true)
    private void bobby_getLightSection(SectionPos pos, CallbackInfoReturnable<DataLayer> ci) {
        DataLayer data = (DataLayer)this.bobbySectionData.get(pos.m_123252_());
        if (data != null) {
            ci.setReturnValue((Object)data);
        }
    }

    @Inject(method={"getLightLevel(Lnet/minecraft/util/math/BlockPos;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void bobby_getLightSection(BlockPos blockPos, CallbackInfoReturnable<Integer> ci) {
        DataLayer data = (DataLayer)this.bobbySectionData.get(SectionPos.m_123199_((BlockPos)blockPos).m_123252_());
        if (data != null) {
            ci.setReturnValue((Object)data.m_62560_(SectionPos.m_123207_((int)blockPos.m_123341_()), SectionPos.m_123207_((int)blockPos.m_123342_()), SectionPos.m_123207_((int)blockPos.m_123343_())));
        }
    }
}

