/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.item.AquaFishBucket;
import com.teammetallurgy.aquaculture.item.FishMountItem;
import com.teammetallurgy.aquaculture.misc.StackHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FishRegistry {
    public static List<RegistryObject<EntityType<AquaFishEntity>>> fishEntities = new ArrayList<RegistryObject<EntityType<AquaFishEntity>>>();
    public static List<RegistryObject<EntityType<FishMountEntity>>> fishMounts = new ArrayList<RegistryObject<EntityType<FishMountEntity>>>();

    public static RegistryObject<Item> registerFishMount(@Nonnull String name) {
        RegistryObject fishMount = AquaEntities.ENTITY_DEFERRED.register(name, () -> EntityType.Builder.m_20704_(FishMountEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory(FishMountEntity::new).m_20712_("aquaculture:" + name));
        RegistryObject<Item> fishMountItem = AquaItems.registerWithTab(() -> new FishMountItem((Supplier<EntityType<FishMountEntity>>)fishMount), name);
        fishMounts.add((RegistryObject<EntityType<FishMountEntity>>)fishMount);
        return fishMountItem;
    }

    public static RegistryObject<Item> register(@Nonnull Supplier<Item> initializer, @Nonnull String name) {
        return FishRegistry.register(initializer, name, FishType.MEDIUM);
    }

    public static RegistryObject<Item> register(@Nonnull Supplier<Item> initializer, @Nonnull String name, FishType fishType) {
        RegistryObject fish = AquaEntities.ENTITY_DEFERRED.register(name, () -> EntityType.Builder.m_20704_((f, w) -> new AquaFishEntity((EntityType<? extends AbstractSchoolingFish>)f, w, fishType), (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(fishType.getWidth(), fishType.getHeight()).m_20712_("aquaculture:" + name));
        fishEntities.add((RegistryObject<EntityType<AquaFishEntity>>)fish);
        RegistryObject bucket = AquaItems.ITEM_DEFERRED.register(name + "_bucket", () -> new AquaFishBucket((Supplier<? extends EntityType<?>>)fish, new Item.Properties().m_41487_(1)));
        AquaItems.ITEMS_FOR_TAB_LIST.add((RegistryObject<Item>)bucket);
        return AquaItems.registerWithTab(initializer, name);
    }

    @SubscribeEvent
    public static void addFishEntity0Attributes(EntityAttributeCreationEvent event) {
        for (RegistryObject<EntityType<AquaFishEntity>> entityType : fishEntities) {
            event.put((EntityType)entityType.get(), AbstractFish.m_27495_().m_22265_());
        }
    }

    public static void addCatBreeding() {
        try {
            Ingredient catBreedingItems = Cat.f_28103_;
            Ingredient ocelotBreedingItems = Ocelot.f_28981_;
            ArrayList<ItemStack> aquaFish = new ArrayList<ItemStack>();
            fishEntities.forEach(f -> aquaFish.add(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)f.get()))))));
            aquaFish.removeIf(p -> p.m_41720_().equals(AquaItems.JELLYFISH.get()));
            Cat.f_28103_ = StackHelper.mergeIngredient(catBreedingItems, StackHelper.ingredientFromStackList(aquaFish));
            Ocelot.f_28981_ = StackHelper.mergeIngredient(ocelotBreedingItems, StackHelper.ingredientFromStackList(aquaFish));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

