/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config.data.breeding_cap;

import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import space.arim.dazzleconf.annote.ConfDefault;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.annote.IntegerRange;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;

public interface BreedingCap {
    public static final Map<EntityType<?>, Set<EntityType<?>>> CUSTOM_TYPES = Map.of(EntityType.f_217012_, Set.of(EntityType.f_217013_, EntityType.f_217012_));

    @AnnotationBasedSorter.Order(value=1)
    @ConfKey(value="limit")
    @ConfDefault.DefaultInteger(value=32)
    public int limit();

    @AnnotationBasedSorter.Order(value=2)
    @ConfKey(value="range")
    @ConfDefault.DefaultInteger(value=64)
    @IntegerRange(min=1L)
    public int range();

    default public boolean exceedsLimit(EntityType<?> type, Level level, BlockPos pos) {
        int limit = this.limit();
        if (limit < 0) {
            return false;
        }
        AABB area = this.getAreaAt(pos);
        Set<EntityType<?>> set = CUSTOM_TYPES.get(type);
        int count = set != null && !set.isEmpty() ? level.m_6249_((Entity)null, area, entity -> set.contains(entity.m_6095_())).size() : level.m_142425_(type, area, EntitySelector.f_20408_).size();
        return limit <= count;
    }

    default public boolean exceedsLimit(Entity entity) {
        return this.exceedsLimit(entity.m_6095_(), entity.m_9236_(), entity.m_20183_());
    }

    private AABB getAreaAt(BlockPos pos) {
        int range = this.range();
        return new AABB(pos.m_7918_(range, range, range), pos.m_7918_(-range, -range, -range));
    }

    public static void resetLove(Animal owner, Animal mate) {
        BreedingCap.resetAge((AgeableMob)owner, (AgeableMob)mate);
        owner.m_27594_();
        mate.m_27594_();
    }

    public static void resetAge(AgeableMob owner, AgeableMob mate) {
        owner.m_146762_(6000);
        mate.m_146762_(6000);
    }
}

