/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.module;

import java.util.function.BooleanSupplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.module.ZetaModule;

public interface IDisableable<SELF> {
    @Nullable
    public ZetaModule getModule();

    public SELF setCondition(BooleanSupplier var1);

    public boolean doesConditionApply();

    default public boolean isEnabled() {
        ZetaModule module = this.getModule();
        return module != null && module.isEnabled() && this.doesConditionApply();
    }

    public static boolean isEnabled(Item i) {
        if (i instanceof IDisableable) {
            IDisableable dis = (IDisableable)i;
            return dis.isEnabled();
        }
        if (i instanceof BlockItem) {
            BlockItem bi = (BlockItem)i;
            return IDisableable.isEnabled(bi.m_40614_());
        }
        return true;
    }

    public static boolean isEnabled(Block b) {
        boolean bl;
        if (b instanceof IDisableable) {
            IDisableable dis = (IDisableable)b;
            bl = dis.isEnabled();
        } else {
            bl = true;
        }
        return bl;
    }
}

