/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.violetmoon.zeta.config.Definition;
import org.violetmoon.zeta.config.IZetaConfigInternals;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;

public class ChangeSet
implements IZetaConfigInternals {
    private final IZetaConfigInternals internals;
    private final Map<ValueDefinition<?>, Entry<?>> changes = new HashMap();

    public ChangeSet(IZetaConfigInternals internals) {
        this.internals = internals;
    }

    @Override
    public <T> void set(ValueDefinition<T> valueDef, T nextValue) {
        T currentValue = this.internals.get(valueDef);
        if (Objects.equals(currentValue, nextValue)) {
            this.removeChange(valueDef);
        } else {
            this.changes.put(valueDef, new Entry<T>(valueDef, currentValue, nextValue));
        }
    }

    public void toggle(ValueDefinition<Boolean> boolDef) {
        this.set(boolDef, this.get(boolDef) == false);
    }

    public <T> void resetToDefault(ValueDefinition<T> valueDef) {
        this.set(valueDef, valueDef.defaultValue);
    }

    public <T> void removeChange(ValueDefinition<T> valueDef) {
        this.changes.remove(valueDef);
    }

    public void resetToDefault(SectionDefinition sectionDef) {
        sectionDef.getValues().forEach(this::resetToDefault);
        sectionDef.getSubsections().forEach(this::resetToDefault);
    }

    public void removeChange(SectionDefinition sectionDef) {
        sectionDef.getValues().forEach(this::removeChange);
        sectionDef.getSubsections().forEach(this::removeChange);
    }

    public <T> boolean isDirty(ValueDefinition<T> valueDef) {
        return this.changes.containsKey(valueDef);
    }

    public boolean isDirty(SectionDefinition sectionDefinition) {
        return sectionDefinition.getValues().stream().anyMatch(this::isDirty) || sectionDefinition.getSubsections().stream().anyMatch(this::isDirty);
    }

    public int changeCount() {
        return this.changes.size();
    }

    public void removeChange(Definition def) {
        if (def instanceof ValueDefinition) {
            ValueDefinition val = (ValueDefinition)def;
            this.removeChange(val);
        } else {
            this.removeChange((SectionDefinition)def);
        }
    }

    public void resetToDefault(Definition def) {
        if (def instanceof ValueDefinition) {
            ValueDefinition val = (ValueDefinition)def;
            this.resetToDefault(val);
        } else {
            this.resetToDefault((SectionDefinition)def);
        }
    }

    public boolean isDirty(Definition def) {
        if (def instanceof ValueDefinition) {
            ValueDefinition val = (ValueDefinition)def;
            return this.isDirty(val);
        }
        return this.isDirty((SectionDefinition)def);
    }

    public <T> List<T> getExactSizeCopy(ValueDefinition<List<T>> def, int size, T filler) {
        List<T> value = this.get(def);
        if (value.size() > size) {
            return new ArrayList<T>(value.subList(0, size));
        }
        value = new ArrayList<T>(value);
        while (value.size() < size) {
            value.add(filler);
        }
        return value;
    }

    @Override
    public <T> T get(ValueDefinition<T> definition) {
        Entry<?> entry = this.changes.get(definition);
        if (entry != null) {
            return entry.nextValue;
        }
        return this.internals.get(definition);
    }

    public void applyAllChanges() {
        this.changes.values().forEach(this::applyOneChange);
        this.changes.clear();
        this.flush();
    }

    private <T> void applyOneChange(Entry<T> entry) {
        this.internals.set(entry.valueDef, entry.nextValue);
    }

    @Override
    public void flush() {
        this.internals.flush();
    }

    private record Entry<T>(ValueDefinition<T> valueDef, T currentValue, T nextValue) {
    }
}

