/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.screen.SectionScreen;
import org.violetmoon.zeta.client.config.screen.ZetaScreen;
import org.violetmoon.zeta.client.config.widget.CategoryButton;
import org.violetmoon.zeta.client.config.widget.CheckboxButton;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;
import org.violetmoon.zeta.module.ZetaCategory;

public class ZetaConfigHomeScreen
extends ZetaScreen {
    protected final ChangeSet changeSet;
    protected Button saveButton;

    public ZetaConfigHomeScreen(ZetaClient zc, Screen parent) {
        super(zc, parent);
        this.changeSet = new ChangeSet(this.z.configInternals);
    }

    protected void m_7856_() {
        int i;
        super.m_7856_();
        List<ZetaCategory> categories = this.z.modules.getInhabitedCategories();
        @Nullable SectionDefinition generalSection = this.z.configManager.getGeneralSection();
        int buttonCount = categories.size();
        if (generalSection != null) {
            ++buttonCount;
        }
        int perLine = 3;
        ArrayList<Integer> categoryButtonXPositions = new ArrayList<Integer>(buttonCount);
        for (i = 0; i < buttonCount; i += 3) {
            categoryButtonXPositions.addAll(this.centeredRow(this.f_96543_ / 2, 120, 10, Math.min(buttonCount - i, 3)));
        }
        for (i = 0; i < buttonCount; ++i) {
            int row = i / 3;
            int x = (Integer)categoryButtonXPositions.get(i);
            int y = 70 + row * 23;
            int bWidth = 120;
            if (i < categories.size()) {
                boolean active;
                ZetaCategory category = categories.get(i);
                ValueDefinition<Boolean> categoryEnabled = this.z.configManager.getCategoryEnabledOption(category);
                SectionDefinition categorySection = this.z.configManager.getCategorySection(category);
                Button mainButton = (Button)this.m_142416_((GuiEventListener)new CategoryButton(x, y, bWidth -= 20, 20, this.componentFor(categorySection), category.icon.get(), b -> Minecraft.m_91087_().m_91152_((Screen)new SectionScreen(this.zc, this, this.changeSet, categorySection))));
                Button checkButton = (Button)this.m_142416_((GuiEventListener)new CheckboxButton(this.zc, x + bWidth, y, this.changeSet, categoryEnabled));
                mainButton.f_93623_ = active = category.requiredModsLoaded();
                checkButton.f_93623_ = active;
                continue;
            }
            assert (generalSection != null);
            this.m_142416_((GuiEventListener)new Button.Builder(this.componentFor(generalSection), b -> Minecraft.m_91087_().m_91152_((Screen)new SectionScreen(this.zc, this, this.changeSet, generalSection))).m_253046_(bWidth, 20).m_252794_(x, y).m_253136_());
        }
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder(this.componentForSaveButton(), this::commit).m_253046_(200, 20).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ - 30).m_253136_());
    }

    public List<Integer> centeredRow(int centerX, int buttonWidth, int hpad, int count) {
        int slop = (count % 2 == 0 ? hpad : buttonWidth) / 2;
        int fullButtonsLeftOfCenter = count / 2;
        int fullPaddingsLeftOfCenter = Math.max(0, (count - 1) / 2);
        int startX = centerX - slop - fullButtonsLeftOfCenter * buttonWidth - fullPaddingsLeftOfCenter * hpad;
        ArrayList<Integer> result = new ArrayList<Integer>(count);
        int x = startX;
        for (int i = 0; i < count; ++i) {
            result.add(x);
            x += buttonWidth + hpad;
        }
        return result;
    }

    private Component componentFor(SectionDefinition section) {
        MutableComponent comp = Component.m_237115_((String)(this.z.modid + ".category." + section.name));
        if (this.changeSet.isDirty(section)) {
            comp.m_7220_((Component)Component.m_237113_((String)"*").m_130940_(ChatFormatting.GOLD));
        }
        return comp;
    }

    private Component componentForSaveButton() {
        MutableComponent comp = Component.m_237115_((String)"quark.gui.config.save");
        int changeCount = this.changeSet.changeCount();
        if (changeCount > 0) {
            comp.m_130946_(" (").m_7220_((Component)Component.m_237113_((String)String.valueOf(changeCount)).m_130940_(ChatFormatting.GOLD)).m_130946_(")");
        }
        return comp;
    }

    public void commit(Button button) {
        this.changeSet.applyAllChanges();
        this.m_7379_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280137_(this.f_96547_, String.valueOf(ChatFormatting.BOLD) + I18n.m_118938_((String)"quark.gui.config.header", (Object[])new Object[]{WordUtils.capitalizeFully((String)this.z.modid)}), this.f_96543_ / 2, 15, 4775356);
    }

    public void m_86600_() {
        super.m_86600_();
        this.saveButton.m_93666_(this.componentForSaveButton());
    }
}

