/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement.modifier;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.violetmoon.zeta.advancement.AdvancementModifier;
import org.violetmoon.zeta.api.IMutableAdvancement;
import org.violetmoon.zeta.module.ZetaModule;

public class MonsterHunterModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET_ONE = new ResourceLocation("adventure/kill_a_mob");
    private static final ResourceLocation TARGET_ALL = new ResourceLocation("adventure/kill_all_mobs");
    final Set<EntityType<?>> entityTypes;

    public MonsterHunterModifier(ZetaModule module, Set<EntityType<?>> entityTypes) {
        super(module);
        this.entityTypes = entityTypes;
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET_ONE, (Object)TARGET_ALL);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv) {
        boolean all = res.equals((Object)TARGET_ALL);
        for (EntityType<?> type : this.entityTypes) {
            Criterion criterion = new Criterion((CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_(type))));
            String name = BuiltInRegistries.f_256780_.m_7981_(type).toString();
            if (all) {
                adv.addRequiredCriterion(name, criterion);
                continue;
            }
            adv.addOrCriterion(name, criterion);
        }
        return true;
    }
}

