/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings.entity;

import com.cicada.longwings.LongwingsSounds;
import com.cicada.longwings.api.LongwingsHandler;
import com.cicada.longwings.block.JarPlaced;
import com.cicada.longwings.block.LongwingsBlocks;
import com.cicada.longwings.entity.ButterflyFlightNavigation;
import com.cicada.longwings.entity.ButterflyVariant;
import com.cicada.longwings.entity.EnumButterflyTraits;
import com.cicada.longwings.entity.LongwingsEntityTypes;
import com.cicada.longwings.entity.ai.ButterflyFeedGoal;
import com.cicada.longwings.entity.ai.ButterflyFlyToPOIGoal;
import com.cicada.longwings.entity.ai.ButterflyScareGoal;
import com.cicada.longwings.entity.ai.ButterflyTemptGoal;
import com.cicada.longwings.entity.ai.ButterflyWanderGoal;
import com.cicada.longwings.entity.ai.MothFlyToLightGoal;
import com.cicada.longwings.item.LongwingsItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ButterflyEntity
extends Animal
implements FlyingAnimal {
    public int floatCount;
    public float prevDeltaX;
    public float prevDeltaZ;
    public ButterflyVariant variant;
    private static final EntityDataAccessor<String> DATA_VARIANT_ID = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> NOURISHED = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ONWALL = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INPLANT = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SEED = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private final RandomSource randomSource = new LegacyRandomSource(RandomSupport.m_224599_());
    TagKey<Block> pollinationResistantCropsLevel1 = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("longwings", "pollination_resistant_crops_level_1"));
    TagKey<Block> pollinationResistantCropsLevel2 = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("longwings", "pollination_resistant_crops_level_2"));
    TagKey<Block> pollinationResistantCropsLevel3 = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("longwings", "pollination_resistant_crops_level_3"));
    TagKey<Block> pollinationBannedCrops = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("longwings", "pollination_banned_crops"));

    public ButterflyEntity(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.BLOCKED, 0.0f);
    }

    public static AttributeSupplier createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22280_, 0.5).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0).m_22265_();
    }

    public void m_7350_(EntityDataAccessor<?> p_146754_) {
        super.m_7350_(p_146754_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)"monarch");
        this.f_19804_.m_135372_(NOURISHED, (Object)false);
        this.f_19804_.m_135372_(ONWALL, (Object)false);
        this.f_19804_.m_135372_(INPLANT, (Object)false);
        this.f_19804_.m_135372_(SEED, (Object)1);
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(HOME_POS, (Object)new BlockPos(0, 0, 0));
    }

    public void m_7380_(CompoundTag p_27587_) {
        super.m_7380_(p_27587_);
        p_27587_.m_128359_("Variant", this.getVariant());
        p_27587_.m_128379_("Nourished", this.isNourished());
        p_27587_.m_128379_("isOnWall", this.isOnWall());
        p_27587_.m_128379_("isInPlant", this.isInPlant());
        p_27587_.m_128405_("seed", this.getSeed().intValue());
        p_27587_.m_128350_("size", this.getSize().floatValue());
        p_27587_.m_128405_("HomePosX", this.getHomePos().m_123341_());
        p_27587_.m_128405_("HomePosY", this.getHomePos().m_123342_());
        p_27587_.m_128405_("HomePosZ", this.getHomePos().m_123343_());
    }

    public void m_7378_(CompoundTag p_27576_) {
        super.m_7378_(p_27576_);
        this.f_19804_.m_135381_(NOURISHED, (Object)p_27576_.m_128471_("Nourished"));
        this.f_19804_.m_135381_(ONWALL, (Object)p_27576_.m_128471_("isOnWall"));
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(p_27576_.m_128457_("size")));
        int i = p_27576_.m_128451_("HomePosX");
        int j = p_27576_.m_128451_("HomePosY");
        int k = p_27576_.m_128451_("HomePosZ");
        this.f_19804_.m_135381_(HOME_POS, (Object)new BlockPos(i, j, k));
        if (p_27576_ != null && p_27576_.m_128461_("variant") != null) {
            this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)p_27576_.m_128461_("Variant"));
        }
    }

    public Float getSize() {
        return (Float)this.f_19804_.m_135370_(SIZE);
    }

    public void setSize(float seed) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(seed));
    }

    public Integer getSeed() {
        return (Integer)this.f_19804_.m_135370_(SEED);
    }

    public void setSeed(int seed) {
        this.f_19804_.m_135381_(SEED, (Object)seed);
    }

    public BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    public void setHomePos(BlockPos p_30220_) {
        this.f_19804_.m_135381_(HOME_POS, (Object)p_30220_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance p_146747_, MobSpawnType p_146748_, SpawnGroupData groupData, CompoundTag p_146750_) {
        return this.setButterflyVariantOnBiome(serverLevelAccessor, p_146747_, p_146748_, groupData, p_146750_);
    }

    public int randomHighBiasedCount(int groupMaxCount, float startProbability, float scale) {
        RandomSource randomsource = this.randomSource;
        int amount = 0;
        for (int a = 0; a < groupMaxCount && randomsource.m_188501_() >= startProbability / (1.0f + (float)a * scale); ++a) {
            ++amount;
        }
        return amount;
    }

    public int randomLowBiasedCount(int groupMaxCount, float startProbability, float scale) {
        RandomSource randomsource = this.randomSource;
        int amount = 0;
        for (int a = 0; a < groupMaxCount && randomsource.m_188501_() <= startProbability / (1.0f + (float)a * scale); ++a) {
            ++amount;
        }
        return amount;
    }

    public SpawnGroupData setButterflyVariantOnBiome(ServerLevelAccessor serverLevelAccessor, DifficultyInstance p_146747_, MobSpawnType p_146748_, SpawnGroupData groupData, CompoundTag p_146750_) {
        boolean flag;
        ButterflyVariant[] variantPool = this instanceof MothEntity ? ButterflyVariant.getMothVariantPool() : ButterflyVariant.getButterflyVariantPool();
        Biome biome = (Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_();
        float biomeTemp = LongwingsHandler.getBiomeTemperature(biome);
        float biomeHumid = LongwingsHandler.getBiomeHumidity(biome);
        ButterflyVariant variant = ButterflyVariant.PAINTED_LADY;
        ArrayList<String> weightedListMaybe = new ArrayList<String>();
        RandomSource randomsource = this.randomSource;
        boolean cannotSpawnNaturally = false;
        ButterflyEntity entity = this;
        for (int a = 0; a < variantPool.length; ++a) {
            boolean hasValidHabitatConditions;
            ButterflyVariant selectedVariant = variantPool[a];
            boolean bl = hasValidHabitatConditions = biomeTemp >= selectedVariant.minTemp() && biomeTemp <= selectedVariant.maxTemp() && biomeHumid >= selectedVariant.minHumidity() && biomeHumid <= selectedVariant.maxHumidity();
            if (!hasValidHabitatConditions) continue;
            for (int b = 0; b < selectedVariant.getButterflySpawnRarity(); ++b) {
                weightedListMaybe.add(selectedVariant.getButterflyStringId());
            }
        }
        if (weightedListMaybe.isEmpty()) {
            weightedListMaybe.add(this instanceof MothEntity ? ButterflyVariant.SMALL_WHITE_WAVE.getButterflyStringId() : ButterflyVariant.PAINTED_LADY.getButterflyStringId());
            cannotSpawnNaturally = true;
        }
        String randomButterflyVariantString = (String)weightedListMaybe.get(randomsource.m_188503_(weightedListMaybe.size()));
        for (int a = 0; a < variantPool.length; ++a) {
            if (!randomButterflyVariantString.matches(variantPool[a].getButterflyStringId())) continue;
            variant = variantPool[a];
        }
        this.applyLepidopteraTraits(variant, this);
        boolean bl = flag = p_146748_ == MobSpawnType.CHUNK_GENERATION || p_146748_ == MobSpawnType.NATURAL;
        if (flag) {
            int extraButterflies = this.randomLowBiasedCount(6, 0.85f, 0.75f);
            if (biomeHumid <= 0.0f) {
                extraButterflies = this.randomLowBiasedCount(3, 0.25f, 0.9f);
            }
            boolean isMoth = this instanceof MothEntity;
            boolean canGenerateNewVariantsInGroup = false;
            if (cannotSpawnNaturally) {
                return null;
            }
            if (!isMoth && extraButterflies > 0) {
                for (int i = 0; i < extraButterflies; ++i) {
                    if (!this.m_9236_().m_46749_(entity.m_20183_())) continue;
                    ButterflyEntity newEntity = (ButterflyEntity)LongwingsEntityTypes.BUTTERFLY.m_20615_(this.m_9236_());
                    if (randomsource.m_188501_() <= (float)(i + 1) * 0.25f / (float)extraButterflies) {
                        canGenerateNewVariantsInGroup = true;
                    }
                    if (canGenerateNewVariantsInGroup) {
                        randomButterflyVariantString = (String)weightedListMaybe.get(randomsource.m_188503_(weightedListMaybe.size()));
                        for (ButterflyVariant butterflyVariant : variantPool) {
                            if (!randomButterflyVariantString.matches(butterflyVariant.getButterflyStringId())) continue;
                            variant = butterflyVariant;
                        }
                    }
                    BlockPos scatterPos = new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_(), this.m_20183_().m_123343_());
                    newEntity.m_7678_(this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), entity.m_146908_(), entity.m_146909_());
                    this.applyLepidopteraTraits(variant, newEntity);
                    this.m_9236_().m_7654_().execute(() -> this.m_9236_().m_7967_((Entity)newEntity));
                }
            }
        }
        return super.m_6518_(serverLevelAccessor, p_146747_, p_146748_, groupData, p_146750_);
    }

    public void applyLepidopteraTraits(ButterflyVariant variant, ButterflyEntity target) {
        RandomSource randomsource = this.randomSource;
        float butterflySize = Math.min(1.0f, Math.max(0.7f, 0.7f + randomsource.m_188501_() * 3.0f / 9.0f));
        if (variant.getButterflySize() == EnumButterflyTraits.ButterflySizes.NORMAL) {
            butterflySize = Math.min(1.15f, Math.max(0.85f, 0.85f + randomsource.m_188501_() / 5.0f));
        }
        if (variant.getButterflySize() == EnumButterflyTraits.ButterflySizes.LARGER) {
            butterflySize = Math.min(1.15f, Math.max(0.85f, 0.85f + randomsource.m_188501_() / 3.0f));
        }
        target.setVariant(variant.getButterflyStringId());
        target.setSize((float)((double)Math.round(butterflySize * 100.0f) / 100.0));
        target.setSeed((byte)randomsource.m_188503_(100));
    }

    public boolean m_20096_() {
        return super.m_20096_();
    }

    public void m_6853_(boolean p_21182_) {
        super.m_6853_(p_21182_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new ButterflyScareGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ButterflyTemptGoal(this, Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("longwings:butterfly_tempt_items")))));
        this.f_21345_.m_25352_(4, (Goal)new ButterflyFeedGoal(this, 7, LongwingsBlocks.SUGAR_WATER_BOWL));
        this.f_21345_.m_25352_(5, (Goal)new ButterflyFlyToPOIGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new ButterflyWanderGoal(this));
    }

    protected PathNavigation m_6037_(Level p_21480_) {
        ButterflyFlightNavigation flyingpathnavigation = new ButterflyFlightNavigation((Mob)this, p_21480_);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public boolean m_6783_(double p_19883_) {
        return super.m_6783_(5.0);
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        if (this.isInsideJar()) {
            Level level = this.m_9236_();
            BlockState state = level.m_8055_(this.m_20183_());
            boolean flag = (Boolean)state.m_61143_((Property)JarPlaced.EmptyJarPlaced.OPEN);
            double clampedX = Mth.m_14008_((double)(this.m_20185_() + pos.f_82479_), (double)((double)this.m_20183_().m_123341_() + 0.35), (double)((double)(this.m_20183_().m_123341_() + 1) - 0.35));
            double clampedY = flag ? Math.max(this.m_20186_() + pos.f_82480_, (double)this.m_20183_().m_123342_() + 0.15) : Mth.m_14008_((double)(this.m_20186_() + pos.f_82480_), (double)((double)this.m_20183_().m_123342_() + 0.15), (double)((float)(this.m_20183_().m_123342_() + 1) - 0.5f));
            double clampedZ = Mth.m_14008_((double)(this.m_20189_() + pos.f_82481_), (double)((double)this.m_20183_().m_123343_() + 0.35), (double)((double)(this.m_20183_().m_123343_() + 1) - 0.35));
            this.m_6034_(clampedX, clampedY, clampedZ);
        } else {
            super.m_6478_(type, pos);
        }
    }

    public boolean isInsideJar() {
        Level level = this.m_9236_();
        BlockState state = level.m_8055_(this.m_20183_());
        if (state.m_60713_((Block)LongwingsBlocks.GLASS_JAR)) {
            VoxelShape collisionShape = this.m_9236_().m_8055_(this.m_20183_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_());
            VoxelShape testShape = Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
            if (!testShape.m_83281_()) {
                return this.m_20191_().m_82386_(0.0, 0.0, 0.0).m_82381_(testShape.m_83215_().m_82338_(this.m_20183_()));
            }
        } else {
            return false;
        }
        return false;
    }

    protected void m_6138_() {
        if (!this.isInsideJar()) {
            super.m_6138_();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            if (!(this.m_20096_() || this.isOnWall() || this.isInPlant())) {
                ++this.floatCount;
                if (this.floatCount % (5 + this.randomSource.m_188503_(3)) == 0 && !this.isInsideJar()) {
                    this.m_9236_().m_7785_(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, LongwingsSounds.BUTTERFLY_FLAP, SoundSource.NEUTRAL, 0.0075f - this.randomSource.m_188501_() * 5.0E-4f, 0.75f + this.randomSource.m_188501_(), false);
                }
            } else if (this.floatCount > 0) {
                this.floatCount = 0;
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isInsideJar() && (double)this.m_9236_().m_213780_().m_188501_() < 0.01) {
            this.m_21573_().m_26519_(this.m_20185_() + (double)(-2 + this.m_9236_().m_213780_().m_188503_(4)), this.m_20186_() + (double)this.m_9236_().m_213780_().m_188503_(3), this.m_20189_() + (double)(-2 + this.m_9236_().m_213780_().m_188503_(4)), 0.5);
        }
        VoxelShape translucentShape = this.m_9236_().m_8055_(this.m_20183_()).m_60808_((BlockGetter)this.m_9236_(), this.m_20183_());
        if (!this.m_9236_().f_46443_) {
            if (this.m_21573_().m_26571_() && !this.isOnWall() && !this.m_20069_()) {
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - (double)0.0045f, this.m_20184_().f_82481_);
            }
            if (this.m_20069_()) {
                this.m_20334_(this.m_20184_().f_82479_, 0.045, this.m_20184_().f_82481_);
                if (this.m_21573_().m_26571_() && this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_60795_()) {
                    this.m_21573_().m_26519_((double)(-15 + this.m_20183_().m_123341_() + this.randomSource.m_188503_(15) * 2), (double)(this.m_20183_().m_123342_() + this.randomSource.m_188503_(5)), (double)(-15 + this.m_20183_().m_123343_() + this.randomSource.m_188503_(15) * 2), (double)(0.35f + this.randomSource.m_188501_()));
                }
            }
        }
        this.prevDeltaX = (float)this.m_20184_().f_82479_;
        this.prevDeltaZ = (float)this.m_20184_().f_82481_;
        boolean NS = this.m_6350_() == Direction.NORTH || this.m_6350_() == Direction.SOUTH;
        float facingModifier = this.m_6350_() == Direction.SOUTH || this.m_6350_() == Direction.EAST ? 0.105f : -0.105f;
        Vec3 posFront = this.m_146892_().m_82520_(NS ? 0.0 : (double)facingModifier, (double)-0.105f, NS ? (double)facingModifier : 0.0);
        BlockPos.MutableBlockPos blockPosFront = new BlockPos.MutableBlockPos(posFront.f_82479_, posFront.f_82480_, posFront.f_82481_);
        VoxelShape forwardShape = this.m_9236_().m_8055_(BlockPos.m_274446_((Position)posFront)).m_60812_((BlockGetter)this.m_9236_(), BlockPos.m_274446_((Position)posFront));
        if (!this.m_9236_().m_5776_()) {
            if (this.isInPlant()) {
                if (!this.m_21573_().m_26571_() || translucentShape.m_83281_()) {
                    this.setInPlant(false);
                }
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ * 0.0, this.m_20184_().f_82481_);
            }
            if (this.isOnWall() && (forwardShape.m_83281_() || !forwardShape.m_83281_() && !forwardShape.m_83215_().m_82338_((BlockPos)blockPosFront).m_82381_(new AABB(posFront.f_82479_, posFront.f_82480_, posFront.f_82481_, posFront.f_82479_, posFront.f_82480_, posFront.f_82481_)))) {
                this.setOnWall(false);
            }
            if (!this.isInsideJar()) {
                BlockState state = this.m_9236_().m_8055_(this.m_20183_());
                if (!state.m_60713_(Blocks.f_220864_) && !state.m_60713_((Block)LongwingsBlocks.GLASS_JAR) && !this.isInPlant() && this.m_21573_().m_26571_() && !translucentShape.m_83281_() && this.m_20191_().m_82386_(0.0, 0.0, 0.0).m_82381_(translucentShape.m_83215_().m_82338_(this.m_20183_()))) {
                    this.setInPlant(true);
                    this.m_21573_().m_26573_();
                }
                float f = this.f_146794_ = this.m_20096_() || this.isOnWall() ? 0.0f : this.f_146794_;
                if ((this.f_19797_ < 10 || this.f_146794_ > 1.0f && (double)this.randomSource.m_188501_() < 0.025) && !this.isOnWall() && !forwardShape.m_83281_() && forwardShape.m_83215_().m_82338_((BlockPos)blockPosFront).m_82381_(new AABB(posFront.f_82479_, posFront.f_82480_, posFront.f_82481_, posFront.f_82479_, posFront.f_82480_, posFront.f_82481_))) {
                    this.setOnWall(true);
                    this.m_21573_().m_26573_();
                }
            }
        }
        if (this.randomSource.m_188501_() < 1.0E-5f && this.isNourished()) {
            this.setNourishment(false);
        }
        if (this.isOnWall() && !this.m_21573_().m_26572_()) {
            this.m_146922_(this.m_6350_().m_122435_());
            this.m_5618_(this.m_6350_().m_122435_());
            this.m_5616_(this.m_6350_().m_122435_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(-90.0f);
            this.f_19860_ = this.m_146909_();
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (!this.m_20096_() && this.randomSource.m_188503_(150) == 0) {
            for (int cropNum = 0; cropNum < 8; ++cropNum) {
                BlockState cropState = this.m_9236_().m_8055_(new BlockPos(this.m_146903_(), this.m_146904_() - cropNum, this.m_146907_()));
                if (!(cropState.m_60734_() instanceof CropBlock) || cropState.m_204336_(this.pollinationBannedCrops)) continue;
                float pollinationChance = 1.0f;
                if (cropState.m_204336_(this.pollinationResistantCropsLevel1)) {
                    pollinationChance = 0.25f;
                }
                if (cropState.m_204336_(this.pollinationResistantCropsLevel2)) {
                    pollinationChance = 0.1f;
                }
                if (cropState.m_204336_(this.pollinationResistantCropsLevel3)) {
                    pollinationChance = 0.01f;
                }
                if (!(this.randomSource.m_188501_() <= pollinationChance)) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123782_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 0.0, 0.0, 0.0);
                if (((CropBlock)cropState.m_60734_()).m_52305_(cropState) >= ((CropBlock)cropState.m_60734_()).m_7419_()) continue;
                this.m_9236_().m_6263_((Player)null, this.m_20182_().f_82479_, this.m_20182_().f_82480_ - (double)cropNum, this.m_20182_().f_82481_, SoundEvents.f_11839_, SoundSource.NEUTRAL, 0.15f, (float)Math.random() + 1.0f);
                if (!this.m_9236_().m_5776_()) {
                    this.m_9236_().m_46597_(new BlockPos(this.m_146903_(), this.m_146904_() - cropNum, this.m_146907_()), ((CropBlock)cropState.m_60734_()).m_52289_(((CropBlock)cropState.m_60734_()).m_52305_(cropState) + 1));
                }
                for (int a = 0; a < 5; ++a) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)this.m_20183_().m_123341_() + Math.random(), (double)(this.m_20183_().m_123342_() - cropNum), (double)this.m_20183_().m_123343_() + Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public InteractionResult m_6071_(Player p_27584_, InteractionHand p_27585_) {
        ItemStack item = new ItemStack((ItemLike)(this instanceof MothEntity ? LongwingsItems.MOTH_ITEM : LongwingsItems.BUTTERFLY_ITEM));
        boolean moth = this instanceof MothEntity;
        String typeString = moth ? "moths" : "butterflies";
        boolean flag = false;
        for (int i = 0; i < p_27584_.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = p_27584_.m_150109_().m_8020_(i);
            if (!itemstack.m_150930_((Item)LongwingsItems.LEPIDOPTERAPEDIA)) continue;
            if (itemstack.m_41784_().m_128441_(typeString)) {
                String lepidopteraTagListAsString = itemstack.m_41784_().m_128423_(typeString).m_7916_();
                ArrayList<String> lepidopteriaList = new ArrayList<String>(Arrays.asList(lepidopteraTagListAsString.split(", ")));
                if (!lepidopteriaList.stream().noneMatch(s -> s.matches(this.getVariant()))) continue;
                flag = true;
                lepidopteriaList.add(this.getVariant());
                itemstack.m_41784_().m_128359_(typeString, String.join((CharSequence)", ", lepidopteriaList));
                continue;
            }
            flag = true;
            itemstack.m_41784_().m_128359_(typeString, this.getVariant());
        }
        if (this.m_9236_().f_46443_) {
            LongwingsHandler.getHandbookHandler().tryPlayToast(flag, this instanceof MothEntity, this.getVariant());
        }
        super.m_6071_(p_27584_, p_27585_);
        if (p_27584_.m_21120_(p_27585_).m_204117_(ItemTags.f_13149_)) {
            double rand = Math.random() * 0.25 - Math.random() * 0.25;
            double randa = Math.random() * 0.25 - Math.random() * 0.25;
            double randb = Math.random() * 0.25 - Math.random() * 0.25;
            p_27584_.m_21120_(p_27585_).m_41764_(p_27584_.m_21120_(p_27585_).m_41613_() - 1);
            this.m_216990_(SoundEvents.f_11970_);
            for (int w = 0; w < 10; ++w) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20182_().f_82479_ + rand, this.m_20182_().f_82480_ + randa, this.m_20182_().f_82481_ + randb, 0.25, 7.0, 0.25);
            }
            return InteractionResult.SUCCESS;
        }
        if (p_27584_.m_21120_(p_27585_).m_150930_((Item)LongwingsItems.CATCHING_NET_ITEM)) {
            if (this.m_7770_() != null) {
                item.m_41784_().m_128359_("name", this.m_7770_().getString());
            }
            item.m_41784_().m_128359_("variant", this.getVariant().toLowerCase(Locale.ROOT));
            item.m_41784_().m_128350_("size", this.getSize() != null ? this.getSize().floatValue() : 1.0f);
            if (p_27584_.m_36356_(item)) {
                p_27584_.m_21120_(p_27585_).m_41622_(1, (LivingEntity)p_27584_, e -> e.m_21190_(p_27585_));
                p_27584_.m_36356_(item);
                p_27584_.m_5496_(LongwingsSounds.CATCHING_NET_CATCH, 0.5f, 1.0f);
                this.m_146870_();
            } else {
                p_27584_.m_5496_(LongwingsSounds.CATCHING_NET_FULL, 0.5f, 2.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_21691_() {
        return this.m_21691_();
    }

    public float m_21439_(BlockPathTypes p_21440_) {
        return super.m_21439_(p_21440_);
    }

    public boolean m_142535_(float p_148702_, float p_148703_, DamageSource p_148704_) {
        return false;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    protected void m_6677_(DamageSource p_21493_) {
        super.m_6677_(p_21493_);
    }

    public boolean m_20039_(BlockPos p_20040_, BlockState p_20041_) {
        return super.m_20039_(p_20040_, p_20041_);
    }

    public void m_21441_(BlockPathTypes p_21442_, float p_21443_) {
        super.m_21441_(p_21442_, p_21443_);
    }

    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public boolean m_6149_() {
        return false;
    }

    public boolean m_29443_() {
        return false;
    }

    public static boolean checkButterflySpawnRules(EntityType<ButterflyEntity> p_219113_, LevelAccessor p_219114_, MobSpawnType p_219115_, BlockPos p_219116_, RandomSource p_219117_) {
        boolean flag3;
        boolean flag = ((Biome)p_219114_.m_204166_(p_219116_).m_203334_()).m_47554_() <= 0.0f;
        boolean flag1 = p_219114_.m_8055_(p_219116_.m_7495_()).m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("longwings", "longwings_spawnable_on")));
        boolean flag2 = p_219114_.m_204166_(p_219116_).m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("longwings", "longwings_biome_banlist")));
        Biome biome = (Biome)p_219114_.m_204166_(p_219116_).m_203334_();
        float biomeHumid = LongwingsHandler.getBiomeHumidity(biome);
        boolean bl = flag3 = biomeHumid <= 0.0f;
        if (flag3 && Math.random() >= 0.1) {
            return false;
        }
        return !flag && flag1 && !flag2;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        return super.m_5545_(level, spawnReason);
    }

    public boolean m_142391_() {
        return super.m_142391_();
    }

    public String getVariant() {
        return (String)this.f_19804_.m_135370_(DATA_VARIANT_ID);
    }

    public void setVariant(String string) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)string);
    }

    public boolean isNourished() {
        return (Boolean)this.f_19804_.m_135370_(NOURISHED);
    }

    public void setNourishment(boolean nourished) {
        this.f_19804_.m_135381_(NOURISHED, (Object)nourished);
    }

    public boolean isOnWall() {
        return (Boolean)this.f_19804_.m_135370_(ONWALL);
    }

    public void setOnWall(boolean onWall) {
        this.f_19804_.m_135381_(ONWALL, (Object)onWall);
    }

    public boolean isInPlant() {
        return (Boolean)this.f_19804_.m_135370_(INPLANT);
    }

    public void setInPlant(boolean inPlant) {
        this.f_19804_.m_135381_(INPLANT, (Object)inPlant);
    }

    public static class MothEntity
    extends ButterflyEntity {
        public MothEntity(EntityType<? extends Animal> p_27557_, Level p_27558_) {
            super(p_27557_, p_27558_);
            this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
            this.m_21441_(BlockPathTypes.BLOCKED, 0.0f);
        }

        public static boolean checkMothSpawnRules(EntityType<MothEntity> p_219113_, LevelAccessor p_219114_, MobSpawnType p_219115_, BlockPos p_219116_, RandomSource p_219117_) {
            boolean flag3;
            boolean flag = ((Biome)p_219114_.m_204166_(p_219116_).m_203334_()).m_47554_() <= 0.0f;
            boolean flag1 = p_219114_.m_8055_(p_219116_.m_7495_()).m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("longwings", "longwings_spawnable_on")));
            boolean flag2 = p_219114_.m_204166_(p_219116_).m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("longwings", "longwings_biome_banlist")));
            Biome biome = (Biome)p_219114_.m_204166_(p_219116_).m_203334_();
            float biomeHumid = LongwingsHandler.getBiomeHumidity(biome);
            boolean bl = flag3 = biomeHumid <= 0.0f;
            if (flag3 && Math.random() >= 0.5) {
                return false;
            }
            return !flag && flag1 && !flag2;
        }

        @Override
        public boolean m_5545_(LevelAccessor p_21686_, MobSpawnType p_21687_) {
            return super.m_5545_(p_21686_, p_21687_);
        }

        @Override
        protected void m_8099_() {
            super.m_8099_();
            this.f_21345_.m_25352_(1, (Goal)new MothFlyToLightGoal(this));
            this.f_21345_.m_25352_(2, (Goal)new ButterflyScareGoal(this));
            this.f_21345_.m_25352_(3, (Goal)new ButterflyTemptGoal(this, Ingredient.m_204132_((TagKey)ItemTags.f_13149_)));
            this.f_21345_.m_25352_(4, (Goal)new ButterflyFeedGoal(this, 7, LongwingsBlocks.SUGAR_WATER_BOWL));
            this.f_21345_.m_25352_(5, (Goal)new ButterflyWanderGoal(this));
        }
    }
}

