/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings.client.gui;

import com.cicada.longwings.api.LongwingsHandler;
import com.cicada.longwings.client.model.ButterflyModel;
import com.cicada.longwings.client.model.MothModel;
import com.cicada.longwings.entity.ButterflyVariant;
import com.cicada.longwings.entity.EnumButterflyTraits;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import org.joml.Vector3f;

public class HandbookScreen
extends Screen {
    public static final Component TITLE = Component.m_237115_((String)"gui.longwings.handbook_screen");
    private ButterflyModel<?> butterflyModel;
    private MothModel<?> mothModel;
    ArrayList<ButterflyVariant> butterflyList = new ArrayList();
    ArrayList<ButterflyVariant> mothList = new ArrayList();
    private Button doneButton;
    private Button atlasButton;
    private Button sortButton;
    private PageButton pageFo;
    private PageButton pageBa;
    private BookmarkButton bookmarkButton;
    private ButterflyIndexButton butterflyIndexButton;
    private final Biome biome;
    private final boolean openedByMainHand;
    private int pages;
    private boolean bookmarked;
    private List<String> unlockedButterflyList = List.of("");
    private EnumButterflyTraits.ButterflySorts sortValue = EnumButterflyTraits.ButterflySorts.INDEX;

    public HandbookScreen(int page, boolean hand, boolean bookmarked, List<String> longwingsList, Biome biome) {
        super(TITLE);
        this.pages = page;
        this.biome = biome;
        this.openedByMainHand = hand;
        this.bookmarked = bookmarked;
        if (longwingsList != null) {
            this.unlockedButterflyList = longwingsList;
        }
    }

    protected void m_7856_() {
        int indexYPos;
        int indexXPos;
        int indexSz;
        boolean canSpawnInBiome;
        boolean isUnlocked;
        ButterflyVariant variantInSlot;
        int a;
        int i = (this.f_96543_ - 220) / 2;
        int j = (this.f_96544_ - 220) / 2;
        float biomeTemp = LongwingsHandler.getBiomeTemperature(this.biome);
        float biomeHumid = LongwingsHandler.getBiomeHumidity(this.biome);
        List<String> unlockedButterflyList = this.unlockedButterflyList;
        ArrayList<ButterflyVariant> butterflyList = this.butterflyList;
        ArrayList<ButterflyVariant> mothList = this.mothList;
        if (butterflyList.isEmpty() && mothList.isEmpty()) {
            butterflyList.addAll(Arrays.asList(ButterflyVariant.getButterflyVariantPool()));
            mothList.addAll(Arrays.asList(ButterflyVariant.getMothVariantPool()));
        }
        if (this.pages == 2) {
            int perRow = 12;
            int rowNum = 0;
            for (a = 0; a < butterflyList.size(); ++a) {
                int indexB = a;
                variantInSlot = (ButterflyVariant)butterflyList.get(indexB);
                isUnlocked = unlockedButterflyList != null && !unlockedButterflyList.stream().anyMatch(s -> s.matches(variantInSlot.getButterflyStringId()));
                boolean bl = canSpawnInBiome = biomeTemp >= variantInSlot.minTemp() && biomeTemp <= variantInSlot.maxTemp() && biomeHumid >= variantInSlot.minHumidity() && biomeHumid <= variantInSlot.maxHumidity();
                if (indexB % perRow == 0) {
                    ++rowNum;
                }
                indexSz = 15;
                indexXPos = i + indexSz * (indexB % perRow) + 19;
                indexYPos = j + indexSz * rowNum + 9;
                if (indexB >= 48) {
                    indexXPos += 15;
                }
                this.m_142416_((GuiEventListener)new ButterflyIndexButton(indexXPos, indexYPos, p_93751_ -> {
                    this.pages = 4 + indexB;
                    this.updateButtonVisibility();
                }, "butterfly/", variantInSlot.getButterflyStringId(), isUnlocked, canSpawnInBiome));
            }
        }
        if (this.pages == 3) {
            int rowNum = 0;
            int perRow = 6;
            for (a = 0; a < this.mothList.size(); ++a) {
                int indexM = a;
                variantInSlot = this.mothList.get(indexM);
                isUnlocked = unlockedButterflyList != null && !unlockedButterflyList.stream().anyMatch(s -> s.matches(variantInSlot.getButterflyStringId()));
                boolean bl = canSpawnInBiome = biomeTemp >= variantInSlot.minTemp() && biomeTemp <= variantInSlot.maxTemp() && biomeHumid >= variantInSlot.minHumidity() && biomeHumid <= variantInSlot.maxHumidity();
                if (indexM % perRow == 0) {
                    ++rowNum;
                }
                indexSz = 15;
                indexXPos = i + indexSz * (indexM % perRow) + 45 + 19;
                indexYPos = j + indexSz * rowNum + 14;
                if (indexM >= 18) {
                    indexXPos += 15;
                }
                this.m_142416_((GuiEventListener)new ButterflyIndexButton(indexXPos, indexYPos, p_93751_ -> {
                    this.pages = 4 + this.butterflyList.size() + indexM;
                    this.updateButtonVisibility();
                }, "moth/", this.mothList.get(indexM).getButterflyStringId(), isUnlocked, canSpawnInBiome));
            }
        }
        this.bookmarkButton = new BookmarkButton(i + 230, j - 18, p_93751_ -> {
            this.bookmarked = !this.bookmarked;
        });
        int xOffset = 0;
        this.doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, p_93751_ -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - (25 + xOffset), j + 152, 73, 20).m_253136_();
        this.atlasButton = Button.m_253074_((Component)CommonComponents.f_237098_, p_93751_ -> {
            this.pages = this.pages == 2 || this.pages > 3 + this.butterflyList.size() ? 3 : 2;
            this.updateButtonVisibility();
        }).m_252987_(this.f_96543_ / 2 - (50 + xOffset), j + 152, 20, 20).m_253136_();
        this.sortButton = Button.m_253074_((Component)CommonComponents.f_237098_, p_93751_ -> {
            HandbookScreen handbookScreen = this;
            this.sortValue = EnumButterflyTraits.ButterflySorts.values()[(this.sortValue.ordinal() + 1) % handbookScreen.sortValue.values().length];
            System.out.println((Object)this.sortValue);
            this.updateButtonVisibility();
        }).m_252987_(this.f_96543_ / 2 + (53 - xOffset), j + 152, 20, 20).m_253136_();
        if (this.pages > 1) {
            this.pageBa = new PageButton(i - 28, j + 119, false, p_93751_ -> {
                this.pageBa.m_93692_(false);
                this.pageBa.f_93623_ = false;
                --this.pages;
                this.updateButtonVisibility();
            }, true);
            this.m_142416_((GuiEventListener)this.pageBa);
        }
        if (this.pages < 3 + ButterflyVariant.getAllVariantPool().size()) {
            this.pageFo = new PageButton(i + 221, j + 119, true, p_93751_ -> {
                this.pageFo.m_93692_(false);
                this.pageFo.f_93623_ = false;
                ++this.pages;
                this.updateButtonVisibility();
            }, true);
            this.m_142416_((GuiEventListener)this.pageFo);
        }
        this.m_142416_((GuiEventListener)this.bookmarkButton);
        this.m_142416_((GuiEventListener)this.doneButton);
        this.m_142416_((GuiEventListener)this.atlasButton);
        this.butterflyModel = new ButterflyModel(Minecraft.m_91087_().m_167973_().m_171103_(ButterflyModel.LAYER_LOCATION));
        this.mothModel = new MothModel(Minecraft.m_91087_().m_167973_().m_171103_(MothModel.LAYER_LOCATION));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void updateButtonVisibility() {
        this.m_169413_();
        this.m_7856_();
    }

    private void renderText(GuiGraphics stack, String title, float xAdd, float yAdd, float zAdd, float xScale, float yScale, float zScale, boolean doDropshadow) {
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_252880_(xAdd, yAdd, zAdd);
        stack.m_280168_().m_85841_(xScale, yScale, zScale);
        String a = title;
        if (doDropshadow) {
            stack.m_280056_(this.f_96547_, a, 0, 0, 15589834, false);
        }
        stack.m_280056_(this.f_96547_, a, 0, 0, 12689522, false);
        stack.m_280168_().m_85849_();
    }

    private void renderProp(GuiGraphics p_289697_, int p_289667_, int p_289669_, float p_289670_, ResourceLocation texture, boolean largeBody) {
        float f = Mth.m_14179_((float)p_289670_, (float)1.0f, (float)1.0f);
        float f1 = Mth.m_14179_((float)p_289670_, (float)1.0f, (float)1.0f);
        VertexConsumer vertexconsumer = p_289697_.m_280091_().m_6299_(RenderType.m_110473_((ResourceLocation)texture));
        VertexConsumer vertexconsumer2 = p_289697_.m_280091_().m_6299_(RenderType.m_110452_((ResourceLocation)texture));
        float f3 = -(1.0f - f) * 90.0f - 90.0f;
        p_289697_.m_280168_().m_85836_();
        float f2 = 40.0f;
        p_289697_.m_280168_().m_85841_(45.0f, 45.0f, 1.0f);
        p_289697_.m_280168_().m_252880_((1.0f - f) * 0.2f, (1.0f - f) * 0.1f, 1.0f);
        float f4 = Mth.m_14036_((float)(Mth.m_14187_((float)(f1 + 0.25f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        float f5 = Mth.m_14036_((float)(Mth.m_14187_((float)(f1 + 0.75f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        p_289697_.m_280168_().m_252880_(0.56f, -0.7f, 0.525f);
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 2.0f, -50.0f).normalize(), (Vector3f)new Vector3f(0.0f, -2.0f, -50.0f).normalize());
        if (!largeBody) {
            this.butterflyModel.Butterfly.f_104205_ = (float)Math.PI;
            this.butterflyModel.Butterfly.f_104203_ = 1.5707964f;
            this.butterflyModel.LeftTena.f_104205_ = 1.5f;
            this.butterflyModel.RightTena.f_104205_ = -1.5f;
            this.butterflyModel.Butterfly.f_104204_ = 0.0f;
            this.butterflyModel.Butterfly.f_233553_ = 1.0f;
            this.butterflyModel.Butterfly.f_104202_ = 15.0f;
            this.butterflyModel.Body.f_104203_ = 0.0f;
            this.butterflyModel.Body.f_104204_ = 0.0f;
            this.butterflyModel.Body.f_104205_ = 0.0f;
            this.butterflyModel.Body.f_104200_ = 0.0f;
            p_289697_.m_280168_().m_85836_();
            p_289697_.m_280168_().m_85836_();
            p_289697_.m_280168_().m_252880_(0.062f, 0.012f, 0.0f);
            p_289697_.m_280168_().m_85841_(1.05f, 1.05f, 0.0f);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderType renderType = RenderType.m_110467_((ResourceLocation)texture);
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
            this.butterflyModel.Butterfly.m_104301_(p_289697_.m_280168_(), vertexConsumer, 0xF000F0, OverlayTexture.f_118083_);
            bufferSource.m_109912_(renderType);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            p_289697_.m_280168_().m_85849_();
            p_289697_.m_280168_().m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            MultiBufferSource.BufferSource bufferSource2 = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexConsumer2 = bufferSource2.m_6299_(RenderType.m_110467_((ResourceLocation)texture));
            this.butterflyModel.Butterfly.m_104301_(p_289697_.m_280168_(), vertexConsumer2, 0xF000F0, OverlayTexture.f_118083_);
            bufferSource.m_109912_(RenderType.m_110467_((ResourceLocation)texture));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            p_289697_.m_280168_().m_85849_();
            p_289697_.m_280168_().m_85849_();
        } else {
            this.mothModel.Butterfly.f_104205_ = (float)Math.PI;
            this.mothModel.Butterfly.f_104203_ = 1.5707964f;
            this.mothModel.LeftTena.f_104205_ = 1.5f;
            this.mothModel.RightTena.f_104205_ = -1.5f;
            this.mothModel.Butterfly.f_104204_ = 0.0f;
            this.mothModel.Butterfly.f_233553_ = 1.0f;
            this.mothModel.Butterfly.f_104202_ = 15.0f;
            p_289697_.m_280168_().m_85836_();
            p_289697_.m_280168_().m_252880_(0.15f, 0.0f, 0.0f);
            p_289697_.m_280168_().m_85836_();
            p_289697_.m_280168_().m_252880_(0.062f, 0.012f, 0.0f);
            p_289697_.m_280168_().m_85841_(1.05f, 1.05f, 0.0f);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderType renderType = RenderType.m_110467_((ResourceLocation)texture);
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
            this.mothModel.Butterfly.m_104301_(p_289697_.m_280168_(), vertexconsumer, 0xF000F0, OverlayTexture.f_118083_);
            bufferSource.m_109912_(renderType);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            p_289697_.m_280168_().m_85849_();
            p_289697_.m_280168_().m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            MultiBufferSource.BufferSource bufferSource2 = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexConsumer2 = bufferSource2.m_6299_(RenderType.m_110467_((ResourceLocation)texture));
            this.mothModel.Butterfly.m_104301_(p_289697_.m_280168_(), vertexconsumer, 0xF000F0, OverlayTexture.f_118083_);
            bufferSource.m_109912_(RenderType.m_110467_((ResourceLocation)texture));
            p_289697_.m_280168_().m_85849_();
            p_289697_.m_280168_().m_85849_();
        }
        p_289697_.m_280168_().m_85849_();
    }

    private void renderLocatePortion(GuiGraphics stack, int mouseX, int mouseY, float parT, String textureString, String textureID, String type, String rarity, String species, String family) {
        ButterflyVariant lepidoptera = ButterflyVariant.BLUE_MORPHO;
        for (int a = 0; a < ButterflyVariant.getAllVariantPool().size(); ++a) {
            if (!ButterflyVariant.getAllVariantPool().get(a).getButterflyStringId().matches(textureString)) continue;
            lepidoptera = ButterflyVariant.getAllVariantPool().get(a);
        }
        float minTemp = lepidoptera.minTemp();
        float maxTemp = lepidoptera.maxTemp();
        float minHumid = lepidoptera.minHumidity();
        float maxHumid = lepidoptera.maxHumidity();
        boolean validBiome = true;
        if (this.biome == null) {
            validBiome = false;
        }
        stack.m_280168_().m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.71f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int offsetX = 2;
        int offsetY = -3;
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_252880_(0.5f, 26.0f - minTemp - (float)((int)(maxTemp * 13.0f)), 0.0f);
        stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook.png"), 215 + offsetX, 91 + offsetY, 35, 122, 7, 5 + (int)((maxTemp - minTemp) * 13.0f));
        stack.m_280168_().m_85849_();
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_252880_(0.5f, 26.0f - minHumid - (float)((int)(maxHumid * 13.0f)), 0.0f);
        stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook.png"), 223 + offsetX, 91 + offsetY, 43, 122, 7, 5 + (int)((maxHumid - minHumid) * 13.0f));
        stack.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.m_280168_().m_85849_();
        float biomeTemp = LongwingsHandler.getBiomeTemperature(this.biome);
        float biomeHumid = LongwingsHandler.getBiomeHumidity(this.biome);
        if (validBiome) {
            stack.m_280168_().m_85836_();
            stack.m_280168_().m_252880_(0.0f, Math.min(-0.5f + -(biomeTemp * 13.5f), 0.0f), 0.0f);
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook.png"), 208 + offsetX, 118 + offsetY, 32, 155, 18, 25);
            stack.m_280168_().m_85849_();
            stack.m_280168_().m_85836_();
            stack.m_280168_().m_252880_(0.0f, Math.min(-0.5f + -biomeHumid * 13.5f, 0.0f), 0.0f);
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook.png"), 216 + offsetX, 118 + offsetY, 32, 155, 18, 25);
            stack.m_280168_().m_85849_();
        }
        if (validBiome) {
            boolean tempFlag;
            boolean humidFlag = biomeHumid >= minHumid && biomeHumid <= maxHumid;
            boolean bl = tempFlag = biomeTemp >= minTemp && biomeTemp <= maxTemp;
            if (humidFlag && tempFlag) {
                this.renderText(stack, Component.m_237115_((String)"title.longwings.spawn_confirm_1").getString(), 233.0f, 127.0f, 0.0f, 0.32f, 0.32f, 1.0f, true);
                this.renderText(stack, Component.m_237115_((String)"title.longwings.spawn_confirm_2").getString(), 233.0f, 130.0f, 0.0f, 0.32f, 0.32f, 1.0f, true);
            }
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook.png"), 214 + offsetX, 129 + offsetY, biomeTemp >= minTemp && biomeTemp <= maxTemp ? 47 : 55, 155, 9, 45);
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook.png"), 222 + offsetX, 129 + offsetY, biomeHumid >= minHumid && biomeHumid <= maxHumid ? 47 : 55, 155, 9, 45);
        }
    }

    private void renderLurePortion(GuiGraphics stack, int mouseX, int mouseY, float parT, String textureString, String textureID, String type, String rarity, String species, String family) {
        boolean flagC;
        ButterflyVariant lepidoptera = ButterflyVariant.BLUE_MORPHO;
        for (int a = 0; a < ButterflyVariant.getAllVariantPool().size(); ++a) {
            if (!ButterflyVariant.getAllVariantPool().get(a).getButterflyStringId().matches(textureString)) continue;
            lepidoptera = ButterflyVariant.getAllVariantPool().get(a);
        }
        stack.m_280168_().m_85836_();
        int brineCount = 0;
        int offset = 9;
        boolean flagA = lepidoptera.minTemp() >= 0.9f || lepidoptera.maxTemp() >= 0.9f;
        boolean flagB = (lepidoptera.minTemp() > 0.4f || lepidoptera.maxTemp() > 0.4f) && (lepidoptera.minTemp() < 0.9f || lepidoptera.maxTemp() < 0.9f);
        boolean bl = flagC = lepidoptera.minTemp() <= 0.4f || lepidoptera.maxTemp() <= 0.4f;
        if (flagA) {
            offset -= 3;
        }
        if (flagB) {
            offset -= 3;
        }
        if (flagC) {
            offset -= 3;
        }
        stack.m_280168_().m_252880_((float)(offset + 0), -2.0f, 0.0f);
        stack.m_280168_().m_85836_();
        this.renderText(stack, Component.m_237115_((String)"title.longwings.lure").getString() + ":", 162.0f, 126.0f, 0.0f, 0.4f, 0.4f, 0.7f, true);
        stack.m_280168_().m_252880_(172.0f, 123.0f, 0.0f);
        stack.m_280168_().m_85841_(0.035f, 0.035f, 0.035f);
        if (flagA) {
            stack.m_280218_(new ResourceLocation("longwings", "textures/item/watermelon_butterfly_brine.png"), 0, 0, 0, 0, 225, 284);
            ++brineCount;
        }
        if (flagB) {
            stack.m_280168_().m_85836_();
            stack.m_280168_().m_252880_((float)(165 * brineCount), 0.0f, 0.0f);
            stack.m_280218_(new ResourceLocation("longwings", "textures/item/apple_butterfly_brine.png"), 0, 0, 0, 0, 225, 284);
            stack.m_280168_().m_85849_();
            ++brineCount;
        }
        if (flagC) {
            stack.m_280168_().m_85836_();
            stack.m_280168_().m_252880_((float)(165 * brineCount), 0.0f, 0.0f);
            stack.m_280218_(new ResourceLocation("longwings", "textures/item/sweet_berry_butterfly_brine.png"), 0, 0, 0, 0, 225, 284);
            stack.m_280168_().m_85849_();
            ++brineCount;
        }
        stack.m_280168_().m_85849_();
        stack.m_280168_().m_85849_();
        boolean activeDay = lepidoptera.mostlyActive() == EnumButterflyTraits.ButterflyMostActive.DIURNAL;
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_252880_(195.5f, -1.5f, 0.0f);
        if (activeDay) {
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook.png"), 0, 119, 50, 124, 17, 15);
        } else {
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook.png"), 0, 121, 50, 138, 118, 15);
        }
        stack.m_280168_().m_85849_();
    }

    private void renderSpeciesPage(GuiGraphics stack, int mouseX, int mouseY, float parT, String textureString, String textureID, String type, String rarity, String species, String family) {
        float minHumid = 0.0f;
        float maxHumid = 0.0f;
        float minTemp = 1.0f;
        float maxTemp = 1.0f;
        boolean validBiome = true;
        EnumButterflyTraits.ButterflySizes typeSize = EnumButterflyTraits.ButterflySizes.NORMAL;
        EnumButterflyTraits.ButterflyRarity typeRarity = EnumButterflyTraits.ButterflyRarity.COMMON;
        String habitat = "This isnt functional yet";
        if (this.biome == null) {
            validBiome = false;
        }
        ButterflyVariant lepidoptera = ButterflyVariant.BLUE_MORPHO;
        for (int a = 0; a < ButterflyVariant.getAllVariantPool().size(); ++a) {
            if (!ButterflyVariant.getAllVariantPool().get(a).getButterflyStringId().matches(textureString)) continue;
            lepidoptera = ButterflyVariant.getAllVariantPool().get(a);
        }
        minHumid = lepidoptera.minHumidity();
        maxHumid = lepidoptera.maxHumidity();
        minTemp = lepidoptera.minTemp();
        maxTemp = lepidoptera.maxTemp();
        typeSize = lepidoptera.size();
        int spawnWeight = lepidoptera.getButterflySpawnRarity();
        if (spawnWeight <= 3) {
            typeRarity = EnumButterflyTraits.ButterflyRarity.EXTREMELY_RARE;
        }
        if (spawnWeight >= 4) {
            typeRarity = EnumButterflyTraits.ButterflyRarity.RARE;
        }
        if (spawnWeight >= 6) {
            typeRarity = EnumButterflyTraits.ButterflyRarity.UNCOMMON;
        }
        if (spawnWeight >= 8) {
            typeRarity = EnumButterflyTraits.ButterflyRarity.COMMON;
        }
        stack.m_280168_().m_85836_();
        float reductionValue = textureID.toString().length() - 12;
        float scale = 0.85f;
        float yModifier = 0.0f;
        float xTranslation = 0.0f;
        if (textureID.toString().length() > 12) {
            scale = 0.85f - 0.025f * reductionValue;
            yModifier = 0.22f * reductionValue;
            xTranslation = 0.55f * reductionValue;
        }
        this.renderText(stack, textureID, 163.0f, 54.0f + yModifier + 7.0f, 0.0f, scale, scale, scale, true);
        stack.m_280168_().m_85849_();
        this.renderText(stack, this.pages > 3 + ButterflyVariant.getButterflyVariantPool().length ? "Moth" : "Butterfly", 163.0f, 69.0f, 0.0f, 0.55f, 0.55f, 0.7f, true);
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_252880_(185.0f, 34.0f, 0.0f);
        stack.m_280168_().m_85841_(0.17f, 0.17f, 1.0f);
        if (this.pages > 3 + ButterflyVariant.getButterflyVariantPool().length) {
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 125, 0, 115, 255);
        } else {
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 0, 0, 115, 255);
        }
        stack.m_280168_().m_85849_();
        this.renderText(stack, Component.m_237115_((String)"title.longwings.family").getString() + ": " + Component.m_237115_((String)("title.longwings.family." + family.toLowerCase())).getString(), 162.0f, 93.0f, 0.0f, 0.4f, 0.4f, 0.7f, true);
        this.renderText(stack, Component.m_237115_((String)"title.longwings.size").getString() + ": " + Component.m_237115_((String)("title.longwings.size." + typeSize.toString().toLowerCase())).getString(), 162.0f, 99.0f, 0.0f, 0.4f, 0.4f, 0.7f, true);
        this.renderText(stack, Component.m_237115_((String)"title.longwings.rarity").getString() + ": " + Component.m_237115_((String)("title.longwings.rarity." + typeRarity.toString().toLowerCase())).getString(), 162.0f, 105.0f, 0.0f, 0.4f, 0.4f, 0.7f, true);
        this.renderText(stack, Component.m_237115_((String)"title.longwings.about").getString() + " ", 163.0f, 82.0f, 0.0f, 0.55f, 0.55f, 0.7f, true);
        this.renderText(stack, "_", 162.0f, 83.5f, 0.0f, 4.15f, 0.55f, 0.7f, false);
        this.renderText(stack, Component.m_237115_((String)"title.longwings.locate").getString() + " ", 213.0f, 82.0f, 0.0f, 0.55f, 0.55f, 0.7f, true);
        this.renderText(stack, "_", 212.0f, 83.5f, 0.0f, 3.85f, 0.55f, 0.7f, false);
        this.renderLocatePortion(stack, mouseX, mouseY, parT, textureString, textureID, type, rarity, species, family);
        this.renderLurePortion(stack, mouseX, mouseY, parT, textureString, textureID, type, rarity, species, family);
        ResourceLocation location = new ResourceLocation("longwings", "textures/entity/butterfly/" + textureString + ".png");
        if (this.pages > 3 + this.butterflyList.size() && this.pages < 4 + this.butterflyList.size() + this.mothList.size()) {
            location = new ResourceLocation("longwings", "textures/entity/moth/" + textureString + ".png");
        }
        if (this.pages >= 3) {
            stack.m_280168_().m_85836_();
            stack.m_280168_().m_252880_(72.0f, 61.0f, 1.0f);
            boolean hasMothBody = lepidoptera.bodyType() == EnumButterflyTraits.BodyType.MOTH;
            this.renderProp(stack, mouseX, mouseY, parT, location, hasMothBody);
            stack.m_280168_().m_85849_();
        }
        float minValue = lepidoptera.minTemp();
        float maxValue = lepidoptera.maxTemp();
    }

    private void renderSpeciesPagesAlt(GuiGraphics stack, int mouseX, int mouseY, float parT) {
        if (this.pages <= 1) {
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook_title.png"), 32, 32, 0, 0, 225, 122);
        } else if (this.pages == 2 || this.pages == 3) {
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook_atlas.png"), 32, 32, 0, 0, 225, 122);
            if (this.pages == 2) {
                stack.m_280168_().m_85836_();
                stack.m_280168_().m_252880_(118.5f, 35.0f, 0.0f);
                stack.m_280168_().m_85841_(0.2f, 0.2f, 0.2f);
                stack.m_280218_(new ResourceLocation("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 0, 0, 115, 255);
                stack.m_280168_().m_85836_();
                stack.m_280168_().m_252880_(125.0f, 55.0f, 0.0f);
                stack.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                stack.m_280218_(new ResourceLocation("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 125, 0, 115, 255);
                stack.m_280168_().m_85849_();
                stack.m_280168_().m_85849_();
            }
            if (this.pages == 3) {
                stack.m_280168_().m_85836_();
                stack.m_280168_().m_252880_(135.5f, 35.0f, 0.0f);
                stack.m_280168_().m_85841_(0.2f, 0.2f, 0.2f);
                stack.m_280218_(new ResourceLocation("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 125, 0, 115, 255);
                stack.m_280168_().m_85836_();
                stack.m_280168_().m_252880_(-50.0f, 55.0f, 0.0f);
                stack.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                stack.m_280218_(new ResourceLocation("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 0, 0, 115, 255);
                stack.m_280168_().m_85849_();
                stack.m_280168_().m_85849_();
            }
        } else if (this.pages >= 4 && this.pages <= 3 + this.butterflyList.size() + this.mothList.size()) {
            ArrayList<ButterflyVariant> variantList;
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook.png"), 32, 32, 0, 0, 225, 122);
            int commonPages = this.pages > this.butterflyList.size() + 3 ? this.pages - this.butterflyList.size() - 4 : this.pages - 4;
            ArrayList<ButterflyVariant> arrayList = variantList = this.pages <= 4 + commonPages ? this.butterflyList : this.mothList;
            if (commonPages < this.butterflyList.size() + this.mothList.size()) {
                this.renderSpeciesPage(stack, mouseX, mouseY, parT, variantList.get(commonPages).id(), MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)("title.longwings." + variantList.get(commonPages).id())).m_214077_()).getString(), variantList.get(commonPages).getButterflyClimateType(), String.valueOf(Math.round((float)variantList.get(commonPages).getButterflySpawnRarity() / (float)variantList.size() * 100.0f) + "%"), variantList.get(commonPages).id(), variantList.get(commonPages).getButterflyFamilyType().name());
            }
        }
        if (this.bookmarked) {
            stack.m_280168_().m_85836_();
            stack.m_280168_().m_85837_(0.3, 0.2, 0.0);
            stack.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook_atlas.png"), 223, 34, 0, 159, 18, 20);
            stack.m_280168_().m_85849_();
        }
    }

    public void m_88315_(GuiGraphics stack, int mouseX, int mouseY, float parT) {
        int i = (this.f_96543_ - 220) / 2;
        int j = (this.f_96544_ - 220) / 2;
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_85841_(1.0f, 1.0f, 1.0f);
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_252880_((float)i - 91.5f, (float)(j - 70), 0.0f);
        stack.m_280168_().m_85841_(1.4f, 1.4f, 1.4f);
        this.renderSpeciesPagesAlt(stack, mouseX, mouseY, parT);
        stack.m_280168_().m_85849_();
        super.m_88315_(stack, mouseX, mouseY, parT);
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_252880_((float)this.atlasButton.m_252754_() + 4.8f, (float)this.atlasButton.m_252907_() + 4.0f, 0.0f);
        stack.m_280168_().m_85841_(0.05f, 0.05f, 0.05f);
        stack.m_280218_(new ResourceLocation("longwings", "textures/gui/index.png"), 0, 0, 0, 0, 250, 250);
        stack.m_280168_().m_85849_();
        if (this.sortButton.m_198029_()) {
            stack.m_280137_(this.f_96547_, "|", this.sortButton.m_252754_() + 10, this.sortButton.m_252907_() + 23, 0xFFFFFF);
            stack.m_280137_(this.f_96547_, "Sort: " + this.sortValue.toString().toLowerCase(), this.sortButton.m_252754_() + 10, this.sortButton.m_252907_() + 32, 0xFFFFFF);
        }
        stack.m_280168_().m_85849_();
        stack.m_280168_().m_85849_();
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return super.m_5953_(mouseX, mouseY);
    }

    public void m_7379_() {
        this.sendBookmarkClientData(this.pages, this.openedByMainHand, this.bookmarked);
        super.m_7379_();
    }

    public boolean m_6913_() {
        return true;
    }

    public void sendBookmarkClientData(int pages, boolean openedByMainHand, boolean bookmarked) {
        LongwingsHandler.getHandbookHandler().onCloseSyncData(pages, openedByMainHand, bookmarked);
    }

    public class ButterflyIndexButton
    extends Button {
        String prefixString;
        String typeIdString;
        private ButterflyModel butterflyModel;
        boolean locked;
        boolean canSpawn;

        public ButterflyIndexButton(int p_99225_, int p_99226_, Button.OnPress p_99228_, String prefix, String butterflyID, boolean locked, boolean canSpawn) {
            super(p_99225_, p_99226_, 15, 15, CommonComponents.f_237098_, p_99228_, f_252438_);
            this.prefixString = "error";
            this.typeIdString = "error";
            this.prefixString = prefix;
            this.typeIdString = butterflyID;
            this.locked = locked;
            this.canSpawn = canSpawn;
        }

        public void renderSelectedText(GuiGraphics p_283468_) {
            MutableComponent typeComponent = Component.m_237115_((String)("title.longwings." + this.typeIdString));
            String string = typeComponent.getString();
            p_283468_.m_280168_().m_85836_();
            p_283468_.m_280168_().m_252880_((float)p_283468_.m_280182_() / 2.0f, (float)p_283468_.m_280206_() / 2.0f, 1.0f);
            HandbookScreen.this.renderText(p_283468_, string, -((float)string.length() * 1.8f), HandbookScreen.this.pages == 3 ? -12.0f : -2.0f, 1.0f, 0.7f, 0.7f, 1.0f, false);
            p_283468_.m_280168_().m_85836_();
            p_283468_.m_280168_().m_85841_(1.5f, 5.0f, 1.0f);
            p_283468_.m_280168_().m_252880_(-10.0f, -5.0f, 0.0f);
            p_283468_.m_280168_().m_85849_();
            p_283468_.m_280168_().m_85849_();
        }

        public void m_87963_(GuiGraphics p_283468_, int p_282922_, int p_283637_, float p_282459_) {
            int h = (p_283468_.m_280182_() - 220) / 2;
            int i = (p_283468_.m_280206_() - 220) / 2;
            int j = 192;
            int a = (this.f_93618_ - 250) / 2;
            p_283468_.m_280168_().m_85836_();
            p_283468_.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
            p_283468_.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
            boolean mothBodyCheck = false;
            ArrayList<ButterflyVariant> allTypePool = ButterflyVariant.getAllVariantPool();
            for (int b = 0; b < allTypePool.size(); ++b) {
                if (!allTypePool.get(b).getButterflyStringId().matches(this.typeIdString.toLowerCase()) || allTypePool.get(b).bodyType() != EnumButterflyTraits.BodyType.MOTH) continue;
                mothBodyCheck = true;
            }
            if (HandbookScreen.this.pages == 2 || HandbookScreen.this.pages == 3) {
                ResourceLocation location = new ResourceLocation("longwings", "textures/entity/" + this.prefixString + this.typeIdString + ".png");
                if (this.locked) {
                    p_283468_.m_280168_().m_85836_();
                    p_283468_.m_280168_().m_252880_(-0.5f, 0.0f, 0.0f);
                    if (this.canSpawn) {
                        p_283468_.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook_atlas.png"), 1, 0, 57, j + 185 + 1, 10, 10);
                    } else {
                        p_283468_.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook_atlas.png"), 1, 0, 57, j + 185 + 1, 10, 10);
                    }
                    p_283468_.m_280168_().m_85849_();
                } else if (this.m_274382_() || this.m_93696_()) {
                    p_283468_.m_280168_().m_85836_();
                    p_283468_.m_280168_().m_252880_(-2.0f, -1.0f, 0.0f);
                    p_283468_.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook_atlas.png"), 0, -1, 46, j + 185 + 1, 12, 12);
                    p_283468_.m_280168_().m_85849_();
                    p_283468_.m_280168_().m_85836_();
                    p_283468_.m_280168_().m_252880_(-8.0f, -25.0f, 1.0f);
                    p_283468_.m_280168_().m_85841_(0.525f, 0.525f, 1.0f);
                    HandbookScreen.this.renderProp(p_283468_, p_282922_, p_282922_, p_282459_, location, mothBodyCheck);
                    p_283468_.m_280168_().m_85849_();
                } else {
                    p_283468_.m_280168_().m_85836_();
                    p_283468_.m_280168_().m_85837_(-0.4, 0.0, 0.0);
                    p_283468_.m_280218_(new ResourceLocation("longwings", "textures/gui/handbook_atlas.png"), 0, 0, 34, j + 185 + 1, 12, 12);
                    p_283468_.m_280168_().m_85849_();
                    p_283468_.m_280168_().m_85836_();
                    p_283468_.m_280168_().m_252880_(3.0f, 1.0f, 0.0f);
                    p_283468_.m_280168_().m_85841_(0.125f, 0.124f, 1.0f);
                    HandbookScreen.this.renderProp(p_283468_, p_282922_, p_282922_, p_282459_, location, mothBodyCheck);
                    p_283468_.m_280168_().m_85849_();
                }
            }
            p_283468_.m_280168_().m_85849_();
            if (!this.locked && this.m_198029_()) {
                this.renderSelectedText(p_283468_);
            }
        }

        public void m_7435_(SoundManager p_99231_) {
            p_99231_.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    public class BookmarkButton
    extends Button {
        public BookmarkButton(int p_99225_, int p_99226_, Button.OnPress p_99228_) {
            super(p_99225_, p_99226_, 13, 20, CommonComponents.f_237098_, p_99228_, f_252438_);
        }

        public void m_87963_(GuiGraphics p_283468_, int p_282922_, int p_283637_, float p_282459_) {
        }

        public void m_7435_(SoundManager p_99231_) {
            p_99231_.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)2.0f));
        }
    }
}

