/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.item.foodcontainer;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import team.creative.creativecore.common.util.type.list.TupleList;
import team.creative.solonion.api.FoodCapability;
import team.creative.solonion.api.OnionFoodContainer;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.item.foodcontainer.FoodContainerCapabilityProvider;
import team.creative.solonion.common.item.foodcontainer.FoodContainerProvider;
import team.creative.solonion.common.mod.OriginsManager;

public class FoodContainerItem
extends Item
implements OnionFoodContainer {
    private String displayName;
    private int nslots;

    public FoodContainerItem(int nslots, String displayName) {
        super(new Item.Properties().m_41487_(1).setNoRepair());
        this.displayName = displayName;
        this.nslots = nslots;
    }

    public boolean m_41472_() {
        return true;
    }

    public FoodProperties m_41473_() {
        return new FoodProperties.Builder().m_38767_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity == null) {
            return super.m_6225_(context);
        }
        IItemHandler handler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (handler == null) {
            return super.m_6225_(context);
        }
        ItemStackHandler inv = FoodContainerItem.getInventory(context.m_43722_());
        if (inv == null) {
            return super.m_6225_(context);
        }
        TupleList bestStacks = new TupleList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || stack.getFoodProperties((LivingEntity)context.m_43723_()) == null || !OriginsManager.isEdible(context.m_43723_(), stack)) continue;
            for (int j = 0; j < inv.getSlots(); ++j) {
                ItemStack toBeStacked = inv.getStackInSlot(j);
                if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)toBeStacked) || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)toBeStacked)) continue;
                int maxStackSize = Math.min(stack.m_41741_(), inv.getSlotLimit(j));
                if (!toBeStacked.m_41619_() && toBeStacked.m_41613_() < maxStackSize) {
                    toBeStacked.m_41769_(handler.extractItem(i, maxStackSize - toBeStacked.m_41613_(), false).m_41613_());
                }
                if ((stack = handler.getStackInSlot(i)).m_41619_()) break;
            }
            bestStacks.add((Object)SOLOnion.CONFIG.getDiversity((LivingEntity)context.m_43723_(), stack), (Object)i);
        }
        bestStacks.sort((x, y) -> ((Double)y.key).compareTo((Double)x.key));
        Iterator iterator = bestStacks.values().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack stack = handler.extractItem(slot, handler.getStackInSlot(slot).m_41613_(), false);
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)stack, (boolean)false);
            if (result.m_41619_()) continue;
            handler.insertItem(slot, result, false);
            break;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_ && player.m_6047_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new FoodContainerProvider(this.displayName), (BlockPos)player.m_20183_());
        }
        if (!player.m_6047_()) {
            return this.processRightClick(world, player, hand);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    private InteractionResultHolder<ItemStack> processRightClick(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (FoodContainerItem.isInventoryEmpty(player, stack)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_36391_(false)) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private static boolean isInventoryEmpty(Player player, ItemStack container) {
        ItemStackHandler handler = FoodContainerItem.getInventory(container);
        if (handler == null) {
            return true;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || !stack.m_41614_() || !OriginsManager.isEdible(player, stack)) continue;
            return false;
        }
        return true;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"item.solonion.container.open", (Object[])new Object[]{Component.m_237117_((String)"key.sneak"), Component.m_237117_((String)"key.use")}));
        super.m_7373_(stack, level, tooltip, flag);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FoodContainerCapabilityProvider(stack, this.nslots);
    }

    @Nullable
    public static ItemStackHandler getInventory(ItemStack bag) {
        if (bag.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
            return (ItemStackHandler)bag.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().get();
        }
        return null;
    }

    @Override
    public ItemStack getActualFood(Player player, ItemStack stack) {
        ItemStackHandler handler = FoodContainerItem.getInventory(stack);
        if (handler == null) {
            return ItemStack.f_41583_;
        }
        int bestFoodSlot = FoodContainerItem.getBestFoodSlot(handler, player);
        if (bestFoodSlot < 0) {
            return ItemStack.f_41583_;
        }
        return handler.getStackInSlot(bestFoodSlot).m_41777_();
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ItemStackHandler handler = FoodContainerItem.getInventory(stack);
        if (handler == null) {
            return stack;
        }
        int bestFoodSlot = FoodContainerItem.getBestFoodSlot(handler, player);
        if (bestFoodSlot < 0) {
            return stack;
        }
        ItemStack bestFood = handler.getStackInSlot(bestFoodSlot);
        ItemStack foodCopy = bestFood.m_41777_();
        if (bestFood.m_41614_() && !bestFood.m_41619_() && OriginsManager.isEdible(player, foodCopy)) {
            ItemStack result = bestFood.m_41671_(world, entity);
            if (!result.m_41614_()) {
                handler.setStackInSlot(bestFoodSlot, ItemStack.f_41583_);
                Player playerEntity = (Player)entity;
                if (!playerEntity.m_150109_().m_36054_(result)) {
                    playerEntity.m_36176_(result, false);
                }
            }
            if (!world.f_46443_) {
                ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)foodCopy, (int)0, (ItemStack)result);
            }
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public static int getBestFoodSlot(ItemStackHandler handler, Player player) {
        FoodCapability foodList = SOLOnionAPI.getFoodCapability(player);
        double maxDiversity = -1.7976931348623157E308;
        int bestFoodSlot = -1;
        for (int i = 0; i < handler.getSlots(); ++i) {
            double diversityChange;
            ItemStack food = handler.getStackInSlot(i);
            if (!food.m_41614_() || food.m_41619_() || !OriginsManager.isEdible(player, food) || !((diversityChange = foodList.simulateEat((LivingEntity)player, food)) > maxDiversity)) continue;
            maxDiversity = diversityChange;
            bestFoodSlot = i;
        }
        return bestFoodSlot;
    }
}

