/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.item.foodcontainer;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import team.creative.solonion.common.item.foodcontainer.FoodContainerItem;

public class FoodContainerCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    private int slots;
    private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler(this.slots){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return !(stack.m_41720_() instanceof FoodContainerItem) && super.isItemValid(slot, stack);
        }
    });

    public FoodContainerCapabilityProvider(ItemStack stack, int slots) {
        this.slots = slots;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        if (this.inventory.isPresent()) {
            return ((ItemStackHandler)this.inventory.resolve().get()).serializeNBT();
        }
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.inventory.ifPresent(h -> h.deserializeNBT(nbt));
    }
}

