/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client.gui.elements;

import java.awt.Rectangle;
import java.util.List;
import team.creative.solonion.client.gui.elements.UIElement;

public final class UIStack
extends UIElement {
    public Axis axis = Axis.HORIZONTAL;
    public int spacing = 1;

    public UIStack() {
        super(new Rectangle(0, 0));
    }

    public void addChild(UIElement child) {
        this.children.add(child);
        this.updateFrames();
    }

    public List<UIElement> getChildren() {
        return this.children;
    }

    public void updateFrames() {
        switch (this.axis) {
            case HORIZONTAL: {
                int x = 0;
                int height = this.children.stream().mapToInt(child -> child.frame.height).max().orElse(0);
                for (UIElement child2 : this.children) {
                    child2.frame.x = this.frame.x + x;
                    child2.frame.y = this.frame.y + (height - child2.frame.height) / 2;
                    if (child2 instanceof UIStack) {
                        ((UIStack)child2).updateFrames();
                    }
                    x += child2.frame.width;
                    x += this.spacing;
                }
                this.frame.width = x - this.spacing;
                this.frame.height = height;
                break;
            }
            case VERTICAL: {
                int y = 0;
                int width = this.children.stream().mapToInt(child -> child.frame.width).max().orElse(0);
                for (UIElement child3 : this.children) {
                    child3.frame.x = this.frame.x + (width - child3.frame.width) / 2;
                    child3.frame.y = this.frame.y + y;
                    if (child3 instanceof UIStack) {
                        ((UIStack)child3).updateFrames();
                    }
                    y += child3.frame.height;
                    y += this.spacing;
                }
                this.frame.width = width;
                this.frame.height = y - this.spacing;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static enum Axis {
        HORIZONTAL,
        VERTICAL;

    }
}

