/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import team.creative.solonion.api.FoodCapability;
import team.creative.solonion.api.OnionFoodContainer;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.client.gui.screen.FoodBookScreen;
import team.creative.solonion.client.gui.screen.FoodContainerScreen;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.item.SOLOnionItems;

public class SOLOnionClient {
    public static KeyMapping OPEN_FOOD_BOOK;

    public static void load(IEventBus bus) {
        bus.addListener(SOLOnionClient::setupClient);
        bus.addListener(SOLOnionClient::registerKeybinds);
        MinecraftForge.EVENT_BUS.addListener(SOLOnionClient::handleKeypress);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, SOLOnionClient::onItemTooltip);
    }

    public static void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)SOLOnionItems.FOOD_CONTAINER.get()), FoodContainerScreen::new));
    }

    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        OPEN_FOOD_BOOK = new KeyMapping("key.solonion.open_food_book", InputConstants.f_84822_.m_84873_(), "key.solonion.category");
        event.register(OPEN_FOOD_BOOK);
    }

    public static void handleKeypress(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (OPEN_FOOD_BOOK != null && OPEN_FOOD_BOOK.m_90857_()) {
            FoodBookScreen.open((Player)player);
        }
    }

    public static void onItemTooltip(ItemTooltipEvent event) {
        if (!SOLOnion.CONFIG.isFoodTooltipEnabled) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof OnionFoodContainer) {
            OnionFoodContainer c = (OnionFoodContainer)item;
            stack = c.getActualFood(player, stack);
        }
        if (!stack.m_41614_()) {
            return;
        }
        FoodCapability food = SOLOnionAPI.getFoodCapability(player);
        SOLOnionClient.addTooltip(food.simulateEat((LivingEntity)player, stack), food.getLastEaten((LivingEntity)player, stack), stack, event.getToolTip(), player);
    }

    public static void addTooltip(double diversity, int lastEaten, ItemStack stack, List<Component> tooltip, Player player) {
        boolean isAllowed = SOLOnion.CONFIG.isAllowed(stack);
        if (!isAllowed) {
            if (SOLOnion.CONFIG.showDisabledTooltip) {
                tooltip.add((Component)Component.m_237115_((String)"gui.solonion.tooltip.disabled").m_130938_(style -> style.m_131157_(ChatFormatting.DARK_GRAY)));
            }
            return;
        }
        ChatFormatting color = ChatFormatting.GRAY;
        if (diversity < 0.0) {
            color = ChatFormatting.RED;
        } else if (diversity > 0.0) {
            color = ChatFormatting.GREEN;
        }
        MutableComponent text = Component.m_237115_((String)"gui.solonion.tooltip.diversity").m_130946_(": " + String.format("%.2f", SOLOnion.CONFIG.getDiversity((LivingEntity)player, stack))).m_130940_(ChatFormatting.GRAY);
        if (SOLOnion.CONFIG.showDiversityChangeInTooltip) {
            text = text.m_130946_(" (").m_7220_((Component)Component.m_237113_((String)String.format("%.2f", diversity)).m_130940_(color)).m_130946_(")");
        }
        tooltip.add((Component)text);
        if (lastEaten != -1) {
            String last_eaten_path = "tooltip.last_eaten";
            if (lastEaten == 1) {
                last_eaten_path = "tooltip.last_eaten_singular";
            }
            tooltip.add((Component)Component.m_237110_((String)("gui.solonion." + last_eaten_path), (Object[])new Object[]{lastEaten}).m_130940_(ChatFormatting.GRAY));
        }
    }
}

