/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class HorizontalRow
extends BaseMode {
    public HorizontalRow(boolean exchanging) {
        super(exchanging);
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("buildinggadgets2", "horizontal_row");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        Direction side;
        ItemStack gadget = BaseGadget.getGadget(player);
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        int range = GadgetNBT.getToolRange(gadget);
        boolean placeontop = GadgetNBT.getSetting(gadget, "placeontop");
        BlockPos startAt = placeontop ? start.m_7494_() : start;
        Direction direction = side = hitSide.m_122434_() == Direction.Axis.Y ? player.m_6350_() : hitSide.m_122424_();
        if (!this.isExchanging) {
            for (int i = 0; i < range; ++i) {
                if (!this.isPosValid(player.m_9236_(), player, startAt.m_5484_(side, i), state)) continue;
                coordinates.add(new StatePos(state, startAt.m_5484_(side, i).m_121996_((Vec3i)start)));
            }
        } else {
            side = side.m_122427_();
            int halfRange = range / 2;
            for (int i = -halfRange; i <= halfRange; ++i) {
                if (!this.isPosValid(player.m_9236_(), player, startAt.m_5484_(side, i), state)) continue;
                coordinates.add(new StatePos(state, startAt.m_5484_(side, i).m_121996_((Vec3i)start)));
            }
        }
        boolean connected = GadgetNBT.getSetting(gadget, GadgetNBT.NBTValues.CONNECTED_AREA.value);
        if (this.isExchanging && connected) {
            return this.removeUnConnected(player.m_9236_(), player, startAt.m_121996_((Vec3i)start), coordinates, hitSide);
        }
        return coordinates;
    }
}

