/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.datatypes;

import com.direwolf20.buildinggadgets2.datagen.BG2BlockTags;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TemplateJsonRepresentation {
    public static final int B1_BYTE_MASK = 255;
    public static final int B2_BYTE_MASK = 65535;
    public static final int B3_BYTE_MASK = 0xFFFFFF;
    public final JsonObject header;
    public final String body;

    private TemplateJsonRepresentation(JsonObject header, String body) {
        this.header = header;
        this.body = body;
    }

    public static ArrayList<StatePos> deserialize(CompoundTag nbt, BlockPos startPos, BlockPos endPos) {
        ArrayList<StatePos> statePosList = new ArrayList<StatePos>();
        ListTag posList = nbt.m_128437_("pos", 4);
        ListTag stateList = nbt.m_128437_("data", 10);
        HashMap<BlockPos, BlockState> tempMap = new HashMap<BlockPos, BlockState>();
        for (Tag inbt : posList) {
            LongTag longNBT = (LongTag)inbt;
            BlockPos pos2 = TemplateJsonRepresentation.posFromLong(longNBT.m_7046_());
            int stateID = TemplateJsonRepresentation.readStateId(longNBT.m_7046_());
            BlockState blockState = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)stateList.m_128728_(stateID).m_128469_("state"));
            tempMap.put(pos2, blockState);
        }
        AABB area = new AABB(startPos, endPos);
        BlockPos.m_121921_((AABB)area).map(BlockPos::m_7949_).forEach(pos -> {
            BlockState blockState = tempMap.getOrDefault(pos, Blocks.f_50016_.m_49966_());
            if (blockState.m_60795_()) {
                statePosList.add(new StatePos(blockState, (BlockPos)pos));
                return;
            }
            if (blockState.m_204336_(BG2BlockTags.BG2DENY)) {
                statePosList.add(new StatePos(Blocks.f_50016_.m_49966_(), (BlockPos)pos));
                return;
            }
            if (blockState.m_60734_().m_155943_() < 0.0f) {
                statePosList.add(new StatePos(Blocks.f_50016_.m_49966_(), (BlockPos)pos));
                return;
            }
            if (!blockState.m_60819_().m_76178_() && !blockState.m_60819_().m_76170_()) {
                statePosList.add(new StatePos(Blocks.f_50016_.m_49966_(), (BlockPos)pos));
                return;
            }
            statePosList.add(new StatePos(blockState, (BlockPos)pos));
        });
        return statePosList;
    }

    public static BlockPos posFromLong(long serialized) {
        int x = (int)(serialized >> 24 & 0xFFFFL);
        int y = (int)(serialized >> 16 & 0xFFL);
        int z = (int)(serialized & 0xFFFFL);
        return new BlockPos(x, y, z);
    }

    public static int readStateId(long serialized) {
        return (int)(serialized >> 40 & 0xFFFFFFL);
    }
}

