/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.worlddata;

import com.direwolf20.buildinggadgets2.util.datatypes.PasteData;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;

public class BG2Data
extends SavedData {
    private static final String NAME = "buildinggadgets2";
    private final HashMap<UUID, ArrayList<StatePos>> undoList;
    private final HashMap<UUID, ArrayList<StatePos>> copyPasteLookup;
    private final HashMap<UUID, ArrayList<TagPos>> teMap;
    private final HashMap<UUID, PasteData> pasteChunks = new HashMap();
    private final BiMap<UUID, String> redprintLookup;

    public BG2Data(HashMap<UUID, ArrayList<StatePos>> undoList, HashMap<UUID, ArrayList<StatePos>> copyPasteLookup, HashMap<UUID, ArrayList<TagPos>> teMap, BiMap<UUID, String> redprintLookup) {
        this.undoList = undoList;
        this.copyPasteLookup = copyPasteLookup;
        this.teMap = teMap;
        this.redprintLookup = redprintLookup;
    }

    public boolean addToRedprints(UUID uuid, String name) {
        if (this.redprintLookup.containsKey((Object)uuid)) {
            return false;
        }
        if (this.redprintLookup.containsValue((Object)name)) {
            return false;
        }
        this.redprintLookup.put((Object)uuid, (Object)name);
        return true;
    }

    public boolean removeFromRedprints(String name) {
        if (this.redprintLookup.containsValue((Object)name)) {
            UUID uuid = (UUID)this.redprintLookup.inverse().get((Object)name);
            this.redprintLookup.remove((Object)uuid);
            this.copyPasteLookup.remove(uuid);
            this.teMap.remove(uuid);
            return true;
        }
        return false;
    }

    public UUID getRedprintUUIDfromName(String name) {
        if (this.redprintLookup.containsValue((Object)name)) {
            return (UUID)this.redprintLookup.inverse().get((Object)name);
        }
        return null;
    }

    public BiMap<UUID, String> getRedprintLookup() {
        return this.redprintLookup;
    }

    public boolean addToPasteChunks(UUID copyUUID, int position, int totalChunks, FriendlyByteBuf pasteChunk) {
        PasteData data = this.pasteChunks.computeIfAbsent(copyUUID, k -> new PasteData(totalChunks));
        data.addChunk(position, pasteChunk);
        return data.isComplete();
    }

    public CompoundTag getAssembledTag(UUID copyUUID) {
        PasteData pasteData = this.pasteChunks.get(copyUUID);
        FriendlyByteBuf assembledData = pasteData.assembleData();
        CompoundTag compoundTag = assembledData.m_130260_();
        this.pasteChunks.remove(copyUUID);
        return compoundTag;
    }

    public boolean containsUndoList(UUID uuid) {
        return this.undoList.containsKey(uuid);
    }

    public void addToUndoList(UUID uuid, ArrayList<StatePos> list, Level level) {
        this.undoList.put(uuid, list);
        this.m_77762_();
    }

    public void removeFromUndoList(UUID uuid) {
        this.undoList.remove(uuid);
        this.m_77762_();
    }

    public void addToCopyPaste(UUID uuid, ArrayList<StatePos> list) {
        this.copyPasteLookup.put(uuid, list);
        this.m_77762_();
    }

    public void addToTEMap(UUID uuid, ArrayList<TagPos> list) {
        this.teMap.put(uuid, list);
        this.m_77762_();
    }

    public ArrayList<StatePos> getCopyPasteList(UUID uuid, boolean remove) {
        ArrayList<StatePos> returnList = this.copyPasteLookup.get(uuid);
        if (remove) {
            returnList = this.copyPasteLookup.remove(uuid);
            this.m_77762_();
        }
        return returnList;
    }

    public CompoundTag getCopyPasteListAsNBTMap(UUID uuid, boolean remove) {
        return BG2Data.statePosListToNBTMapArray(this.getCopyPasteList(uuid, remove));
    }

    public ArrayList<StatePos> peekUndoList(UUID uuid) {
        ArrayList<StatePos> posList = this.undoList.get(uuid);
        this.m_77762_();
        return posList;
    }

    public ArrayList<StatePos> popUndoList(UUID uuid) {
        ArrayList<StatePos> posList = this.undoList.remove(uuid);
        this.m_77762_();
        return posList;
    }

    public ArrayList<TagPos> peekTEMap(UUID uuid) {
        ArrayList<TagPos> tagList = this.teMap.get(uuid);
        return tagList;
    }

    public ArrayList<TagPos> getTEMap(UUID uuid) {
        ArrayList<TagPos> tagList = this.teMap.remove(uuid);
        this.m_77762_();
        return tagList;
    }

    public static CompoundTag statePosListToNBTMapArray(ArrayList<StatePos> list) {
        CompoundTag tag = new CompoundTag();
        if (list == null || list.isEmpty()) {
            return tag;
        }
        ArrayList<BlockState> blockStateMap = StatePos.getBlockStateMap(list);
        ListTag blockStateMapList = StatePos.getBlockStateNBT(blockStateMap);
        int[] blocklist = new int[list.size()];
        int[] counter = new int[]{0};
        BlockPos start = list.get((int)0).pos;
        BlockPos end = list.get((int)(list.size() - 1)).pos;
        AABB aabb = new AABB(start, end);
        Map<BlockPos, BlockState> blockStateByPos = list.stream().collect(Collectors.toMap(e -> e.pos, e -> e.state));
        BlockPos.m_121921_((AABB)aabb).map(BlockPos::m_7949_).forEach(pos -> {
            BlockState blockState = (BlockState)blockStateByPos.get(pos);
            int n = counter[0];
            counter[0] = n + 1;
            blocklist[n] = blockStateMap.indexOf(blockState);
        });
        tag.m_128365_("startpos", (Tag)NbtUtils.m_129224_((BlockPos)start));
        tag.m_128365_("endpos", (Tag)NbtUtils.m_129224_((BlockPos)end));
        tag.m_128365_("blockstatemap", (Tag)blockStateMapList);
        tag.m_128385_("statelist", blocklist);
        return tag;
    }

    public static ArrayList<StatePos> statePosListFromNBTMapArray(CompoundTag tag) {
        ArrayList<StatePos> statePosList = new ArrayList<StatePos>();
        if (!tag.m_128441_("blockstatemap") || !tag.m_128441_("statelist")) {
            return statePosList;
        }
        ArrayList<BlockState> blockStateMap = StatePos.getBlockStateMapFromNBT(tag.m_128437_("blockstatemap", 10));
        BlockPos start = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("startpos"));
        BlockPos end = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("endpos"));
        AABB aabb = new AABB(start, end);
        int[] blocklist = tag.m_128465_("statelist");
        int[] counter = new int[]{0};
        BlockPos.m_121921_((AABB)aabb).map(BlockPos::m_7949_).forEach(pos -> {
            int n = counter[0];
            counter[0] = n + 1;
            int blockStateLookup = blocklist[n];
            BlockState blockState = (BlockState)blockStateMap.get(blockStateLookup);
            statePosList.add(new StatePos(blockState, (BlockPos)pos));
        });
        return statePosList;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag undoTagList = new ListTag();
        for (Map.Entry<UUID, ArrayList<StatePos>> entry : this.undoList.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("uuid", entry.getKey());
            ListTag listTag = new ListTag();
            for (StatePos statePos : entry.getValue()) {
                listTag.add((Object)statePos.getTag());
            }
            compoundTag.m_128365_("stateposlist", (Tag)listTag);
            undoTagList.add((Object)compoundTag);
        }
        nbt.m_128365_("undolist", (Tag)undoTagList);
        ListTag copyPasteTag = new ListTag();
        for (Map.Entry<UUID, ArrayList<StatePos>> entry : this.copyPasteLookup.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("uuid", entry.getKey());
            compoundTag.m_128365_("stateposlist", (Tag)BG2Data.statePosListToNBTMapArray(entry.getValue()));
            copyPasteTag.add((Object)compoundTag);
        }
        nbt.m_128365_("copypaste", (Tag)copyPasteTag);
        ListTag listTag = new ListTag();
        for (Map.Entry<UUID, ArrayList<TagPos>> entry : this.teMap.entrySet()) {
            CompoundTag tempTag = new CompoundTag();
            tempTag.m_128362_("uuid", entry.getKey());
            ListTag tempList = new ListTag();
            for (TagPos tagPos : entry.getValue()) {
                tempList.add((Object)tagPos.getTag());
            }
            tempTag.m_128365_("temaplist", (Tag)tempList);
            listTag.add((Object)tempTag);
        }
        nbt.m_128365_("temaptag", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (Map.Entry entry : this.redprintLookup.entrySet()) {
            CompoundTag tempTag = new CompoundTag();
            tempTag.m_128362_("uuid", (UUID)entry.getKey());
            tempTag.m_128359_("name", (String)entry.getValue());
            listTag2.add((Object)tempTag);
        }
        nbt.m_128365_("redprinttag", (Tag)listTag2);
        return nbt;
    }

    public static BG2Data readNbt(CompoundTag nbt) {
        HashMap<UUID, ArrayList<StatePos>> undoList = new HashMap<UUID, ArrayList<StatePos>>();
        ListTag undoTagList = nbt.m_128437_("undolist", 10);
        for (int i = 0; i < undoTagList.size(); ++i) {
            UUID uuid = undoTagList.m_128728_(i).m_128342_("uuid");
            ListTag statePosList = undoTagList.m_128728_(i).m_128437_("stateposlist", 10);
            ArrayList<StatePos> tempList = new ArrayList<StatePos>();
            for (int j = 0; j < statePosList.size(); ++j) {
                tempList.add(new StatePos(statePosList.m_128728_(j)));
            }
            undoList.put(uuid, tempList);
        }
        HashMap<UUID, ArrayList<StatePos>> copyPaste = new HashMap<UUID, ArrayList<StatePos>>();
        ListTag copyPasteList = nbt.m_128437_("copypaste", 10);
        for (int i = 0; i < copyPasteList.size(); ++i) {
            UUID uuid = copyPasteList.m_128728_(i).m_128342_("uuid");
            CompoundTag statePosList = copyPasteList.m_128728_(i).m_128469_("stateposlist");
            copyPaste.put(uuid, BG2Data.statePosListFromNBTMapArray(statePosList));
        }
        HashMap<UUID, ArrayList<TagPos>> teMap = new HashMap<UUID, ArrayList<TagPos>>();
        ListTag teMapListTag = nbt.m_128437_("temaptag", 10);
        for (int i = 0; i < teMapListTag.size(); ++i) {
            UUID uuid = teMapListTag.m_128728_(i).m_128342_("uuid");
            ListTag temaplistTag = teMapListTag.m_128728_(i).m_128437_("temaplist", 10);
            ArrayList<TagPos> tagPosList = new ArrayList<TagPos>();
            for (int j = 0; j < temaplistTag.size(); ++j) {
                TagPos tagPos = new TagPos(temaplistTag.m_128728_(j));
                tagPosList.add(tagPos);
            }
            teMap.put(uuid, tagPosList);
        }
        HashBiMap redPrints = HashBiMap.create();
        ListTag redPrintsTag = nbt.m_128437_("redprinttag", 10);
        for (int i = 0; i < redPrintsTag.size(); ++i) {
            UUID uuid = redPrintsTag.m_128728_(i).m_128342_("uuid");
            String name = redPrintsTag.m_128728_(i).m_128461_("name");
            redPrints.put((Object)uuid, (Object)name);
        }
        return new BG2Data(undoList, copyPaste, teMap, (BiMap<UUID, String>)redPrints);
    }

    public static BG2Data get(ServerLevel world) {
        BG2Data bg2Data = (BG2Data)world.m_8895_().m_164861_(BG2Data::readNbt, () -> new BG2Data(new HashMap<UUID, ArrayList<StatePos>>(), new HashMap<UUID, ArrayList<StatePos>>(), new HashMap<UUID, ArrayList<TagPos>>(), (BiMap<UUID, String>)HashBiMap.create()), NAME);
        bg2Data.m_77762_();
        return bg2Data;
    }
}

