/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.wildernature.block.BountyBoardBlock;
import net.satisfy.wildernature.block.entity.BountyBoardBlockEntity;
import net.satisfy.wildernature.client.model.block.BountyBoardModel;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import org.joml.Quaternionf;

public class BountyBoardRenderer
implements BlockEntityRenderer<BountyBoardBlockEntity> {
    private static final ResourceLocation TEXTURE = new WilderNatureIdentifier("textures/entity/bounty_board.png");
    private final BountyBoardModel<?> model;

    public BountyBoardRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new BountyBoardModel(context.m_173582_(BountyBoardModel.LAYER_LOCATION));
    }

    public void render(BountyBoardBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        BlockState blockState = blockEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)BountyBoardBlock.FACING);
        poseStack.m_85836_();
        switch (direction) {
            case NORTH: {
                poseStack.m_85837_(0.5, 1.5, 0.5);
                poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(0.0)));
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(0.5, 1.5, 0.5);
                poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(180.0)));
                break;
            }
            case WEST: {
                poseStack.m_85837_(0.5, 1.5, 0.5);
                poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(90.0)));
                break;
            }
            case EAST: {
                poseStack.m_85837_(0.5, 1.5, 0.5);
                poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(-90.0)));
            }
        }
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(180.0)));
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        this.model.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

