/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.data;

import com.mrcrayfish.framework.Registration;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.data.CommonBlockModelProvider;
import com.mrcrayfish.furniture.refurbished.data.CommonItemModelProvider;
import com.mrcrayfish.furniture.refurbished.data.ExtraModelProvider;
import com.mrcrayfish.furniture.refurbished.data.model.ModelTemplate;
import com.mrcrayfish.furniture.refurbished.data.model.PreparedItem;
import com.mrcrayfish.furniture.refurbished.data.model.PreparedVariantBlockState;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class FurnitureModelProvider
extends BlockStateProvider {
    public static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");
    public static final ExistingFileHelper.ResourceType MODEL = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".json", "models");
    private final ExtraModelProvider extraModelProvider;
    private final ExistingFileHelper helper;

    public FurnitureModelProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "refurbished_furniture", helper);
        this.extraModelProvider = new ExtraModelProvider(output, "refurbished_furniture", helper);
        this.helper = helper;
    }

    private void registerExistingResources() {
        ModelTemplate.all().forEach(model -> this.helper.trackGenerated(model, (ExistingFileHelper.IResourceType)MODEL));
        Registration.get((ResourceKey)Registries.f_256747_).stream().filter(entry -> entry.getId().m_135827_().equals("refurbished_furniture")).forEach(entry -> this.helper.trackGenerated(this.blockTexture((Block)entry.get()), (ExistingFileHelper.IResourceType)TEXTURE));
        WoodType.m_61843_().forEach(type -> this.helper.trackGenerated(new ResourceLocation("refurbished_furniture", "block/" + this.sanitizeName(type.f_61839_()) + "_particle"), (ExistingFileHelper.IResourceType)TEXTURE));
        Arrays.stream(DyeColor.values()).forEach(type -> this.helper.trackGenerated(new ResourceLocation("refurbished_furniture", "block/" + this.sanitizeName(type.m_41065_()) + "_particle"), (ExistingFileHelper.IResourceType)TEXTURE));
        Arrays.stream(MetalType.values()).forEach(type -> this.helper.trackGenerated(new ResourceLocation("refurbished_furniture", "block/" + this.sanitizeName(type.getName()) + "_particle"), (ExistingFileHelper.IResourceType)TEXTURE));
    }

    private String sanitizeName(String name) {
        return name.replaceAll("[^a-z]", "_");
    }

    protected void registerStatesAndModels() {
        this.registerExistingResources();
        new CommonBlockModelProvider(builder -> {
            Block block = builder.getBlock();
            VariantBlockStateBuilder blockStateBuilder = this.getVariantBuilder(block);
            builder.getVariants().forEach(entry -> {
                VariantBlockStateBuilder.PartialBlockstate state = blockStateBuilder.partialState();
                for (Map.Entry<Property, Comparable> property : entry.getValueMap().entrySet()) {
                    state = state.with(property.getKey(), property.getValue());
                }
                ConfiguredModel.Builder configuredBuilder = ConfiguredModel.builder();
                PreparedVariantBlockState.Model[] models = entry.getModels();
                for (int i = 0; i < models.length; ++i) {
                    PreparedVariantBlockState.Model model = models[i];
                    configuredBuilder.modelFile(this.createModelFileFromVariant(model)).rotationX(model.getXRotation().ordinal() * 90).rotationY(model.getYRotation().ordinal() * 90);
                    if (i >= models.length - 1) continue;
                    configuredBuilder = configuredBuilder.nextModel();
                }
                state.setModels(configuredBuilder.build());
            });
            Optional.ofNullable((Item)Item.f_41373_.get(block)).ifPresent(item -> Optional.ofNullable(builder.getVariantForItem()).map(PreparedVariantBlockState.Entry::getModels).ifPresent(models -> {
                if (((PreparedVariantBlockState.Model[])models).length > 0) {
                    PreparedVariantBlockState.Model model = models[0];
                    ResourceLocation itemName = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item));
                    ResourceLocation modelLocation = new ResourceLocation("refurbished_furniture", "block/" + model.getName());
                    ((ItemModelBuilder)this.itemModels().getBuilder(itemName.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(modelLocation));
                }
            }));
        }, builder -> {
            Block block = builder.getBlock();
            MultiPartBlockStateBuilder blockStateBuilder = this.getMultipartBuilder(block);
            builder.getParts().forEach(entry -> {
                ConfiguredModel.Builder configuredBuilder = blockStateBuilder.part();
                PreparedVariantBlockState.Model[] models = entry.getModels();
                for (int i = 0; i < models.length; ++i) {
                    PreparedVariantBlockState.Model model = models[i];
                    configuredBuilder.modelFile(this.createModelFileFromVariant(model)).rotationX(model.getXRotation().ordinal() * 90).rotationY(model.getYRotation().ordinal() * 90);
                    if (i >= models.length - 1) continue;
                    configuredBuilder = configuredBuilder.nextModel();
                }
                MultiPartBlockStateBuilder.PartBuilder partBuilder = (MultiPartBlockStateBuilder.PartBuilder)configuredBuilder.addModel();
                partBuilder.useOr = entry.isOrMode();
                entry.getValueMap().forEach((property, comparable) -> partBuilder.condition(property, new Comparable[]{comparable}));
            });
            Optional.ofNullable((Item)Item.f_41373_.get(block)).ifPresent(item -> Optional.ofNullable(builder.getModelForItem()).ifPresent(model -> {
                ResourceLocation itemName = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item));
                ItemModelBuilder modelBuilder = (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(itemName.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(model.getModel()));
                TextureMapping textures = model.getTextures();
                Arrays.stream(model.getSlots()).forEach(slot -> modelBuilder.texture(slot.m_125897_(), textures.m_125756_(slot)));
            }));
        }, model -> {
            BlockModelBuilder modelBuilder = (BlockModelBuilder)this.extraModelProvider.withExistingParent(model.getName(), model.getModel());
            Arrays.stream(model.getSlots()).forEach(slot -> modelBuilder.texture(slot.m_125897_(), model.getTextures().m_125756_(slot)));
        }).run();
        new CommonItemModelProvider(prepared -> {
            Item item = prepared.getItem();
            ResourceLocation itemName = ModelLocationUtils.m_125571_((Item)item);
            PreparedItem.Model model = prepared.getModel();
            ItemModelBuilder builder = (ItemModelBuilder)this.itemModels().getBuilder(itemName.toString());
            builder.parent((ModelFile)new ModelFile.UncheckedModelFile(model.getModel()));
            for (TextureSlot slot : model.getSlots()) {
                builder.texture(slot.m_125897_(), model.getTextures().m_125756_(slot));
            }
        }).run();
    }

    private ModelFile createModelFileFromVariant(PreparedVariantBlockState.Model model) {
        if (model.isChild()) {
            BlockModelBuilder modelBuilder = (BlockModelBuilder)this.models().withExistingParent(model.getName(), model.getModel());
            TextureMapping textures = model.getTextures();
            Arrays.stream(model.getSlots()).forEach(slot -> modelBuilder.texture(slot.m_125897_(), textures.m_125756_(slot)));
            return modelBuilder;
        }
        return this.models().getExistingFile(model.getModel());
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.extraModelProvider.clear();
        return CompletableFuture.allOf(super.m_213708_(cache), this.extraModelProvider.generateAll(cache));
    }
}

